/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexCacheEntry;
import org.opencms.flex.CmsFlexCacheException;
import org.opencms.flex.CmsFlexCacheKey;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsDateUtil;

public class CmsFlexResponse
extends HttpServletResponseWrapper {
    public static final char FLEX_CACHE_DELIMITER = '\u0000';
    public static final String SET_HEADER = "[setHeader]";
    protected static final Log LOG = CmsLog.getLog(CmsFlexResponse.class);
    private Map m_bufferHeaders;
    private String m_bufferRedirect;
    private byte[] m_cacheBytes;
    private CmsFlexCacheEntry m_cachedEntry;
    private boolean m_cachingRequired;
    private CmsFlexController m_controller;
    private String m_encoding;
    private Map m_headers;
    private List m_includeList;
    private List m_includeListParameters;
    private boolean m_includeMode;
    private List m_includeResults;
    private boolean m_isTopElement;
    private CmsFlexCacheKey m_key;
    private CmsServletOutputStream m_out;
    private boolean m_parentWritesOnlyToBuffer;
    private HttpServletResponse m_res;
    private boolean m_suspended;
    private boolean m_typeSet;
    private boolean m_writeOnlyToBuffer;
    private PrintWriter m_writer;

    public CmsFlexResponse(HttpServletResponse res, CmsFlexController controller) {
        super(res);
        this.m_res = res;
        this.m_controller = controller;
        this.m_encoding = controller.getCurrentResponse().getEncoding();
        this.m_isTopElement = controller.getCurrentResponse().isTopElement();
        this.m_parentWritesOnlyToBuffer = controller.getCurrentResponse().hasIncludeList() && !controller.isForwardMode();
        this.setOnlyBuffering(this.m_parentWritesOnlyToBuffer);
        this.m_headers = new HashMap(16);
        this.m_bufferHeaders = new HashMap(8);
    }

    public CmsFlexResponse(HttpServletResponse res, CmsFlexController controller, boolean streaming, boolean isTopElement) {
        super(res);
        this.m_res = res;
        this.m_controller = controller;
        this.m_encoding = controller.getCmsObject().getRequestContext().getEncoding();
        this.m_isTopElement = isTopElement;
        this.m_parentWritesOnlyToBuffer = !streaming && !controller.isForwardMode();
        this.setOnlyBuffering(this.m_parentWritesOnlyToBuffer);
        this.m_headers = new HashMap(16);
        this.m_bufferHeaders = new HashMap(8);
    }

    public static void processHeaders(Map headers, HttpServletResponse res) {
        if (headers != null) {
            Iterator i = headers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                List l = (List)entry.getValue();
                for (int j = 0; j < l.size(); ++j) {
                    if (j == 0 && ((String)l.get(0)).startsWith(SET_HEADER)) {
                        String s = (String)l.get(0);
                        res.setHeader(key, s.substring(SET_HEADER.length()));
                        continue;
                    }
                    res.addHeader(key, (String)l.get(j));
                }
            }
        }
    }

    public void addCookie(Cookie cookie) {
        if (cookie == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_ADD_COOKIE_0"));
        }
        StringBuffer header = new StringBuffer(128);
        header.append(cookie.getName());
        header.append('=');
        header.append(cookie.getValue());
        if (cookie.getVersion() == 1) {
            header.append("; Version=1");
            if (cookie.getComment() != null) {
                header.append("; Comment=");
                header.append(cookie.getComment());
            }
        }
        if (cookie.getDomain() != null) {
            header.append("; Domain=");
            header.append(cookie.getDomain());
        }
        if (cookie.getMaxAge() >= 0) {
            if (cookie.getVersion() == 0) {
                header.append("; Expires=");
                long time = cookie.getMaxAge() == 0 ? 10000L : System.currentTimeMillis() + (long)cookie.getMaxAge() * 1000L;
                header.append(CmsDateUtil.getOldCookieDate(time));
            } else {
                header.append("; Max-Age=");
                header.append(cookie.getMaxAge());
            }
        }
        if (cookie.getPath() != null) {
            header.append("; Path=");
            header.append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            header.append("; Secure");
        }
        this.addHeader("Set-Cookie", header.toString());
    }

    public void addDateHeader(String name, long date) {
        this.addHeader(name, CmsDateUtil.getHeaderDate(date));
    }

    public void addHeader(String name, String value) {
        if (this.isSuspended()) {
            return;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
            return;
        }
        if (this.m_cachingRequired && !this.m_includeMode) {
            this.addHeaderList(this.m_bufferHeaders, name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ADDING_HEADER_TO_ELEMENT_BUFFER_2", name, value));
            }
        }
        if (this.m_writeOnlyToBuffer) {
            this.addHeaderList(this.m_headers, name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ADDING_HEADER_TO_HEADERS_2", name, value));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ADDING_HEADER_TO_PARENT_RESPONSE_2", name, value));
            }
            this.m_res.addHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addToIncludeList(String target, Map parameterMap) {
        if (this.m_includeList == null) {
            this.m_includeList = new ArrayList(10);
            this.m_includeListParameters = new ArrayList(10);
        }
        this.m_includeListParameters.add(parameterMap);
        this.m_includeList.add(target);
    }

    public void flushBuffer() throws IOException {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isPreventResponseFlush()) {
            return;
        }
        super.flushBuffer();
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public Map getHeaders() {
        return this.m_headers;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_out == null) {
            this.initStream();
        }
        return this.m_out;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_writer == null) {
            this.initStream();
        }
        return this.m_writer;
    }

    public byte[] getWriterBytes() {
        if (this.isSuspended()) {
            return new byte[0];
        }
        if (this.m_cacheBytes != null) {
            return this.m_cacheBytes;
        }
        if (this.m_out == null) {
            return new byte[0];
        }
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        return this.m_out.getBytes();
    }

    public boolean isSuspended() {
        return this.m_suspended;
    }

    public boolean isTopElement() {
        return this.m_isTopElement;
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isSuspended() && !location.equals(this.m_bufferRedirect)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_SENDREDIRECT_1", location));
        }
        if (this.m_cachingRequired && !this.m_includeMode) {
            this.m_bufferRedirect = location;
        }
        if (!this.m_cachingRequired) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_TOPRESPONSE_SENDREDIRECT_1", location));
            }
            if (LOG.isWarnEnabled() && this.m_controller.getResponseStackSize() > 2) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_REDIRECTWARNING_3", this.m_controller.getCmsResource().getRootPath(), this.m_controller.getCurrentRequest().getElementUri(), location));
            }
            HttpServletResponse topRes = this.m_controller.getTopResponse();
            CmsFlexResponse.processHeaders(this.getHeaders(), topRes);
            topRes.sendRedirect(location);
        }
        this.m_controller.suspendFlexResponse();
    }

    public void setContentType(String type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_SETTING_CONTENTTYPE_1", type));
        }
        if (!this.m_typeSet && this.m_isTopElement) {
            this.m_typeSet = true;
            super.setContentType(type);
            return;
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, CmsDateUtil.getHeaderDate(date));
    }

    public void setHeader(String name, String value) {
        if (this.isSuspended()) {
            return;
        }
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
            return;
        }
        if (this.m_cachingRequired && !this.m_includeMode) {
            this.setHeaderList(this.m_bufferHeaders, name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_SETTING_HEADER_IN_ELEMENT_BUFFER_2", name, value));
            }
        }
        if (this.m_writeOnlyToBuffer) {
            this.setHeaderList(this.m_headers, name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_SETTING_HEADER_IN_HEADERS_2", name, value));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_SETTING_HEADER_IN_PARENT_RESPONSE_2", name, value));
            }
            this.m_res.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, "" + value);
    }

    public void setOnlyBuffering(boolean value) {
        boolean bl = this.m_writeOnlyToBuffer = value && !this.m_controller.isForwardMode();
        if (this.m_writeOnlyToBuffer) {
            this.setCmsCachingRequired(true);
        }
    }

    void addToIncludeResults(byte[] result) {
        if (this.m_includeResults == null) {
            this.m_includeResults = new ArrayList(10);
        }
        this.m_includeResults.add(result);
    }

    CmsFlexCacheKey getCmsCacheKey() {
        return this.m_key;
    }

    boolean hasIncludeList() {
        return this.m_includeList != null;
    }

    CmsFlexCacheEntry processCacheEntry() throws IOException {
        if (this.isSuspended() && this.m_bufferRedirect == null) {
            return null;
        }
        if (this.m_cachingRequired) {
            this.m_cachedEntry = new CmsFlexCacheEntry();
            if (this.m_bufferRedirect != null) {
                this.m_cachedEntry.setRedirect(this.m_bufferRedirect);
            } else {
                this.m_cachedEntry.addHeaders(this.m_bufferHeaders);
                if (this.m_includeList != null) {
                    this.processIncludeList();
                } else {
                    this.m_cachedEntry.add(this.getWriterBytes());
                }
            }
            this.m_cachedEntry.complete();
        }
        if (this.m_writeOnlyToBuffer) {
            this.m_cachingRequired = false;
            if (this.m_bufferRedirect != null) {
                this.sendRedirect(this.m_bufferRedirect);
            } else if (this.m_parentWritesOnlyToBuffer) {
                if (this.m_out != null) {
                    try {
                        this.m_out.clear();
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ERROR_FLUSHING_OUTPUT_STREAM_1", e));
                        }
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ERROR_OUTPUT_STREAM_NULL_0"));
                }
                this.writeCachedResultToStream((HttpServletResponse)this);
            } else {
                CmsFlexResponse.processHeaders(this.m_headers, this.m_res);
                this.writeCachedResultToStream(this.m_res);
            }
        }
        return this.m_cachedEntry;
    }

    void setCmsCacheKey(CmsFlexCacheKey value) {
        this.m_key = value;
    }

    CmsFlexCacheKey setCmsCacheKey(String resourcename, String cacheDirectives, boolean online) throws CmsFlexCacheException {
        this.m_key = new CmsFlexCacheKey(resourcename, cacheDirectives, online);
        if (this.m_key.hadParseError()) {
            throw new CmsFlexCacheException(Messages.get().container("LOG_FLEXRESPONSE_PARSE_ERROR_IN_CACHE_KEY_2", cacheDirectives, resourcename));
        }
        return this.m_key;
    }

    void setCmsCachingRequired(boolean value) {
        this.m_cachingRequired = (value || this.m_writeOnlyToBuffer) && !this.m_controller.isForwardMode();
    }

    void setCmsIncludeMode(boolean value) {
        this.m_includeMode = value;
    }

    void setSuspended(boolean value) {
        this.m_suspended = value;
    }

    void writeToOutputStream(byte[] bytes, boolean useArray) throws IOException {
        if (this.isSuspended()) {
            return;
        }
        if (this.m_writeOnlyToBuffer) {
            if (useArray) {
                this.m_cacheBytes = bytes;
            } else {
                if (this.m_out == null) {
                    this.initStream();
                }
                this.m_out.write(bytes);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_ERROR_WRITING_TO_OUTPUT_STREAM_0"));
            }
            this.m_res.getOutputStream().write(bytes);
            this.m_res.getOutputStream().flush();
        }
    }

    private void addHeaderList(Map headers, String name, String value) {
        ArrayList<String> values = (ArrayList<String>)headers.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            headers.put(name, values);
        }
        values.add(value);
    }

    private void initStream() throws IOException {
        if (this.m_out == null) {
            this.m_out = !this.m_writeOnlyToBuffer ? (this.m_cachingRequired || this.m_controller.getResponseStackSize() > 1 ? new CmsServletOutputStream(this.m_res.getOutputStream()) : (CmsServletOutputStream)this.m_res.getOutputStream()) : new CmsServletOutputStream();
        }
        if (this.m_writer == null) {
            this.m_writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)((Object)this.m_out), this.m_encoding)), false);
        }
    }

    private void processIncludeList() {
        byte[] result = this.getWriterBytes();
        if (!this.hasIncludeList()) {
            this.m_cachedEntry.add(result);
        } else {
            byte[] piece;
            int max = result.length;
            int pos = 0;
            int last = 0;
            int size = 0;
            int count = 0;
            int i = 0;
            int j = 0;
            while (i < this.m_includeList.size() && pos < max) {
                while (pos < max && result[pos] != 0) {
                    ++pos;
                }
                if (pos >= max || result[pos] != 0) continue;
                ++count;
                size = pos - last;
                if (size > 0) {
                    piece = new byte[size];
                    System.arraycopy(result, last, piece, 0, size);
                    this.m_cachedEntry.add(piece);
                    piece = null;
                }
                last = ++pos;
                this.m_cachedEntry.add((String)this.m_includeList.get(i++), (Map)this.m_includeListParameters.get(j++));
            }
            if (pos < max) {
                size = max - pos;
                piece = new byte[size];
                System.arraycopy(result, pos, piece, 0, size);
                this.m_cachedEntry.add(piece);
                piece = null;
            }
            if (i >= this.m_includeList.size()) {
                this.m_includeList = null;
                this.m_includeListParameters = null;
            } else {
                this.m_includeList = this.m_includeList.subList(count, this.m_includeList.size());
                this.m_includeListParameters = this.m_includeListParameters.subList(count, this.m_includeListParameters.size());
            }
        }
    }

    private void setHeaderList(Map headers, String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(SET_HEADER + value);
        headers.put(name, values);
    }

    private void writeCachedResultToStream(HttpServletResponse res) throws IOException {
        List elements = this.m_cachedEntry.elements();
        int count = 0;
        if (elements != null) {
            for (int i = 0; i < elements.size(); ++i) {
                Object o = elements.get(i);
                if (o instanceof byte[]) {
                    res.getOutputStream().write((byte[])o);
                    continue;
                }
                if (this.m_includeResults != null && this.m_includeResults.size() > count) {
                    res.getOutputStream().write((byte[])this.m_includeResults.get(count));
                    ++count;
                }
                ++i;
            }
        }
    }

    private static class CmsServletOutputStream
    extends ServletOutputStream {
        private ServletOutputStream m_servletStream;
        private ByteArrayOutputStream m_stream;

        public CmsServletOutputStream() {
            this.m_servletStream = null;
            this.clear();
        }

        public CmsServletOutputStream(ServletOutputStream servletStream) {
            this.m_servletStream = servletStream;
            this.clear();
        }

        public void clear() {
            this.m_stream = new ByteArrayOutputStream(1024);
        }

        public void close() throws IOException {
            if (this.m_stream != null) {
                this.m_stream.close();
            }
            if (this.m_servletStream != null) {
                this.m_servletStream.close();
            }
            super.close();
        }

        public void flush() throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXRESPONSE_FLUSHED_1", this.m_servletStream));
            }
            if (this.m_servletStream != null) {
                this.m_servletStream.flush();
            }
        }

        public byte[] getBytes() {
            return this.m_stream.toByteArray();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.m_stream.write(b, off, len);
            if (this.m_servletStream != null) {
                this.m_servletStream.write(b, off, len);
            }
        }

        public void write(int b) throws IOException {
            this.m_stream.write(b);
            if (this.m_servletStream != null) {
                this.m_servletStream.write(b);
            }
        }

        public void writeToServletStream(byte[] b) throws IOException {
            if (this.m_servletStream != null) {
                this.m_servletStream.write(b);
            }
        }
    }
}

