/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.opencms.db.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsAcceptLanguageHeaderParser
implements Iterator {
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    protected static final Float DEFAULT_QUALITY = new Float(1.0f);
    private static final char LOCALE_SEPARATOR = ',';
    private static final char QUALITY_SEPARATOR = ';';
    private List m_acceptLanguage = new ArrayList(3);
    private List m_locales;

    public CmsAcceptLanguageHeaderParser(HttpServletRequest req, Locale defaultLocale) {
        this(req.getHeader(ACCEPT_LANGUAGE), defaultLocale);
    }

    public CmsAcceptLanguageHeaderParser(String header, Locale defaultLocale) {
        if (header == null) {
            this.m_locales = new ArrayList();
            this.m_locales.add(defaultLocale);
        } else {
            List tokens = CmsStringUtil.splitAsList(header, ',', true);
            Iterator it = tokens.iterator();
            while (it.hasNext()) {
                AcceptLanguage acceptLang = new AcceptLanguage();
                String element = (String)it.next();
                int index = element.indexOf(59);
                if (index != -1) {
                    String q = element.substring(index);
                    element = element.substring(0, index);
                    index = q.indexOf(61);
                    if (index != -1) {
                        try {
                            acceptLang.m_quality = Float.valueOf(q.substring(index + 1));
                        }
                        catch (NumberFormatException useDefault) {
                            // empty catch block
                        }
                    }
                }
                acceptLang.m_locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
                this.m_acceptLanguage.add(acceptLang);
            }
            Collections.sort(this.m_acceptLanguage, Collections.reverseOrder());
            this.m_locales = new ArrayList(this.m_acceptLanguage.size());
            Iterator i = this.m_acceptLanguage.iterator();
            while (i.hasNext()) {
                AcceptLanguage lang = (AcceptLanguage)i.next();
                this.m_locales.add(lang.m_locale);
            }
        }
    }

    public static String createLanguageHeader() {
        List defaultLocales = OpenCms.getLocaleManager().getDefaultLocales();
        Iterator i = defaultLocales.iterator();
        String header = "";
        while (i.hasNext()) {
            Locale loc = (Locale)i.next();
            header = header + loc.getLanguage() + ", ";
        }
        header = header.substring(0, header.length() - 2);
        return header;
    }

    public List getAcceptedLocales() {
        return this.m_locales;
    }

    public boolean hasNext() {
        return !this.m_acceptLanguage.isEmpty();
    }

    public Object next() {
        if (this.m_acceptLanguage.isEmpty()) {
            throw new NoSuchElementException();
        }
        return ((AcceptLanguage)this.m_acceptLanguage.remove((int)0)).m_locale;
    }

    public final void remove() throws CmsIllegalArgumentException {
        throw new CmsRuntimeException(Messages.get().container("ERR_UNSUPPORTED_OPERATION_2", this.getClass().getName(), "remove()"));
    }

    protected static class AcceptLanguage
    implements Comparable {
        Locale m_locale;
        Float m_quality = DEFAULT_QUALITY;

        protected AcceptLanguage() {
        }

        public final int compareTo(Object acceptLang) {
            return this.m_quality.compareTo(((AcceptLanguage)acceptLang).m_quality);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof AcceptLanguage) {
                AcceptLanguage other = (AcceptLanguage)obj;
                return this.m_locale.equals(other.m_locale) && this.m_quality.floatValue() == other.m_quality.floatValue();
            }
            return false;
        }

        public int hashCode() {
            return this.m_locale.hashCode() * (int)((double)this.m_quality.floatValue() * 1117.0);
        }
    }
}

