/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsDefaultLocaleHandler;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.i18n.I_CmsLocaleHandler;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsLocaleManager
implements I_CmsEventListener {
    public static final String LOCALE_HANDLER = "class_locale_handler";
    public static final String PARAMETER_ENCODING = "__encoding";
    public static final String PARAMETER_LOCALE = "__locale";
    private static final Log LOG = CmsLog.getLog(CmsLocaleManager.class);
    private static Locale m_defaultLocale;
    private List m_availableLocales;
    private List m_defaultLocales;
    private boolean m_initialized;
    private I_CmsLocaleHandler m_localeHandler;

    public CmsLocaleManager() {
        CmsLocaleManager.setDefaultLocale();
        this.m_availableLocales = new ArrayList();
        this.m_defaultLocales = new ArrayList();
        this.m_localeHandler = new CmsDefaultLocaleHandler();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_START_0"));
        }
        OpenCms.addCmsEventListener(this, new int[]{5});
    }

    public CmsLocaleManager(Locale defaultLocale) {
        CmsLocaleManager.setDefaultLocale();
        this.m_initialized = false;
        this.m_availableLocales = new ArrayList();
        this.m_defaultLocales = new ArrayList();
        this.m_localeHandler = new CmsDefaultLocaleHandler();
        m_defaultLocale = defaultLocale;
        this.m_defaultLocales.add(defaultLocale);
        this.m_availableLocales.add(defaultLocale);
    }

    public static Locale getDefaultLocale() {
        return m_defaultLocale;
    }

    public static Locale getLocale(String localeName) {
        if (CmsStringUtil.isEmpty(localeName)) {
            return CmsLocaleManager.getDefaultLocale();
        }
        Locale locale = null;
        if (OpenCms.getMemoryMonitor() != null) {
            locale = OpenCms.getMemoryMonitor().getCachedLocale(localeName);
        }
        if (locale != null) {
            return locale;
        }
        try {
            String[] localeNames = CmsStringUtil.splitAsArray(localeName, '_');
            locale = new Locale(localeNames[0], localeNames.length > 1 ? localeNames[1] : "", localeNames.length > 2 ? localeNames[2] : "");
        }
        catch (Throwable t) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_LOCALE_FAILED_1", localeName), t);
            locale = CmsLocaleManager.getDefaultLocale();
        }
        if (OpenCms.getMemoryMonitor() != null) {
            OpenCms.getMemoryMonitor().cacheLocale(localeName, locale);
        }
        return locale;
    }

    public static String getLocaleNames(List localeNames) {
        StringBuffer result = new StringBuffer();
        if (localeNames != null) {
            Iterator i = localeNames.iterator();
            while (i.hasNext()) {
                result.append(i.next().toString());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    public static List getLocales(List localeNames) {
        ArrayList<Locale> result = new ArrayList<Locale>(localeNames.size());
        for (int i = 0; i < localeNames.size(); ++i) {
            result.add(CmsLocaleManager.getLocale(localeNames.get(i).toString().trim()));
        }
        return result;
    }

    public static List getLocales(String localeNames) {
        if (localeNames == null) {
            return null;
        }
        return CmsLocaleManager.getLocales(CmsStringUtil.splitAsList(localeNames, ','));
    }

    public static final String getResourceEncoding(CmsObject cms, CmsResource res) {
        String encoding;
        block4: {
            encoding = null;
            try {
                encoding = cms.readPropertyObject(res, "content-encoding", true).getValue();
                if (encoding != null) {
                    encoding = CmsEncoder.lookupEncoding(encoding.trim(), encoding);
                }
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", res.getRootPath()), (Throwable)e);
            }
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return encoding;
    }

    private static void setDefaultLocale() {
        Locale oldLocale = Locale.getDefault();
        if (!Locale.ENGLISH.getLanguage().equals(oldLocale.getLanguage())) {
            try {
                Locale.setDefault(Locale.ENGLISH);
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_DEFAULT_LOCALE_2", Locale.ENGLISH, oldLocale));
                }
            }
            catch (Exception e) {
                CmsLog.INIT.error((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_SET_DEFAULT_LOCALE_2", Locale.ENGLISH, oldLocale), (Throwable)e);
            }
        } else if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_KEEPING_DEFAULT_LOCALE_1", oldLocale));
        }
        m_defaultLocale = Locale.getDefault();
    }

    public void addAvailableLocale(String localeName) {
        Locale locale = CmsLocaleManager.getLocale(localeName);
        if (!this.m_availableLocales.contains(locale)) {
            this.m_availableLocales.add(locale);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_ADD_LOCALE_1", locale));
            }
        }
        if (!this.m_availableLocales.contains(locale = new Locale(locale.getLanguage(), locale.getCountry()))) {
            this.m_availableLocales.add(locale);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_ADD_LOCALE_1", locale));
            }
        }
        if (!this.m_availableLocales.contains(locale = new Locale(locale.getLanguage()))) {
            this.m_availableLocales.add(locale);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_ADD_LOCALE_1", locale));
            }
        }
    }

    public void addDefaultLocale(String localeName) {
        Locale locale = CmsLocaleManager.getLocale(localeName);
        if (!this.m_defaultLocales.contains(locale)) {
            this.m_defaultLocales.add(locale);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_DEFAULT_LOCALE_2", new Integer(this.m_defaultLocales.size()), locale));
            }
        }
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 5: {
                this.clearCaches();
                break;
            }
        }
    }

    public List getAvailableLocales() {
        return this.m_availableLocales;
    }

    public List getAvailableLocales(CmsObject cms, String resourceName) {
        String availableNames = null;
        try {
            availableNames = cms.readPropertyObject(resourceName, "locale-available", true).getValue();
        }
        catch (CmsException exc) {
            // empty catch block
        }
        List result = null;
        if (availableNames != null) {
            result = this.getAvailableLocales(availableNames);
        }
        if (result == null || result.size() == 0) {
            return this.m_availableLocales;
        }
        return result;
    }

    public List getAvailableLocales(String names) {
        return this.checkLocaleNames(CmsLocaleManager.getLocales(names));
    }

    public Locale getBestMatchingLocale(Locale requestedLocale, List defaults, Collection available) {
        Locale check;
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.contains(requestedLocale)) {
            return requestedLocale;
        }
        if (requestedLocale.getVariant().length() > 0 && available.contains(check = new Locale(requestedLocale.getLanguage(), requestedLocale.getCountry(), ""))) {
            return check;
        }
        if (requestedLocale.getCountry().length() > 0 && available.contains(check = new Locale(requestedLocale.getLanguage(), "", ""))) {
            return check;
        }
        if (defaults == null || defaults.isEmpty()) {
            return null;
        }
        return this.getFirstMatchingLocale(defaults, available);
    }

    public Locale getDefaultLocale(CmsObject cms, String resourceName) {
        List defaultLocales = this.getDefaultLocales(cms, resourceName);
        Locale result = defaultLocales.size() > 0 ? (Locale)defaultLocales.get(0) : CmsLocaleManager.getDefaultLocale();
        return result;
    }

    public List getDefaultLocales() {
        return this.m_defaultLocales;
    }

    public List getDefaultLocales(CmsObject cms, CmsResource resource) {
        String defaultNames = null;
        try {
            defaultNames = cms.readPropertyObject(resource, "locale", true).getValue();
        }
        catch (CmsException e) {
            LOG.warn((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", cms.getSitePath(resource)), (Throwable)e);
        }
        return this.getDefaultLocales(defaultNames);
    }

    public List getDefaultLocales(CmsObject cms, String resourceName) {
        String defaultNames = null;
        try {
            defaultNames = cms.readPropertyObject(resourceName, "locale", true).getValue();
        }
        catch (CmsException e) {
            LOG.warn((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", resourceName), (Throwable)e);
        }
        return this.getDefaultLocales(defaultNames);
    }

    public Locale getFirstMatchingLocale(List locales, Collection available) {
        Locale locale;
        Iterator i = locales.iterator();
        while (i.hasNext()) {
            locale = (Locale)i.next();
            if (!available.contains(locale)) continue;
            return locale;
        }
        i = locales.iterator();
        while (i.hasNext()) {
            locale = (Locale)i.next();
            if (locale.getVariant().length() <= 0 || !available.contains(locale = new Locale(locale.getLanguage(), locale.getCountry(), ""))) continue;
            return locale;
        }
        i = locales.iterator();
        while (i.hasNext()) {
            locale = (Locale)i.next();
            if (locale.getCountry().length() <= 0 || !available.contains(locale = new Locale(locale.getLanguage(), "", ""))) continue;
            return locale;
        }
        return null;
    }

    public CmsI18nInfo getI18nInfo(HttpServletRequest req, CmsUser user, CmsProject project, String resource) {
        CmsI18nInfo i18nInfo = null;
        if (OpenCms.getSiteManager().isWorkplaceRequest(req)) {
            List wpLocalizedFolders = OpenCms.getWorkplaceManager().getLocalizedFolders();
            for (int i = wpLocalizedFolders.size() - 1; i >= 0; --i) {
                if (!resource.startsWith((String)wpLocalizedFolders.get(i))) continue;
                i18nInfo = OpenCms.getWorkplaceManager().getI18nInfo(req, user, project, resource);
                break;
            }
        }
        if (i18nInfo == null) {
            i18nInfo = this.m_localeHandler.getI18nInfo(req, user, project, resource);
        }
        Locale locale = null;
        String encoding = null;
        if (req != null) {
            String localeParam = req.getParameter(PARAMETER_LOCALE);
            if (localeParam != null) {
                locale = CmsLocaleManager.getLocale(localeParam);
            }
            encoding = req.getParameter(PARAMETER_ENCODING);
        }
        if (locale == null) {
            locale = i18nInfo.getLocale();
        }
        if (encoding == null) {
            encoding = i18nInfo.getEncoding();
        }
        if (locale == null) {
            locale = CmsLocaleManager.getDefaultLocale();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCALE_NOT_FOUND_1", locale));
            }
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ENCODING_NOT_FOUND_1", encoding));
            }
        }
        return new CmsI18nInfo(locale, encoding);
    }

    public I_CmsLocaleHandler getLocaleHandler() {
        return this.m_localeHandler;
    }

    public void initialize(CmsObject cms) {
        this.m_localeHandler.initHandler(cms);
        m_defaultLocale = (Locale)this.m_defaultLocales.get(0);
        this.m_initialized = true;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_VFSACCESS_0"));
        }
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public void setLocaleHandler(I_CmsLocaleHandler localeHandler) {
        if (localeHandler != null) {
            this.m_localeHandler = localeHandler;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_I18N_CONFIG_LOC_HANDLER_1", this.m_localeHandler.getClass().getName()));
        }
    }

    private List checkLocaleNames(List locales) {
        if (locales == null) {
            return null;
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        Iterator i = locales.iterator();
        while (i.hasNext()) {
            Locale locale = (Locale)i.next();
            if (!this.m_availableLocales.contains(locale)) continue;
            result.add(locale);
        }
        return result;
    }

    private void clearCaches() {
        OpenCms.getMemoryMonitor().flushLocales();
        CmsResourceBundleLoader.flushBundleCache();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCALE_MANAGER_FLUSH_CACHE_1", "EVENT_CLEAR_CACHES"));
        }
    }

    private List getDefaultLocales(String defaultNames) {
        List result = null;
        if (defaultNames != null) {
            result = this.getAvailableLocales(defaultNames);
        }
        if (result == null || result.size() == 0) {
            return this.getDefaultLocales();
        }
        return result;
    }

    static {
        CmsLocaleManager.setDefaultLocale();
    }
}

