/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.opencms.i18n.CmsResourceBundle;
import org.opencms.util.CmsFileUtil;

public final class CmsResourceBundleLoader {
    private static Map m_bundleCache;
    private static Locale m_lastDefaultLocale;
    private static BundleKey m_lookupKey;
    private static final Object NULL_ENTRY;

    private CmsResourceBundleLoader() {
    }

    public static synchronized void flushBundleCache() {
        m_bundleCache = new HashMap();
    }

    public static synchronized ResourceBundle getBundle(String baseName, Locale locale) {
        Locale defaultLocale = Locale.getDefault();
        if (defaultLocale != m_lastDefaultLocale) {
            m_bundleCache = new HashMap();
            m_lastDefaultLocale = defaultLocale;
        }
        m_lookupKey.set(baseName, locale);
        Object obj = m_bundleCache.get(m_lookupKey);
        if (obj instanceof CmsResourceBundle) {
            return (CmsResourceBundle)obj;
        }
        if (obj != NULL_ENTRY) {
            boolean wantBase = locale.equals(defaultLocale);
            CmsResourceBundle bundle = CmsResourceBundleLoader.tryBundle(baseName, locale, wantBase);
            if (bundle == null && !locale.equals(defaultLocale)) {
                bundle = CmsResourceBundleLoader.tryBundle(baseName, defaultLocale, true);
            }
            BundleKey key = new BundleKey(baseName, locale);
            if (bundle == null) {
                m_bundleCache.put(key, NULL_ENTRY);
            } else {
                m_bundleCache.put(key, bundle);
                return bundle;
            }
        }
        return ResourceBundle.getBundle(baseName, locale);
    }

    private static CmsResourceBundle tryBundle(String localizedName) {
        CmsResourceBundle bundle = null;
        try {
            InputStream is = null;
            String resourceName = localizedName.replace('.', '/') + ".properties";
            URL url = CmsResourceBundleLoader.class.getClassLoader().getResource(resourceName);
            if (url != null) {
                String path = CmsFileUtil.normalizePath(url);
                File file = new File(path);
                try {
                    is = new FileInputStream(file);
                }
                catch (IOException ex) {
                    is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                }
                catch (AccessControlException acex) {
                    is = CmsResourceBundleLoader.class.getClassLoader().getResourceAsStream(resourceName);
                }
            }
            if (is != null) {
                bundle = new CmsResourceBundle(is);
            }
        }
        catch (IOException ex) {
            MissingResourceException mre = new MissingResourceException("Failed to load bundle '" + localizedName + "'", localizedName, "");
            mre.initCause(ex);
            throw mre;
        }
        return bundle;
    }

    private static CmsResourceBundle tryBundle(String baseName, Locale locale, boolean wantBase) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        int baseLen = baseName.length();
        StringBuffer sb = new StringBuffer(baseLen + variant.length() + 7);
        sb.append(baseName);
        if (language.length() > 0) {
            sb.append('_');
            sb.append(language);
            if (country.length() > 0) {
                sb.append('_');
                sb.append(country);
                if (variant.length() > 0) {
                    sb.append('_');
                    sb.append(variant);
                }
            }
        }
        String bundleName = sb.toString();
        CmsResourceBundle first = null;
        CmsResourceBundle last = null;
        while (true) {
            int idx;
            CmsResourceBundle foundBundle;
            if ((foundBundle = CmsResourceBundleLoader.tryBundle(bundleName)) != null) {
                if (first == null) {
                    first = foundBundle;
                }
                if (last != null) {
                    last.setParent(foundBundle);
                }
                foundBundle.setLocale(locale);
                last = foundBundle;
            }
            if ((idx = bundleName.lastIndexOf(95)) <= baseLen && (idx != baseLen || first == null && !wantBase)) break;
            bundleName = bundleName.substring(0, idx);
        }
        return first;
    }

    static {
        m_lookupKey = new BundleKey();
        NULL_ENTRY = new Object();
    }

    private static class BundleKey {
        private String m_baseName;
        private int m_hashcode;
        private Locale m_locale;

        BundleKey() {
        }

        BundleKey(String s, Locale l) {
            this.set(s, l);
        }

        public boolean equals(Object o) {
            if (!(o instanceof BundleKey)) {
                return false;
            }
            BundleKey key = (BundleKey)o;
            return this.m_hashcode == key.m_hashcode && this.m_baseName.equals(key.m_baseName) && this.m_locale.equals(key.m_locale);
        }

        public int hashCode() {
            return this.m_hashcode;
        }

        public String toString() {
            return this.m_baseName + "_" + this.m_locale;
        }

        void set(String s, Locale l) {
            this.m_baseName = s;
            this.m_locale = l;
            this.m_hashcode = this.m_baseName.hashCode() ^ this.m_locale.hashCode();
        }
    }
}

