/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsExport;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.importexport.CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.importexport.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlException;

public class CmsVfsImportExportHandler
implements I_CmsImportExportHandler {
    private long m_contentAge;
    private String m_description = Messages.get().getBundle().key("GUI_CMSIMPORTHANDLER_DEFAULT_DESC_0");
    private CmsExportParameters m_exportParams;
    private List m_exportPaths;
    private boolean m_exportUserdata;
    private String m_fileName;
    private CmsImportParameters m_importParams;
    private boolean m_includeSystem;
    private boolean m_includeUnchanged;
    private boolean m_projectOnly;
    private boolean m_recursive;

    public void exportData(CmsObject cms, I_CmsReport report) throws CmsImportExportException, CmsRoleViolationException {
        CmsExportParameters parameters = this.getExportParams();
        if (parameters == null) {
            parameters = new CmsExportParameters(this.getFileName(), null, true, this.isExportUserdata(), false, this.getExportPaths(), this.isIncludeSystem(), this.isIncludeUnchanged(), this.getContentAge(), this.isRecursive(), this.isProjectOnly());
        }
        report.println(Messages.get().container("RPT_EXPORT_DB_BEGIN_0"), 2);
        new CmsExport(cms, report).exportData(parameters);
        report.println(Messages.get().container("RPT_EXPORT_DB_END_0"), 2);
    }

    public long getContentAge() {
        return this.m_contentAge;
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsExportParameters getExportParams() {
        return this.m_exportParams;
    }

    public List getExportPaths() {
        return this.m_exportPaths;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public CmsImportParameters getImportParameters() {
        return this.m_importParams;
    }

    public synchronized void importData(CmsObject cms, I_CmsReport report) throws CmsImportExportException, CmsXmlException, CmsRoleViolationException {
        report.println(Messages.get().container("RPT_IMPORT_DB_BEGIN_0"), 2);
        CmsImport vfsImport = new CmsImport(cms, report);
        vfsImport.importData(this.getImportParameters());
        report.println(Messages.get().container("RPT_IMPORT_DB_END_0"), 2);
    }

    public void importData(CmsObject cms, String importFile, String importPath, I_CmsReport report) throws CmsXmlException, CmsImportExportException, CmsRoleViolationException, CmsException {
        CmsImportParameters parameters = new CmsImportParameters(importFile, importPath, true);
        this.setImportParameters(parameters);
        this.importData(cms, report);
    }

    public boolean isExportUserdata() {
        return this.m_exportUserdata;
    }

    public boolean isIncludeSystem() {
        return this.m_includeSystem;
    }

    public boolean isIncludeUnchanged() {
        return this.m_includeUnchanged;
    }

    public boolean isProjectOnly() {
        return this.m_projectOnly;
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }

    public boolean matches(Document manifest) {
        Element rootElement = manifest.getRootElement();
        boolean hasModuleNode = rootElement.selectNodes("./module/name").size() > 0;
        boolean hasInfoNode = rootElement.selectNodes("./info").size() == 1;
        return !hasModuleNode && hasInfoNode;
    }

    public void setContentAge(long contentAge) {
        if (contentAge < 0L) {
            String ageString = Long.toString(contentAge);
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_CONTENT_AGE_1", ageString));
        }
        this.m_contentAge = contentAge;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setExportParams(CmsExportParameters exportParams) {
        this.m_exportParams = exportParams;
    }

    public void setExportPaths(List exportPaths) {
        this.m_exportPaths = exportPaths;
    }

    public void setExportUserdata(boolean exportUserdata) {
        this.m_exportUserdata = exportUserdata;
    }

    public void setFileName(String fileName) {
        if (CmsStringUtil.isEmpty(fileName) || !fileName.trim().equals(fileName)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_FILE_NAME_1", fileName));
        }
        this.m_fileName = fileName;
    }

    public void setImportParameters(CmsImportParameters importParams) {
        this.m_importParams = importParams;
    }

    public void setIncludeSystem(boolean excludeSystem) {
        this.m_includeSystem = excludeSystem;
    }

    public void setIncludeUnchanged(boolean excludeUnchanged) {
        this.m_includeUnchanged = excludeUnchanged;
    }

    public void setProjectOnly(boolean projectOnly) {
        this.m_projectOnly = projectOnly;
    }

    public void setRecursive(boolean recursive) {
        this.m_recursive = recursive;
    }
}

