/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;

public class CmsJspTagContentAccess
extends CmsJspScopedVarBodyTagSuport {
    private static final long serialVersionUID = -9015874900596113856L;
    private Locale m_locale;

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        Tag ancestor = CmsJspTagContentAccess.findAncestorWithClass((Tag)this, (Class)I_CmsXmlContentContainer.class);
        if (ancestor == null) {
            CmsMessageContainer errMsgContainer = Messages.get().container("ERR_PARENTLESS_TAG_1", "contentaccess");
            String msg = Messages.getLocalizedMessage(errMsgContainer, this.pageContext);
            throw new JspTagException(msg);
        }
        I_CmsXmlContentContainer contentContainer = (I_CmsXmlContentContainer)ancestor;
        I_CmsXmlDocument xmlContent = contentContainer.getXmlDocument();
        CmsObject cms = CmsFlexController.getCmsObject(this.pageContext.getRequest());
        Locale locale = this.m_locale == null ? cms.getRequestContext().getLocale() : this.m_locale;
        CmsJspContentAccessBean bean = new CmsJspContentAccessBean(cms, locale, xmlContent);
        this.storeAttribute(bean);
        return 0;
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    public void release() {
        this.m_locale = null;
        super.release();
    }

    public void setLocale(String locale) {
        this.m_locale = CmsStringUtil.isEmpty(locale) ? null : CmsLocaleManager.getLocale(locale);
    }
}

