/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;

public class CmsJspTagContentCheck
extends TagSupport {
    private static final long serialVersionUID = -5996702196453747182L;
    private boolean m_checkall;
    private boolean m_checknone;
    private String m_elementList;
    private Locale m_locale;

    public static boolean contentCheckTagAction(String elementList, String prefix, boolean checkall, boolean checknone, I_CmsXmlDocument content, Locale locale) {
        boolean found = false;
        String[] elements = CmsStringUtil.splitAsArray(elementList, ',');
        for (int i = elements.length - 1; i >= 0; --i) {
            String element = CmsXmlUtils.concatXpath(prefix, elements[i].trim());
            boolean bl = found = found || content.hasValue(element, locale);
            if (found && checknone) {
                return false;
            }
            if (!found || checkall || checknone) continue;
            return true;
        }
        if (!found && checknone) {
            return true;
        }
        return found;
    }

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        boolean result;
        Tag ancestor = CmsJspTagContentCheck.findAncestorWithClass((Tag)this, (Class)I_CmsXmlContentContainer.class);
        if (ancestor == null) {
            CmsMessageContainer errMsgContainer = Messages.get().container("ERR_TAG_CONTENTCHECK_WRONG_PARENT_0");
            String msg = Messages.getLocalizedMessage(errMsgContainer, this.pageContext);
            throw new JspTagException(msg);
        }
        I_CmsXmlContentContainer contentContainer = (I_CmsXmlContentContainer)ancestor;
        String prefix = contentContainer.getXmlDocumentElement();
        I_CmsXmlDocument content = contentContainer.getXmlDocument();
        if (this.m_locale == null) {
            this.m_locale = contentContainer.getXmlDocumentLocale();
        }
        if (result = CmsJspTagContentCheck.contentCheckTagAction(this.m_elementList, prefix, this.m_checkall, this.m_checknone, content, this.m_locale)) {
            return 1;
        }
        return 0;
    }

    public String getIfexists() {
        return this.m_elementList != null ? this.m_elementList : "";
    }

    public String getIfexistsall() {
        return this.m_elementList != null ? this.m_elementList : "";
    }

    public String getIfexistsnone() {
        return this.m_elementList != null ? this.m_elementList : "";
    }

    public String getIfexistsone() {
        return this.m_elementList != null ? this.m_elementList : "";
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    public void release() {
        this.m_checkall = false;
        this.m_checknone = false;
        this.m_elementList = null;
        this.m_locale = null;
        super.release();
    }

    public void setIfexists(String elementList) {
        if (elementList != null) {
            this.m_elementList = elementList;
            this.m_checkall = false;
            this.m_checknone = false;
        }
    }

    public void setIfexistsall(String elementList) {
        if (elementList != null) {
            this.m_elementList = elementList;
            this.m_checkall = true;
            this.m_checknone = false;
        }
    }

    public void setIfexistsnone(String elementList) {
        if (elementList != null) {
            this.m_elementList = elementList;
            this.m_checkall = false;
            this.m_checknone = true;
        }
    }

    public void setIfexistsone(String elementList) {
        if (elementList != null) {
            this.m_elementList = elementList;
            this.m_checkall = false;
            this.m_checknone = false;
        }
    }

    public void setLocale(String locale) {
        this.m_locale = CmsStringUtil.isEmpty(locale) ? null : CmsLocaleManager.getLocale(locale);
    }
}

