/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsContentInfoBean;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspContentLoadBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditButtonSelection;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsJspTagContentLoad
extends CmsJspScopedVarBodyTagSuport
implements I_CmsXmlContentContainer {
    private static final long serialVersionUID = 981176995635225294L;
    private transient CmsObject m_cms;
    private String m_collector;
    private String m_collectorName;
    private String m_collectorParam;
    private List m_collectorResult;
    private transient I_CmsXmlDocument m_content;
    private CmsContentInfoBean m_contentInfoBean;
    private Locale m_contentLocale;
    private CmsFlexController m_controller;
    private CmsDirectEditButtonSelection m_directEditFollowButtons;
    private String m_directEditLinkForNew;
    private CmsDirectEditMode m_directEditMode;
    private boolean m_directEditOpen;
    private boolean m_isFirstLoop;
    private Locale m_locale;
    private String m_pageIndex;
    private String m_pageNavLength;
    private String m_pageSize;
    private String m_param;
    private boolean m_preload;
    private String m_property;
    private String m_resourceName;

    public CmsJspTagContentLoad() {
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, Locale locale, boolean editable) throws JspException {
        this(container, context, collectorName, collectorParam, null, null, locale, editable);
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, String pageIndex, String pageSize, Locale locale, boolean editable) throws JspException {
        this(container, context, collectorName, collectorParam, pageIndex, pageSize, locale, CmsDirectEditMode.valueOf(editable));
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, String pageIndex, String pageSize, Locale locale, CmsDirectEditMode editMode) throws JspException {
        this.setCollector(collectorName);
        this.setParam(collectorParam);
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
        this.m_locale = locale;
        this.m_contentLocale = locale;
        this.m_directEditMode = editMode;
        this.m_preload = false;
        this.setPageContext(context);
        this.init(container);
    }

    protected static String getResourceName(CmsObject cms, I_CmsXmlContentContainer contentContainer) {
        if (contentContainer != null && contentContainer.getResourceName() != null) {
            return contentContainer.getResourceName();
        }
        if (cms != null) {
            return cms.getRequestContext().getUri();
        }
        return null;
    }

    private static List limitCollectorResult(CmsContentInfoBean contentInfoBean, List collectorResult) {
        List result = null;
        int pageCount = -1;
        if (contentInfoBean.getPageSize() > 0) {
            pageCount = collectorResult.size() / contentInfoBean.getPageSize();
            if (collectorResult.size() % contentInfoBean.getPageSize() != 0) {
                ++pageCount;
            }
            contentInfoBean.setPageCount(pageCount);
            int startIndex = (contentInfoBean.getPageIndex() - 1) * contentInfoBean.getPageSize();
            int endIndex = contentInfoBean.getPageIndex() * contentInfoBean.getPageSize();
            if (endIndex > collectorResult.size()) {
                endIndex = collectorResult.size();
            }
            result = collectorResult.subList(startIndex, endIndex);
        } else {
            result = collectorResult;
            if (collectorResult.size() > 0) {
                contentInfoBean.setPageCount(1);
            }
        }
        return result;
    }

    public int doAfterBody() throws JspException {
        if (this.hasMoreContent()) {
            return 2;
        }
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 0;
    }

    public int doEndTag() {
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        Tag ancestor = CmsJspTagContentLoad.findAncestorWithClass((Tag)this, (Class)I_CmsXmlContentContainer.class);
        I_CmsXmlContentContainer container = null;
        if (ancestor != null && !(container = (I_CmsXmlContentContainer)ancestor).isPreloader()) {
            container = null;
        }
        this.init(container);
        this.hasMoreContent();
        return this.isScopeVarSet() ? 0 : 1;
    }

    public String getCollector() {
        return this.m_collector;
    }

    public String getCollectorName() {
        return this.m_collectorName;
    }

    public String getCollectorParam() {
        return this.m_collectorParam;
    }

    public List getCollectorResult() {
        return this.m_collectorResult;
    }

    public String getEditable() {
        return this.m_directEditMode != null ? this.m_directEditMode.toString() : "";
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    public String getPageIndex() {
        return this.m_pageIndex;
    }

    public String getPageNavLength() {
        return this.m_pageNavLength;
    }

    public String getPageSize() {
        return this.m_pageSize;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getPreload() {
        return String.valueOf(this.isPreloader());
    }

    public String getProperty() {
        return this.m_property;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }

    public I_CmsXmlDocument getXmlDocument() {
        return this.m_content;
    }

    public String getXmlDocumentElement() {
        return null;
    }

    public Locale getXmlDocumentLocale() {
        return this.m_contentLocale;
    }

    public boolean hasMoreContent() throws JspException {
        boolean hasMoreContent;
        if (this.m_isFirstLoop) {
            this.m_isFirstLoop = false;
        } else if (this.m_directEditOpen) {
            CmsJspTagEditable.endDirectEdit(this.pageContext);
            this.m_directEditOpen = false;
        }
        if (this.isPreloader()) {
            return false;
        }
        boolean bl = hasMoreContent = this.m_collectorResult.size() > 0;
        if (hasMoreContent) {
            try {
                this.doLoadNextFile();
            }
            catch (CmsException e) {
                this.m_controller.setThrowable(e, this.m_resourceName);
                throw new JspException((Throwable)e);
            }
            if (this.m_directEditMode.isEnabled() && this.m_resourceName != null) {
                CmsDirectEditButtonSelection directEditButtons;
                if (this.m_directEditFollowButtons == null) {
                    if (this.m_directEditLinkForNew == null) {
                        this.m_directEditFollowButtons = directEditButtons = CmsDirectEditButtonSelection.EDIT;
                    } else {
                        directEditButtons = CmsDirectEditButtonSelection.EDIT_DELETE_NEW;
                        this.m_directEditFollowButtons = CmsDirectEditButtonSelection.EDIT_DELETE;
                    }
                } else {
                    directEditButtons = this.m_directEditFollowButtons;
                }
                this.m_directEditOpen = CmsJspTagEditable.startDirectEdit(this.pageContext, new CmsDirectEditParams(this.m_resourceName, directEditButtons, this.m_directEditMode, this.m_directEditLinkForNew));
            }
        } else {
            this.m_locale = null;
        }
        return hasMoreContent;
    }

    public boolean isPreloader() {
        return this.isScopeVarSet() ? true : this.m_preload;
    }

    public void release() {
        this.m_cms = null;
        this.m_collector = null;
        this.m_collectorName = null;
        this.m_collectorParam = null;
        this.m_collectorResult = null;
        this.m_content = null;
        this.m_contentInfoBean = null;
        this.m_contentLocale = null;
        this.m_controller = null;
        this.m_directEditLinkForNew = null;
        this.m_directEditFollowButtons = null;
        this.m_directEditOpen = false;
        this.m_directEditMode = null;
        this.m_isFirstLoop = false;
        this.m_locale = null;
        this.m_pageIndex = null;
        this.m_pageNavLength = null;
        this.m_pageSize = null;
        this.m_param = null;
        this.m_preload = false;
        this.m_property = null;
        this.m_resourceName = null;
        super.release();
    }

    public void setCollector(String collector) {
        this.m_collector = collector;
    }

    public void setEditable(String mode) {
        this.m_directEditMode = CmsDirectEditMode.valueOf(mode);
    }

    public void setLocale(String locale) {
        if (CmsStringUtil.isEmpty(locale)) {
            this.m_locale = null;
            this.m_contentLocale = null;
        } else {
            this.m_contentLocale = this.m_locale = CmsLocaleManager.getLocale(locale);
        }
    }

    public void setPageIndex(String pageIndex) {
        this.m_pageIndex = pageIndex;
    }

    public void setPageNavLength(String pageNavLength) {
        this.m_pageNavLength = pageNavLength;
    }

    public void setPageSize(String pageSize) {
        this.m_pageSize = pageSize;
    }

    public void setParam(String param) {
        this.m_param = param;
    }

    public void setPreload(String preload) {
        this.m_preload = Boolean.valueOf(preload);
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    protected void doLoadNextFile() throws CmsException {
        CmsResource resource = this.getNextResource();
        if (resource == null) {
            this.m_resourceName = null;
            this.m_content = null;
            return;
        }
        this.m_resourceName = this.m_cms.getSitePath(resource);
        CmsFile file = this.m_cms.readFile(resource);
        this.m_content = CmsXmlContentFactory.unmarshal(this.m_cms, (CmsResource)file, this.pageContext.getRequest());
        this.m_contentLocale = this.m_locale;
        if (!this.m_content.hasLocale(this.m_contentLocale)) {
            Iterator it = OpenCms.getLocaleManager().getDefaultLocales().iterator();
            while (it.hasNext()) {
                Locale locale = (Locale)it.next();
                if (!this.m_content.hasLocale(locale)) continue;
                this.m_contentLocale = locale;
                break;
            }
        }
    }

    protected CmsContentInfoBean getContentInfoBean() {
        return this.m_contentInfoBean;
    }

    protected void init(I_CmsXmlContentContainer container) throws JspException {
        I_CmsXmlContentContainer usedContainer;
        int pageAttribCount = 0;
        pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageSize) ? 1 : 0;
        if ((pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageIndex) ? 1 : 0) > 0 && pageAttribCount < 2) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_INDEX_SIZE_0"));
        }
        if (container == null) {
            usedContainer = this;
            if (CmsStringUtil.isEmpty(this.m_collector)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_MISSING_COLLECTOR_0"));
            }
            if (CmsStringUtil.isEmpty(this.m_param)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_MISSING_PARAM_0"));
            }
        } else {
            usedContainer = container;
        }
        if (this.isPreloader()) {
            this.m_directEditMode = CmsDirectEditMode.FALSE;
        } else if (this.m_directEditMode == null) {
            this.m_directEditMode = CmsDirectEditMode.FALSE;
        }
        this.m_controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = this.m_controller.getCmsObject();
        String resourcename = CmsJspTagContentLoad.getResourceName(this.m_cms, usedContainer);
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(this.m_cms).setJspPageContext(this.pageContext).setResourceName(resourcename).setKeepEmptyMacros(true);
        if (container == null) {
            this.m_collectorName = resolver.resolveMacros(this.getCollector());
            this.m_collectorParam = resolver.resolveMacros(this.getParam());
            this.m_collectorResult = null;
        } else {
            this.m_collectorName = usedContainer.getCollectorName();
            this.m_collectorParam = usedContainer.getCollectorParam();
            this.m_collectorResult = usedContainer.getCollectorResult();
            if (this.m_locale == null) {
                this.m_locale = usedContainer.getXmlDocumentLocale();
            }
        }
        if (this.m_locale == null) {
            this.m_locale = this.m_cms.getRequestContext().getLocale();
        }
        try {
            I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(this.m_collectorName);
            if (collector == null) {
                throw new CmsException(Messages.get().container("ERR_COLLECTOR_NOT_FOUND_1", this.m_collectorName));
            }
            if (this.m_collectorResult == null) {
                this.m_collectorResult = collector.getResults(this.m_cms, this.m_collectorName, this.m_collectorParam);
            }
            this.m_contentInfoBean = new CmsContentInfoBean();
            this.m_contentInfoBean.setPageSizeAsString(resolver.resolveMacros(this.m_pageSize));
            this.m_contentInfoBean.setPageIndexAsString(resolver.resolveMacros(this.m_pageIndex));
            this.m_contentInfoBean.setPageNavLengthAsString(resolver.resolveMacros(this.m_pageNavLength));
            this.m_contentInfoBean.setResultSize(this.m_collectorResult.size());
            this.m_contentInfoBean.setLocale(this.m_locale.toString());
            this.m_contentInfoBean.initResultIndex();
            if (!this.isPreloader()) {
                this.m_collectorResult = CmsJspTagContentLoad.limitCollectorResult(this.m_contentInfoBean, this.m_collectorResult);
                this.m_contentInfoBean.initPageNavIndexes();
                String createParam = collector.getCreateParam(this.m_cms, this.m_collectorName, this.m_collectorParam);
                if (createParam != null) {
                    this.m_directEditLinkForNew = CmsEncoder.encode(this.m_collectorName + "|" + createParam);
                }
            } else if (this.isScopeVarSet()) {
                CmsJspContentLoadBean bean = new CmsJspContentLoadBean(this.m_cms, this.m_locale, this.m_collectorResult);
                this.storeAttribute(bean);
            }
        }
        catch (CmsException e) {
            this.m_controller.setThrowable(e, this.m_cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
        this.m_directEditOpen = false;
        this.m_directEditFollowButtons = null;
        this.m_isFirstLoop = true;
    }

    private CmsResource getNextResource() {
        if (this.m_collectorResult != null && this.m_collectorResult.size() > 0) {
            this.m_contentInfoBean.incResultIndex();
            return (CmsResource)this.m_collectorResult.remove(0);
        }
        return null;
    }
}

