/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;

public class CmsJspTagLink
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagLink.class);
    private static final long serialVersionUID = -2361021288258405388L;

    public static String linkTagAction(String target, ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(controller.getCmsObject(), CmsLinkManager.getAbsoluteUri(target, controller.getCurrentRequest().getElementUri()));
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String link = this.getBodyContent().getString();
                this.getBodyContent().clear();
                String newlink = CmsJspTagLink.linkTagAction(link, req);
                this.getBodyContent().print(newlink);
                this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "link"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }
}

