/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagProperty
extends TagSupport {
    private static final long serialVersionUID = -4040833541258687977L;
    public static final String USE_ELEMENT_URI = "element.uri";
    public static final String USE_PARENT = "parent";
    public static final String USE_SEARCH = "search";
    public static final String USE_SEARCH_ELEMENT_URI = "search.element.uri";
    public static final String USE_SEARCH_PARENT = "search-parent";
    public static final String USE_SEARCH_THIS = "search-this";
    public static final String USE_SEARCH_URI = "search.uri";
    public static final String USE_THIS = "this";
    public static final String USE_URI = "uri";
    static final String[] ACTION_VALUES = new String[]{"uri", "parent", "search", "search.uri", "search-parent", "element.uri", "this", "search.element.uri", "search-this"};
    public static final List ACTION_VALUES_LIST = Arrays.asList(ACTION_VALUES);
    private static final Log LOG = CmsLog.getLog(CmsJspTagProperty.class);
    private String m_defaultValue;
    private boolean m_escapeHtml;
    private String m_propertyFile;
    private String m_propertyName;

    public static String propertyTagAction(String property, String action, String defaultValue, boolean escape, ServletRequest req) throws CmsException {
        boolean search;
        String vfsUri;
        CmsFlexController controller = CmsFlexController.getController(req);
        if (action == null) {
            action = ACTION_VALUES[0];
        }
        switch (ACTION_VALUES_LIST.indexOf(action)) {
            case 0: 
            case 1: {
                vfsUri = controller.getCmsObject().getRequestContext().getUri();
                search = false;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                vfsUri = controller.getCmsObject().getRequestContext().getUri();
                search = true;
                break;
            }
            case 5: 
            case 6: {
                vfsUri = controller.getCurrentRequest().getElementUri();
                search = false;
                break;
            }
            case 7: 
            case 8: {
                vfsUri = controller.getCurrentRequest().getElementUri();
                search = true;
                break;
            }
            default: {
                vfsUri = CmsLinkManager.getAbsoluteUri(action, controller.getCurrentRequest().getElementUri());
                search = false;
            }
        }
        String value = controller.getCmsObject().readPropertyObject(vfsUri, property, search).getValue(defaultValue);
        if (escape) {
            value = CmsEncoder.escapeHtml(value);
        }
        return value;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String prop = CmsJspTagProperty.propertyTagAction(this.getName(), this.getFile(), this.m_defaultValue, this.m_escapeHtml, req);
                if (prop == null) {
                    prop = "";
                }
                this.pageContext.getOut().print(prop);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "property"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 0;
    }

    public String getDefault() {
        return this.m_defaultValue != null ? this.m_defaultValue : "";
    }

    public String getEscapeHtml() {
        return "" + this.m_escapeHtml;
    }

    public String getFile() {
        return this.m_propertyFile != null ? this.m_propertyFile : USE_PARENT;
    }

    public String getName() {
        return this.m_propertyName != null ? this.m_propertyName : "";
    }

    public void release() {
        super.release();
        this.m_propertyFile = null;
        this.m_propertyName = null;
        this.m_defaultValue = null;
        this.m_escapeHtml = false;
    }

    public void setDefault(String def) {
        if (def != null) {
            this.m_defaultValue = def;
        }
    }

    public void setEscapeHtml(String value) {
        if (value != null) {
            this.m_escapeHtml = Boolean.valueOf(value.trim());
        }
    }

    public void setFile(String file) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(file)) {
            this.m_propertyFile = file;
        }
    }

    public void setName(String name) {
        if (name != null) {
            this.m_propertyName = name;
        }
    }
}

