/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.decorator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.util.Translate;
import org.opencms.file.CmsObject;
import org.opencms.jsp.decorator.CmsDecorationBundle;
import org.opencms.jsp.decorator.CmsDecorationObject;
import org.opencms.jsp.decorator.CmsDecoratorConfiguration;
import org.opencms.jsp.decorator.I_CmsDecoratorConfiguration;
import org.opencms.jsp.decorator.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsStringUtil;

public class CmsHtmlDecorator
extends CmsHtmlParser {
    private static final String[] DELIMITERS = new String[]{" ", ",", ".", ";", ":", "!", "(", ")", "'", "?", "\"", "&nbsp;", "&quot;", "\r\n", "\n"};
    private static final String[] DELIMITERS_SECOND_LEVEL = new String[]{"-", "@", "/", ".", ","};
    private static final int FORWARD_LOOKUP = 7;
    private static final Log LOG = CmsLog.getLog(CmsHtmlDecorator.class);
    private static final String[] NON_TRANSLATORS = new String[]{"&nbsp;", "&quot;"};
    I_CmsDecoratorConfiguration m_config;
    CmsDecorationBundle m_decorations;
    private boolean m_decorate;
    private CmsObject m_cms;

    public CmsHtmlDecorator(CmsObject cms) throws CmsException {
        this.m_config = new CmsDecoratorConfiguration(cms);
        this.m_decorations = this.m_config.getDecorations();
        this.m_result = new StringBuffer(512);
        this.m_echo = true;
        this.m_decorate = true;
    }

    public CmsHtmlDecorator(CmsObject cms, I_CmsDecoratorConfiguration config) {
        this.m_config = config;
        this.m_decorations = config.getDecorations();
        this.m_result = new StringBuffer(512);
        this.m_echo = true;
        this.m_decorate = true;
        this.m_cms = cms;
    }

    public static List splitAsList(String source, String[] delimiters, boolean trim, boolean includeDelimiters) {
        int j;
        ArrayList<String> result = new ArrayList<String>();
        String delimiter = "";
        int i = 0;
        int l = source.length();
        int n = -1;
        int max = Integer.MAX_VALUE;
        for (j = 0; j < delimiters.length; ++j) {
            if (source.indexOf(delimiters[j]) <= -1 || source.indexOf(delimiters[j]) >= max) continue;
            max = source.indexOf(delimiters[j]);
            n = source.indexOf(delimiters[j]);
            delimiter = delimiters[j];
        }
        while (n != -1) {
            if (i < n || i > 0 && i < l) {
                result.add(trim ? source.substring(i, n).trim() : source.substring(i, n));
                if (includeDelimiters && n + delimiter.length() <= l) {
                    result.add(source.substring(n, n + delimiter.length()));
                }
            } else if (includeDelimiters && source.startsWith(delimiter)) {
                result.add(delimiter);
            }
            i = n + delimiter.length();
            max = Integer.MAX_VALUE;
            n = -1;
            for (j = 0; j < delimiters.length; ++j) {
                if (source.indexOf(delimiters[j], i) <= -1 || source.indexOf(delimiters[j], i) >= max) continue;
                max = source.indexOf(delimiters[j], i);
                n = source.indexOf(delimiters[j], i);
                delimiter = delimiters[j];
            }
        }
        if (n < 0) {
            n = source.length();
        }
        if (i < n) {
            result.add(trim ? source.substring(i).trim() : source.substring(i));
        }
        return result;
    }

    public String doDecoration(String html, String encoding) throws Exception {
        return this.process(html, encoding);
    }

    public void resetDecorationDefinitions() {
        this.m_config.resetMarkedDecorations();
    }

    public void visitStringNode(Text text) {
        this.appendText(text.toPlainTextString(), DELIMITERS, true);
    }

    public void visitTag(Tag tag) {
        super.visitTag(tag);
        String tagname = tag.getTagName();
        this.m_decorate = !this.m_config.isExcluded(tagname);
    }

    private void appendText(String text, String[] delimiters, boolean recursive) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_APPEND_TEXT_2", this.m_config, text));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text) && this.m_decorate) {
            List wordList = CmsHtmlDecorator.splitAsList(text, delimiters, false, true);
            for (int i = 0; i < wordList.size(); ++i) {
                String word = (String)wordList.get(i);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_PROCESS_WORD_2", word, this.mustDecode(word, wordList, i)));
                }
                if (this.mustDecode(word, wordList, i)) {
                    word = Translate.decode((String)word);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECODED_WORD_1", word));
                    }
                }
                CmsDecorationObject decObj = null;
                if (!this.hasDelimiter(word, delimiters)) {
                    decObj = (CmsDecorationObject)this.m_decorations.get(word);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_FOUND_2", decObj, word));
                }
                if (decObj == null) {
                    if (this.hasDelimiter(word, DELIMITERS_SECOND_LEVEL) && recursive) {
                        String secondLevel = word;
                        if (i < wordList.size() - 1 && !((String)wordList.get(i + 1)).equals(" ")) {
                            secondLevel = word + (String)wordList.get(i + 1);
                            ++i;
                        }
                        this.appendText(secondLevel, DELIMITERS_SECOND_LEVEL, false);
                        continue;
                    }
                    StringBuffer decKey = new StringBuffer();
                    decKey.append(word);
                    int forwardLookup = wordList.size() - i - 1;
                    if (forwardLookup > 7) {
                        forwardLookup = 7;
                    }
                    if (i < wordList.size() - forwardLookup) {
                        for (int j = 1; j <= forwardLookup; ++j) {
                            decKey.append(wordList.get(i + j));
                            decObj = (CmsDecorationObject)this.m_decorations.get(decKey.toString());
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_FOUND_FWL_3", decObj, word, new Integer(j)));
                            }
                            if (decObj == null) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_DECORATION_1", decObj.getContentDecoration(this.m_config, decKey.toString(), this.m_cms.getRequestContext().getLocale().toString())));
                            }
                            this.m_result.append(decObj.getContentDecoration(this.m_config, decKey.toString(), this.m_cms.getRequestContext().getLocale().toString()));
                            i += j;
                            break;
                        }
                    }
                    if (decObj != null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_WORD_1", word));
                    }
                    this.m_result.append(word);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_DECORATION_1", decObj.getContentDecoration(this.m_config, word, this.m_cms.getRequestContext().getLocale().toString())));
                }
                this.m_result.append(decObj.getContentDecoration(this.m_config, word, this.m_cms.getRequestContext().getLocale().toString()));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_HTML_DECORATOR_DECORATION_APPEND_ORIGINALTEXT_1", text));
            }
            this.m_result.append(text);
        }
    }

    private boolean hasDelimiter(String word, String[] delimiters) {
        boolean delim = false;
        for (int i = 0; i < delimiters.length; ++i) {
            if (word.indexOf(delimiters[i]) <= -1) continue;
            delim = true;
            break;
        }
        return delim;
    }

    private boolean mustDecode(String word, List wordList, int count) {
        boolean decode = true;
        String nextWord = null;
        if (count < wordList.size() - 1) {
            nextWord = (String)wordList.get(count + 1);
        }
        if (nextWord != null && word.indexOf("&") > -1 && nextWord.startsWith(";")) {
            return false;
        }
        for (int i = 0; i < NON_TRANSLATORS.length; ++i) {
            if (!word.startsWith(NON_TRANSLATORS[i])) continue;
            decode = false;
            break;
        }
        return decode;
    }
}

