/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.util.CmsConstantMap;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.types.I_CmsXmlContentValue;

public final class CmsJspContentAccessValueWrapper {
    protected static final CmsJspContentAccessValueWrapper NULL_VALUE_WRAPPER = new CmsJspContentAccessValueWrapper();
    private CmsObject m_cms;
    private I_CmsXmlContentValue m_contentValue;
    private int m_hashCode;
    private Map m_hasValue;
    private CmsMacroResolver m_macroResolver;
    private Map m_value;
    private Map m_valueList;

    private CmsJspContentAccessValueWrapper() {
        this((CmsObject)null, (I_CmsXmlContentValue)null);
    }

    private CmsJspContentAccessValueWrapper(CmsJspContentAccessValueWrapper base, CmsMacroResolver macroResolver) {
        this.m_cms = base.m_cms;
        this.m_contentValue = base.m_contentValue;
        this.m_hashCode = base.m_hashCode;
        this.m_hasValue = base.m_hasValue;
        this.m_macroResolver = macroResolver;
        this.m_value = base.m_value;
        this.m_valueList = base.m_valueList;
    }

    private CmsJspContentAccessValueWrapper(CmsObject cms, I_CmsXmlContentValue value) {
        this.m_cms = cms;
        this.m_contentValue = value;
        if (this.m_contentValue == null || this.m_contentValue.isSimpleType()) {
            this.m_hasValue = CmsConstantMap.CONSTANT_BOOLEAN_FALSE_MAP;
            this.m_value = CmsJspContentAccessBean.CONSTANT_NULL_VALUE_WRAPPER_MAP;
            this.m_valueList = CmsConstantMap.CONSTANT_EMPTY_LIST_MAP;
        }
    }

    public static CmsJspContentAccessValueWrapper createWrapper(CmsObject cms, I_CmsXmlContentValue value) {
        if (value != null && cms != null) {
            return new CmsJspContentAccessValueWrapper(cms, value);
        }
        return NULL_VALUE_WRAPPER;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsJspContentAccessValueWrapper) {
            return this.hashCode() == ((CmsJspContentAccessValueWrapper)obj).hashCode();
        }
        return false;
    }

    public boolean getExists() {
        return this.m_contentValue != null;
    }

    public Map getHasValue() {
        if (this.m_hasValue == null) {
            this.m_hasValue = LazyMap.decorate(new HashMap(), (Transformer)new CmsHasValueTransformer());
        }
        return this.m_hasValue;
    }

    public int getIndex() {
        if (this.m_contentValue == null) {
            return -1;
        }
        return this.m_contentValue.getIndex();
    }

    public boolean getIsEmpty() {
        if (this.m_contentValue == null) {
            return true;
        }
        if (this.m_contentValue.isSimpleType()) {
            return CmsStringUtil.isEmpty(this.m_contentValue.getStringValue(this.m_cms));
        }
        return this.m_contentValue.getElement().elements().size() > 0;
    }

    public boolean getIsEmptyOrWhitespaceOnly() {
        if (this.m_contentValue == null) {
            return true;
        }
        if (this.m_contentValue.isSimpleType()) {
            return CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_contentValue.getStringValue(this.m_cms));
        }
        return this.m_contentValue.getElement().elements().size() > 0;
    }

    public Locale getLocale() {
        if (this.m_contentValue == null) {
            return CmsLocaleManager.getDefaultLocale();
        }
        return this.m_contentValue.getLocale();
    }

    public String getPath() {
        if (this.m_contentValue == null) {
            return "";
        }
        return this.m_contentValue.getPath();
    }

    public CmsJspContentAccessValueWrapper getResolveMacros() {
        if (this.m_macroResolver == null) {
            CmsMacroResolver macroResolver = CmsMacroResolver.newInstance();
            macroResolver.setCmsObject(this.m_cms);
            macroResolver.setKeepEmptyMacros(true);
            return new CmsJspContentAccessValueWrapper(this, macroResolver);
        }
        return this;
    }

    public CmsJspContentAccessValueWrapper getResolve() {
        return this.getResolveMacros();
    }

    public String getStringValue() {
        return this.toString();
    }

    public Map getValue() {
        if (this.m_value == null) {
            this.m_value = LazyMap.decorate(new HashMap(), (Transformer)new CmsValueTransformer());
        }
        return this.m_value;
    }

    public Map getValueList() {
        if (this.m_valueList == null) {
            this.m_valueList = LazyMap.decorate(new HashMap(), (Transformer)new CmsValueListTransformer());
        }
        return this.m_valueList;
    }

    public int hashCode() {
        if (this.m_contentValue == null) {
            return 0;
        }
        if (this.m_hashCode == 0) {
            StringBuffer result = new StringBuffer(64);
            result.append(this.m_contentValue.getDocument().getFile().getStructureId().toString());
            result.append('/');
            result.append(this.m_contentValue.getLocale());
            result.append('/');
            result.append(this.m_contentValue.getPath());
            this.m_hashCode = result.toString().hashCode();
        }
        return this.m_hashCode;
    }

    public CmsObject obtainCmsObject() {
        return this.m_cms;
    }

    public I_CmsXmlContentValue obtainContentValue() {
        return this.m_contentValue;
    }

    public String toString() {
        if (this.m_contentValue == null) {
            return "";
        }
        if (this.m_contentValue.isSimpleType()) {
            String value = this.m_contentValue.getStringValue(this.m_cms);
            if (this.m_macroResolver == null) {
                return value;
            }
            return this.m_macroResolver.resolveMacros(value);
        }
        return "";
    }

    protected String createPath(Object input) {
        return CmsXmlUtils.concatXpath(this.m_contentValue.getPath(), String.valueOf(input));
    }

    public class CmsValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            I_CmsXmlContentValue value = CmsJspContentAccessValueWrapper.this.obtainContentValue().getDocument().getValue(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.obtainContentValue().getLocale());
            return CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessValueWrapper.this.obtainCmsObject(), value);
        }
    }

    public class CmsValueListTransformer
    implements Transformer {
        public Object transform(Object input) {
            List values = CmsJspContentAccessValueWrapper.this.obtainContentValue().getDocument().getValues(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.obtainContentValue().getLocale());
            ArrayList<CmsJspContentAccessValueWrapper> result = new ArrayList<CmsJspContentAccessValueWrapper>();
            Iterator i = values.iterator();
            while (i.hasNext()) {
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)i.next();
                result.add(CmsJspContentAccessValueWrapper.createWrapper(CmsJspContentAccessValueWrapper.this.obtainCmsObject(), value));
            }
            return result;
        }
    }

    public class CmsHasValueTransformer
    implements Transformer {
        public Object transform(Object input) {
            return CmsJspContentAccessValueWrapper.this.obtainContentValue().getDocument().hasValue(CmsJspContentAccessValueWrapper.this.createPath(input), CmsJspContentAccessValueWrapper.this.obtainContentValue().getLocale());
        }
    }
}

