/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceManager;

public class CmsDumpLoader
implements I_CmsResourceLoader {
    public static final int RESOURCE_LOADER_ID = 1;
    private static long m_clientCacheMaxAge;
    private Map m_configuration = new TreeMap();

    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.put(paramName, paramValue);
    }

    public void destroy() {
    }

    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale locale, HttpServletRequest req, HttpServletResponse res) throws CmsException {
        return cms.readFile(resource).getContents();
    }

    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        CmsFile file = cms.readFile(resource);
        if (req != null && res != null) {
            ListIterator i = OpenCms.getStaticExportManager().getExportHeaders().listIterator();
            while (i.hasNext()) {
                String header = (String)i.next();
                String[] parts = CmsStringUtil.splitAsArray(header, ':');
                if (parts.length != 2) continue;
                res.setHeader(parts[0], parts[1]);
            }
            this.load(cms, file, req, res);
        }
        return file.getContents();
    }

    public Map getConfiguration() {
        return Collections.unmodifiableMap(this.m_configuration);
    }

    public int getLoaderId() {
        return 1;
    }

    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_DUMB_DEFAULT_DESC_0");
    }

    public void initConfiguration() {
        ExtendedProperties config = new ExtendedProperties();
        config.putAll(this.m_configuration);
        String maxAge = config.getString("client.cache.maxage");
        m_clientCacheMaxAge = maxAge == null ? -1L : Long.parseLong(maxAge);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (maxAge != null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CLIENT_CACHE_MAX_AGE_1", maxAge));
            }
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    public boolean isStaticExportEnabled() {
        return true;
    }

    public boolean isStaticExportProcessable() {
        return false;
    }

    public boolean isUsableForTemplates() {
        return false;
    }

    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws IOException, CmsException {
        if (this.canSendLastModifiedHeader(resource, req, res)) {
            return;
        }
        CmsFile file = cms.readFile(resource);
        res.setStatus(200);
        res.setContentLength(file.getContents().length);
        if (CmsWorkplaceManager.isWorkplaceUser(req)) {
            res.setDateHeader("Last-Modified", System.currentTimeMillis());
            CmsRequestUtil.setNoCacheHeaders(res);
        } else {
            res.setDateHeader("Last-Modified", file.getDateLastModified());
            if (!res.containsHeader("Cache-Control")) {
                long expireTime = resource.getDateExpired();
                if (expireTime == Long.MAX_VALUE) {
                    --expireTime;
                }
                CmsFlexController.setDateExpiresHeader(res, expireTime, m_clientCacheMaxAge);
            }
        }
        this.service(cms, file, (ServletRequest)req, (ServletResponse)res);
    }

    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) throws CmsException, IOException {
        res.getOutputStream().write(cms.readFile(resource).getContents());
    }

    protected boolean canSendLastModifiedHeader(CmsResource resource, HttpServletRequest req, HttpServletResponse res) {
        if (resource.getState().isUnchanged() && !CmsWorkplaceManager.isWorkplaceUser(req) && CmsFlexController.isNotModifiedSince(req, resource.getDateLastModified())) {
            long now = System.currentTimeMillis();
            if (resource.getDateReleased() < now && resource.getDateExpired() > now) {
                CmsFlexController.setDateExpiresHeader(res, resource.getDateExpired(), m_clientCacheMaxAge);
                res.setStatus(304);
                return true;
            }
        }
        return false;
    }
}

