/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import com.alkacon.simapi.RenderSettings;
import com.alkacon.simapi.Simapi;
import com.alkacon.simapi.filter.GrayscaleFilter;
import com.alkacon.simapi.filter.ShadowFilter;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsImageScaler {
    public static final String COLOR_TRANSPARENT = "transparent";
    public static final String FILTER_GRAYSCALE = "grayscale";
    public static final String FILTER_SHADOW = "shadow";
    public static final List FILTERS = Arrays.asList("grayscale", "shadow");
    public static final String PARAM_SCALE = "__scale";
    public static final int SCALE_DEFAULT_MAX_BLUR_SIZE = 6250000;
    public static final int SCALE_DEFAULT_MAX_SIZE = 1500;
    public static final String SCALE_PARAM_COLOR = "c";
    public static final String SCALE_PARAM_FILTER = "f";
    public static final String SCALE_PARAM_HEIGHT = "h";
    public static final String SCALE_PARAM_POS = "p";
    public static final String SCALE_PARAM_QUALITY = "q";
    public static final String SCALE_PARAM_RENDERMODE = "r";
    public static final String SCALE_PARAM_TYPE = "t";
    public static final String SCALE_PARAM_WIDTH = "w";
    protected static final Log LOG = CmsLog.getLog(CmsImageScaler.class);
    private Color m_color;
    private List m_filters;
    private int m_height;
    private int m_maxBlurSize;
    private int m_position;
    private int m_quality;
    private int m_renderMode;
    private String m_scaleParameters;
    private int m_type;
    private int m_width;

    public CmsImageScaler() {
        this.init();
    }

    public CmsImageScaler(byte[] content, String rootPath) {
        this.init();
        try {
            BufferedImage image = Simapi.read((byte[])content);
            this.m_height = image.getHeight();
            this.m_width = image.getWidth();
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_EXTRACT_IMAGE_SIZE_1", rootPath), (Throwable)e);
            }
            this.init();
        }
    }

    public CmsImageScaler(CmsImageScaler original, CmsImageScaler target) {
        CmsImageScaler scaler = original.getReScaler(target);
        this.initValuesFrom(scaler);
    }

    public CmsImageScaler(CmsObject cms, CmsResource res) {
        this.init();
        String sizeValue = null;
        if (cms != null && res != null) {
            try {
                CmsProperty sizeProp = cms.readPropertyObject(res, "image.size", false);
                if (!sizeProp.isNullProperty()) {
                    sizeValue = sizeProp.getValue();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (CmsStringUtil.isNotEmpty(sizeValue)) {
            this.parseParameters(sizeValue);
        }
    }

    public CmsImageScaler(HttpServletRequest request, int maxScaleSize, int maxBlurSize) {
        this.init();
        this.m_maxBlurSize = maxBlurSize;
        String parameters = request.getParameter(PARAM_SCALE);
        if (CmsStringUtil.isNotEmpty(parameters)) {
            this.parseParameters(parameters);
            if (this.isValid() && (this.getWidth() > maxScaleSize || this.getHeight() > maxScaleSize)) {
                this.init();
            }
        }
    }

    public CmsImageScaler(String parameters) {
        this.init();
        if (CmsStringUtil.isNotEmpty(parameters)) {
            this.parseParameters(parameters);
        }
    }

    protected CmsImageScaler(CmsImageScaler base, int width, int height) {
        this.initValuesFrom(base);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void addFilter(String filter) {
        if (CmsStringUtil.isNotEmpty(filter) && FILTERS.contains(filter = filter.trim().toLowerCase())) {
            this.m_filters.add(filter);
        }
    }

    public Object clone() {
        CmsImageScaler clone = new CmsImageScaler();
        clone.initValuesFrom(this);
        return clone;
    }

    public Color getColor() {
        return this.m_color;
    }

    public String getColorString() {
        StringBuffer result = new StringBuffer();
        if (this.m_color == Simapi.COLOR_TRANSPARENT) {
            result.append(COLOR_TRANSPARENT);
        } else {
            if (this.m_color.getRed() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getRed(), 16));
            if (this.m_color.getGreen() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getGreen(), 16));
            if (this.m_color.getBlue() < 16) {
                result.append('0');
            }
            result.append(Integer.toString(this.m_color.getBlue(), 16));
        }
        return result.toString();
    }

    public CmsImageScaler getDownScaler(CmsImageScaler downScaler) {
        int width;
        if (!this.isDownScaleRequired(downScaler)) {
            return null;
        }
        int downHeight = downScaler.getHeight();
        int downWidth = downScaler.getWidth();
        int height = this.getHeight();
        if (height > (width = this.getWidth()) && downHeight < downWidth || width > height && downWidth < downHeight) {
            downHeight = downWidth;
            downWidth = downScaler.getHeight();
        }
        if (width > downWidth) {
            float scale = (float)downWidth / (float)width;
            downHeight = Math.round((float)height * scale);
        } else if (height > downHeight) {
            float scale = (float)downHeight / (float)height;
            downWidth = Math.round((float)width * scale);
        } else {
            return null;
        }
        return new CmsImageScaler(downScaler, downWidth, downHeight);
    }

    public List getFilters() {
        return this.m_filters;
    }

    public String getFiltersString() {
        StringBuffer result = new StringBuffer();
        Iterator i = this.m_filters.iterator();
        while (i.hasNext()) {
            String filter = (String)i.next();
            result.append(filter);
            if (!i.hasNext()) continue;
            result.append(':');
        }
        return result.toString();
    }

    public int getHeight() {
        return this.m_height;
    }

    public String getImageType(String filename) {
        return Simapi.getImageType((String)filename);
    }

    public int getMaxBlurSize() {
        return this.m_maxBlurSize;
    }

    public int getPixelCount() {
        return this.m_width * this.m_height;
    }

    public int getPosition() {
        return this.m_position;
    }

    public int getQuality() {
        return this.m_quality;
    }

    public int getRenderMode() {
        return this.m_renderMode;
    }

    public CmsImageScaler getReScaler(CmsImageScaler target) {
        int height = target.getHeight();
        int width = target.getWidth();
        if (width > 0 && this.getWidth() > 0) {
            float scale = (float)width / (float)this.getWidth();
            height = Math.round((float)this.getHeight() * scale);
        } else if (height > 0 && this.getHeight() > 0) {
            float scale = (float)height / (float)this.getHeight();
            width = Math.round((float)this.getWidth() * scale);
        } else if (this.isValid() && !target.isValid()) {
            width = this.getWidth();
            height = this.getHeight();
        }
        if (target.getType() == 1 && !target.isValid()) {
            if (target.getWidth() > 0 && this.getWidth() < width) {
                height = this.getHeight();
            } else if (target.getHeight() > 0 && this.getHeight() < height) {
                width = this.getWidth();
            }
        }
        return new CmsImageScaler(target, width, height);
    }

    public int getType() {
        return this.m_type;
    }

    public int getWidth() {
        return this.m_width;
    }

    public CmsImageScaler getWidthScaler(CmsImageScaler downScaler) {
        int height;
        int width = downScaler.getWidth();
        if (this.getWidth() > width) {
            float scale = (float)width / (float)this.getWidth();
            height = Math.round((float)this.getHeight() * scale);
        } else {
            width = this.getWidth();
            height = this.getHeight();
        }
        return new CmsImageScaler(downScaler, width, height);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isDownScaleRequired(CmsImageScaler downScaler) {
        int width;
        int height;
        if (downScaler == null || !this.isValid() || !downScaler.isValid()) {
            return false;
        }
        if (this.getPixelCount() < downScaler.getPixelCount() / 2) {
            return false;
        }
        int downWidth = downScaler.getWidth();
        int downHeight = downScaler.getHeight();
        if (downHeight > downWidth) {
            downWidth = downHeight;
            downHeight = downScaler.getWidth();
        }
        if ((height = this.getHeight()) > (width = this.getWidth())) {
            width = height;
            height = this.getWidth();
        }
        return width > downWidth || height > downHeight;
    }

    public boolean isValid() {
        return this.m_width > 0 && this.m_height > 0;
    }

    public void parseParameters(String parameters) {
        this.m_width = -1;
        this.m_height = -1;
        this.m_position = 0;
        this.m_type = 0;
        this.m_color = Color.WHITE;
        List tokens = CmsStringUtil.splitAsList(parameters, ',');
        Iterator it = tokens.iterator();
        while (it.hasNext()) {
            String t = (String)it.next();
            String k = null;
            String v = null;
            int idx = t.indexOf(58);
            if (idx >= 0) {
                k = t.substring(0, idx).trim();
                if (t.length() > idx) {
                    v = t.substring(idx + 1).trim();
                }
            }
            if (CmsStringUtil.isNotEmpty(k) && CmsStringUtil.isNotEmpty(v)) {
                if (SCALE_PARAM_HEIGHT.equals(k)) {
                    this.m_height = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_WIDTH.equals(k)) {
                    this.m_width = CmsStringUtil.getIntValue(v, Integer.MIN_VALUE, k);
                    continue;
                }
                if (SCALE_PARAM_TYPE.equals(k)) {
                    this.setType(CmsStringUtil.getIntValue(v, -1, SCALE_PARAM_TYPE));
                    continue;
                }
                if (SCALE_PARAM_COLOR.equals(k)) {
                    this.setColor(v);
                    continue;
                }
                if (SCALE_PARAM_POS.equals(k)) {
                    this.setPosition(CmsStringUtil.getIntValue(v, -1, SCALE_PARAM_POS));
                    continue;
                }
                if (SCALE_PARAM_QUALITY.equals(k)) {
                    this.setQuality(CmsStringUtil.getIntValue(v, 0, k));
                    continue;
                }
                if (SCALE_PARAM_RENDERMODE.equals(k)) {
                    this.setRenderMode(CmsStringUtil.getIntValue(v, 0, k));
                    continue;
                }
                if (SCALE_PARAM_FILTER.equals(k)) {
                    this.setFilters(v);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("ERR_INVALID_IMAGE_SCALE_PARAMS_2", k, v));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)Messages.get().getBundle().key("ERR_INVALID_IMAGE_SCALE_PARAMS_2", k, v));
        }
    }

    public byte[] scaleImage(byte[] content, String rootPath) {
        byte[] result;
        block18: {
            String mimeType;
            RenderSettings renderSettings;
            result = content;
            if (this.m_renderMode == 0 && this.m_quality == 0) {
                renderSettings = new RenderSettings(0);
            } else {
                renderSettings = new RenderSettings(this.m_renderMode);
                if (this.m_quality != 0) {
                    renderSettings.setCompressionQuality((float)this.m_quality / 100.0f);
                }
            }
            renderSettings.setMaximumBlurSize(this.m_maxBlurSize);
            Simapi scaler = new Simapi(renderSettings);
            String imageType = Simapi.getImageType((String)rootPath);
            if (imageType == null && (mimeType = OpenCms.getResourceManager().getMimeType(rootPath, null, null)) == null) {
                imageType = "JPEG";
            }
            if (imageType == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_SCALE_IMAGE_2", rootPath, this.toString()));
                }
                return result;
            }
            try {
                BufferedImage image = Simapi.read((byte[])content);
                Color color = this.getColor();
                if (!this.m_filters.isEmpty()) {
                    Iterator i = this.m_filters.iterator();
                    while (i.hasNext()) {
                        String filter = (String)i.next();
                        if (FILTER_GRAYSCALE.equals(filter)) {
                            GrayscaleFilter grayscaleFilter = new GrayscaleFilter();
                            renderSettings.addImageFilter((ImageFilter)grayscaleFilter);
                            continue;
                        }
                        if (!FILTER_SHADOW.equals(filter)) continue;
                        ShadowFilter shadowFilter = new ShadowFilter();
                        shadowFilter.setXOffset(5);
                        shadowFilter.setYOffset(5);
                        shadowFilter.setOpacity(192);
                        shadowFilter.setBackgroundColor(color.getRGB());
                        color = Simapi.COLOR_TRANSPARENT;
                        renderSettings.setTransparentReplaceColor(Simapi.COLOR_TRANSPARENT);
                        renderSettings.addImageFilter((ImageFilter)shadowFilter);
                    }
                }
                switch (this.getType()) {
                    case 1: {
                        image = scaler.resize(image, this.getWidth(), this.getHeight(), color, this.getPosition(), false);
                        break;
                    }
                    case 2: {
                        image = scaler.resize(image, this.getWidth(), this.getHeight(), this.getPosition());
                        break;
                    }
                    case 3: {
                        image = scaler.resize(image, this.getWidth(), this.getHeight(), true);
                        break;
                    }
                    case 4: {
                        image = scaler.resize(image, this.getWidth(), this.getHeight(), false);
                        break;
                    }
                    default: {
                        image = scaler.resize(image, this.getWidth(), this.getHeight(), color, this.getPosition(), true);
                    }
                }
                if (!this.m_filters.isEmpty()) {
                    Rectangle targetSize = scaler.applyFilterDimensions(this.getWidth(), this.getHeight());
                    image = scaler.resize(image, (int)targetSize.getWidth(), (int)targetSize.getHeight(), Simapi.COLOR_TRANSPARENT, 0);
                    image = scaler.applyFilters(image);
                }
                result = scaler.getBytes(image, imageType);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block18;
                LOG.debug((Object)Messages.get().getBundle().key("ERR_UNABLE_TO_SCALE_IMAGE_2", rootPath, this.toString()), (Throwable)e);
            }
        }
        return result;
    }

    public byte[] scaleImage(CmsFile file) {
        return this.scaleImage(file.getContents(), file.getRootPath());
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    public void setColor(String value) {
        if (COLOR_TRANSPARENT.indexOf(value) == 0) {
            this.setColor(Simapi.COLOR_TRANSPARENT);
        } else {
            this.setColor(CmsStringUtil.getColorValue(value, Color.WHITE, SCALE_PARAM_COLOR));
        }
    }

    public void setFilters(String value) {
        this.m_filters = new ArrayList();
        List filters = CmsStringUtil.splitAsList(value, ':');
        Iterator i = filters.iterator();
        block0: while (i.hasNext()) {
            String filter = (String)i.next();
            filter = filter.trim().toLowerCase();
            Iterator j = FILTERS.iterator();
            while (j.hasNext()) {
                String candidate = (String)j.next();
                if (!candidate.startsWith(filter)) continue;
                this.addFilter(candidate);
                continue block0;
            }
        }
    }

    public void setHeight(int height) {
        this.m_height = height;
    }

    public void setMaxBlurSize(int maxBlurSize) {
        this.m_maxBlurSize = maxBlurSize;
    }

    public void setPosition(int position) {
        switch (position) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.m_position = position;
                break;
            }
            default: {
                this.m_position = 0;
            }
        }
    }

    public void setQuality(int quality) {
        this.m_quality = quality < 0 ? 0 : (quality > 100 ? 100 : quality);
    }

    public void setRenderMode(int renderMode) {
        if (renderMode < 0 || renderMode > 2) {
            renderMode = 0;
        }
        this.m_renderMode = renderMode;
    }

    public void setType(int type) {
        this.m_type = type < 0 || type > 4 ? 0 : type;
    }

    public void setWidth(int width) {
        this.m_width = width;
    }

    public String toRequestParam() {
        StringBuffer result = new StringBuffer(128);
        result.append('?');
        result.append(PARAM_SCALE);
        result.append('=');
        result.append(this.toString());
        return result.toString();
    }

    public String toString() {
        if (this.m_scaleParameters != null) {
            return this.m_scaleParameters;
        }
        StringBuffer result = new StringBuffer(64);
        result.append(SCALE_PARAM_WIDTH);
        result.append(':');
        result.append(this.m_width);
        result.append(',');
        result.append(SCALE_PARAM_HEIGHT);
        result.append(':');
        result.append(this.m_height);
        if (this.m_type > 0) {
            result.append(',');
            result.append(SCALE_PARAM_TYPE);
            result.append(':');
            result.append(this.m_type);
        }
        if (this.m_position > 0) {
            result.append(',');
            result.append(SCALE_PARAM_POS);
            result.append(':');
            result.append(this.m_position);
        }
        if (this.m_color != Color.WHITE) {
            result.append(',');
            result.append(SCALE_PARAM_COLOR);
            result.append(':');
            result.append(this.getColorString());
        }
        if (this.m_quality > 0) {
            result.append(',');
            result.append(SCALE_PARAM_QUALITY);
            result.append(':');
            result.append(this.m_quality);
        }
        if (this.m_renderMode > 0) {
            result.append(',');
            result.append(SCALE_PARAM_RENDERMODE);
            result.append(':');
            result.append(this.m_renderMode);
        }
        if (!this.m_filters.isEmpty()) {
            result.append(',');
            result.append(SCALE_PARAM_FILTER);
            result.append(':');
            result.append(this.getFiltersString());
        }
        this.m_scaleParameters = result.toString();
        return this.m_scaleParameters;
    }

    private void init() {
        this.m_height = -1;
        this.m_width = -1;
        this.m_type = 0;
        this.m_position = 0;
        this.m_renderMode = 0;
        this.m_quality = 0;
        this.m_color = Color.WHITE;
        this.m_filters = new ArrayList();
        this.m_maxBlurSize = CmsImageLoader.getMaxBlurSize();
    }

    private void initValuesFrom(CmsImageScaler source) {
        this.m_width = source.m_width;
        this.m_height = source.m_height;
        this.m_type = source.m_type;
        this.m_position = source.m_position;
        this.m_renderMode = source.m_renderMode;
        this.m_quality = source.m_quality;
        this.m_color = source.m_color;
        this.m_filters = new ArrayList(source.m_filters);
        this.m_maxBlurSize = source.m_maxBlurSize;
    }
}

