/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.lock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockType;
import org.opencms.lock.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public final class CmsLockManager {
    private CmsDriverManager m_driverManager;
    private boolean m_isDirty = false;
    private boolean m_runningInServlet = false;

    public CmsLockManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public void addResource(CmsDbContext dbc, CmsResource resource, CmsUser user, CmsProject project, CmsLockType type) throws CmsLockException, CmsException {
        if (!type.isSystem() && !type.isExclusive()) {
            throw new CmsLockException(Messages.get().container("ERR_INVALID_LOCK_TYPE_1", type.toString()));
        }
        CmsLock currentLock = this.getLock(dbc, resource);
        this.checkLockable(dbc, resource, user, project, type, currentLock);
        boolean needNewLock = true;
        if (!(!type.isExclusive() || type.isTemporary() && currentLock.isInherited() || currentLock.getEditionLock().isUnlocked())) {
            needNewLock = false;
        }
        CmsLock newLock = CmsLock.getNullLock();
        if (needNewLock) {
            newLock = new CmsLock(resource.getRootPath(), user.getId(), project, type);
            this.lockResource(newLock);
        }
        if (resource.isFolder() && newLock.getSystemLock().isUnlocked()) {
            String resourceName = resource.getRootPath();
            Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
            while (itLocks.hasNext()) {
                CmsLock lock = (CmsLock)itLocks.next();
                String lockedPath = lock.getResourceName();
                if (!lockedPath.startsWith(resourceName) || lockedPath.equals(resourceName)) continue;
                this.unlockResource(lockedPath, false);
            }
        }
    }

    public int countExclusiveLocksInProject(CmsProject project) {
        int count = 0;
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock lock = (CmsLock)itLocks.next();
            if (!lock.getEditionLock().isInProject(project)) continue;
            ++count;
        }
        return count;
    }

    public CmsLock getLock(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.getLock(dbc, resource, true);
    }

    public CmsLock getLock(CmsDbContext dbc, CmsResource resource, boolean includeSiblings) throws CmsException {
        if (resource == null || dbc.currentProject().isOnlineProject()) {
            return CmsLock.getNullLock();
        }
        CmsLock lock = this.getDirectLock(resource.getRootPath());
        if (lock == null && includeSiblings) {
            List siblings = this.internalReadSiblings(dbc, resource);
            lock = this.getSiblingsLock(siblings, resource.getRootPath());
        }
        if (lock == null) {
            lock = this.getParentLock(resource.getRootPath());
        }
        lock = !lock.getSystemLock().isUnlocked() ? lock.getSystemLock() : lock.getEditionLock();
        return lock;
    }

    public List getLocks(CmsDbContext dbc, String resourceName, CmsLockFilter filter) throws CmsException {
        ArrayList<CmsLock> locks = new ArrayList<CmsLock>();
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock lock = (CmsLock)itLocks.next();
            if (filter.isSharedExclusive()) {
                CmsResource resource;
                try {
                    resource = this.m_driverManager.readResource(dbc, lock.getResourceName(), CmsResourceFilter.ALL);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    OpenCms.getMemoryMonitor().uncacheLock(lock.getResourceName());
                    continue;
                }
                if (resource.getSiblingCount() > 1) {
                    Iterator itSiblings = this.internalReadSiblings(dbc, resource).iterator();
                    while (itSiblings.hasNext()) {
                        CmsResource sibling = (CmsResource)itSiblings.next();
                        CmsLock siblingLock = this.internalSiblingLock(lock, sibling.getRootPath());
                        if (!filter.match(resourceName, siblingLock)) continue;
                        locks.add(siblingLock);
                    }
                }
            }
            if (!filter.match(resourceName, lock)) continue;
            locks.add(lock);
        }
        return locks;
    }

    public boolean hasSystemLocks(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (resource == null) {
            return false;
        }
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsResource lockedResource;
            CmsLock lock = (CmsLock)itLocks.next();
            if (lock.getSystemLock().isUnlocked() || !lock.getResourceName().startsWith(resource.getRootPath())) continue;
            if (lock.getResourceName().startsWith(resource.getRootPath())) {
                return true;
            }
            try {
                resource = this.m_driverManager.readResource(dbc, lock.getResourceName(), CmsResourceFilter.ALL);
            }
            catch (CmsVfsResourceNotFoundException e) {
                OpenCms.getMemoryMonitor().uncacheLock(lock.getResourceName());
                continue;
            }
            try {
                lockedResource = this.m_driverManager.readResource(dbc, lock.getResourceName(), CmsResourceFilter.ALL);
            }
            catch (CmsVfsResourceNotFoundException e) {
                OpenCms.getMemoryMonitor().uncacheLock(lock.getResourceName());
                continue;
            }
            if (lockedResource.getSiblingCount() <= 1) continue;
            Iterator itSiblings = this.internalReadSiblings(dbc, lockedResource).iterator();
            while (itSiblings.hasNext()) {
                CmsResource sibling = (CmsResource)itSiblings.next();
                CmsLock siblingLock = this.internalSiblingLock(lock, sibling.getRootPath());
                if (!siblingLock.getResourceName().startsWith(resource.getRootPath())) continue;
                return true;
            }
        }
        return false;
    }

    public void moveResource(String source, String destination) {
        CmsLock lock = OpenCms.getMemoryMonitor().getCachedLock(source);
        if (lock != null) {
            OpenCms.getMemoryMonitor().uncacheLock(lock.getResourceName());
            CmsLock newLock = new CmsLock(destination, lock.getUserId(), lock.getProject(), lock.getType());
            lock = lock.getRelatedLock();
            if (lock != null && !lock.isNullLock()) {
                CmsLock relatedLock = new CmsLock(destination, lock.getUserId(), lock.getProject(), lock.getType());
                newLock.setRelatedLock(relatedLock);
            }
            OpenCms.getMemoryMonitor().cacheLock(newLock);
        }
    }

    public void readLocks(CmsDbContext dbc) throws CmsException {
        if (OpenCms.getRunLevel() > 3) {
            HashMap lockCache = new HashMap();
            List locks = this.m_driverManager.getProjectDriver().readLocks(dbc);
            Iterator itLocks = locks.iterator();
            while (itLocks.hasNext()) {
                CmsLock lock = (CmsLock)itLocks.next();
                this.internalLockResource(lock, lockCache);
            }
            OpenCms.getMemoryMonitor().flushLocks(lockCache);
            this.m_runningInServlet = true;
        }
    }

    public void removeDeletedResource(CmsDbContext dbc, String resourceName) throws CmsException {
        try {
            this.m_driverManager.getVfsDriver().readResource(dbc, dbc.currentProject().getUuid(), resourceName, false);
            throw new CmsLockException(Messages.get().container("ERR_REMOVING_UNDELETED_RESOURCE_1", dbc.getRequestContext().removeSiteRoot(resourceName)));
        }
        catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
            this.unlockResource(resourceName, true);
            this.unlockResource(resourceName, false);
            return;
        }
    }

    public void removeLocks(CmsUUID userId) {
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock currentLock = (CmsLock)itLocks.next();
            boolean editLock = currentLock.getEditionLock().getUserId().equals(userId);
            boolean sysLock = currentLock.getSystemLock().getUserId().equals(userId);
            if (editLock) {
                this.unlockResource(currentLock.getResourceName(), false);
            }
            if (!sysLock) continue;
            this.unlockResource(currentLock.getResourceName(), true);
        }
    }

    public CmsLock removeResource(CmsDbContext dbc, CmsResource resource, boolean forceUnlock, boolean removeSystemLock) throws CmsException {
        String resourcename = resource.getRootPath();
        CmsLock lock = this.getLock(dbc, resource).getEditionLock();
        if (!lock.isNullLock()) {
            if (!forceUnlock && !lock.isOwnedInProjectBy(dbc.currentUser(), dbc.currentProject())) {
                throw new CmsLockException(Messages.get().container("ERR_RESOURCE_UNLOCK_1", dbc.removeSiteRoot(resourcename)));
            }
            if (!forceUnlock && lock.isInherited()) {
                throw new CmsLockException(Messages.get().container("ERR_UNLOCK_LOCK_INHERITED_1", dbc.removeSiteRoot(resourcename)));
            }
        }
        if (lock.isExclusive()) {
            if (resource.isFolder()) {
                Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
                while (itLocks.hasNext()) {
                    String lockedPath = ((CmsLock)itLocks.next()).getResourceName();
                    if (!lockedPath.startsWith(resourcename) || lockedPath.equals(resourcename)) continue;
                    this.unlockResource(lockedPath, false);
                }
            }
            if (removeSystemLock) {
                this.unlockResource(resourcename, true);
            }
            this.unlockResource(resourcename, false);
            return lock;
        }
        if (lock.getType().isSharedExclusive()) {
            List locks = OpenCms.getMemoryMonitor().getAllCachedLockPaths();
            List siblings = this.internalReadSiblings(dbc, resource);
            for (int i = 0; i < siblings.size(); ++i) {
                CmsResource sibling = (CmsResource)siblings.get(i);
                if (!locks.contains(sibling.getRootPath())) continue;
                if (removeSystemLock) {
                    this.unlockResource(sibling.getRootPath(), true);
                }
                this.unlockResource(sibling.getRootPath(), false);
                break;
            }
            return lock;
        }
        if (removeSystemLock && !this.getLock(dbc, resource).getSystemLock().isUnlocked()) {
            return this.unlockResource(resourcename, true);
        }
        return lock;
    }

    public void removeResourcesInProject(CmsUUID projectId, boolean removeSystemLocks) {
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock currentLock = (CmsLock)itLocks.next();
            if (removeSystemLocks && currentLock.getSystemLock().getProjectId().equals(projectId)) {
                this.unlockResource(currentLock.getResourceName(), true);
            }
            if (!currentLock.getEditionLock().getProjectId().equals(projectId)) continue;
            this.unlockResource(currentLock.getResourceName(), false);
        }
    }

    public void removeTempLocks(CmsUUID userId) {
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock currentLock = (CmsLock)itLocks.next();
            if (!currentLock.isTemporary() || !currentLock.getUserId().equals(userId)) continue;
            this.unlockResource(currentLock.getResourceName(), false);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        List lockedResources = OpenCms.getMemoryMonitor().getAllCachedLocks();
        Collections.sort(lockedResources);
        Iterator itLocks = lockedResources.iterator();
        while (itLocks.hasNext()) {
            CmsLock lock = (CmsLock)itLocks.next();
            buf.append(lock).append("\n");
        }
        return buf.toString();
    }

    public void writeLocks(CmsDbContext dbc) throws CmsException {
        if (this.m_isDirty && this.m_runningInServlet && OpenCms.getMemoryMonitor().requiresPersistency()) {
            List locks = OpenCms.getMemoryMonitor().getAllCachedLocks();
            this.m_driverManager.getProjectDriver().writeLocks(dbc, locks);
            this.m_isDirty = false;
        }
    }

    private void checkLockable(CmsDbContext dbc, CmsResource resource, CmsUser user, CmsProject project, CmsLockType type, CmsLock currentLock) throws CmsLockException {
        if (!(currentLock.isLockableBy(user) || !currentLock.getSystemLock().isUnlocked() && currentLock.getType() == type && currentLock.isOwnedInProjectBy(user, project))) {
            CmsMessageContainer message = null;
            message = currentLock.getSystemLock().isPublish() ? Messages.get().container("ERR_RESOURCE_LOCKED_FORPUBLISH_1", dbc.getRequestContext().getSitePath(resource)) : (currentLock.getEditionLock().isInherited() ? Messages.get().container("ERR_RESOURCE_LOCKED_INHERITED_1", dbc.getRequestContext().getSitePath(resource)) : Messages.get().container("ERR_RESOURCE_LOCKED_BYOTHERUSER_1", dbc.getRequestContext().getSitePath(resource)));
            throw new CmsLockException(message);
        }
    }

    private CmsLock getDirectLock(String resourcename) {
        return OpenCms.getMemoryMonitor().getCachedLock(resourcename);
    }

    private CmsLock getParentFolderLock(String resourceName) {
        Iterator itLocks = OpenCms.getMemoryMonitor().getAllCachedLocks().iterator();
        while (itLocks.hasNext()) {
            CmsLock lock = (CmsLock)itLocks.next();
            if (!lock.getResourceName().endsWith("/") || !resourceName.startsWith(lock.getResourceName()) || resourceName.equals(lock.getResourceName()) || (lock = lock.getEditionLock()).isUnlocked()) continue;
            return lock;
        }
        return CmsLock.getNullLock();
    }

    private CmsLock getParentLock(String resourcename) {
        CmsLock parentFolderLock = this.getParentFolderLock(resourcename);
        if (!parentFolderLock.isNullLock()) {
            return new CmsLock(resourcename, parentFolderLock.getUserId(), parentFolderLock.getProject(), CmsLockType.INHERITED);
        }
        return CmsLock.getNullLock();
    }

    private CmsLock getSiblingsLock(List siblings, String resourcename) {
        for (int i = 0; i < siblings.size(); ++i) {
            CmsResource sibling = (CmsResource)siblings.get(i);
            CmsLock exclusiveLock = this.getDirectLock(sibling.getRootPath());
            if (exclusiveLock == null) continue;
            return this.internalSiblingLock(exclusiveLock, resourcename);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalLockResource(CmsLock lock, Map locks) throws CmsLockException {
        CmsLock currentLock = null;
        currentLock = locks == null ? OpenCms.getMemoryMonitor().getCachedLock(lock.getResourceName()) : (CmsLock)locks.get(lock.getResourceName());
        if (currentLock != null) {
            if (currentLock.getSystemLock().equals(lock) || currentLock.getEditionLock().equals(lock)) {
                return;
            }
            if (!currentLock.getSystemLock().isUnlocked() && lock.getSystemLock().isUnlocked()) {
                lock.setRelatedLock(currentLock);
                if (locks == null) {
                    OpenCms.getMemoryMonitor().cacheLock(lock);
                    return;
                } else {
                    locks.put(lock.getResourceName(), lock);
                }
                return;
            } else {
                if (!currentLock.getSystemLock().isUnlocked() || lock.getSystemLock().isUnlocked()) throw new CmsLockException(Messages.get().container("ERR_LOCK_ILLEGAL_STATE_2", currentLock, lock));
                currentLock.setRelatedLock(lock);
            }
            return;
        } else if (locks == null) {
            OpenCms.getMemoryMonitor().cacheLock(lock);
            return;
        } else {
            locks.put(lock.getResourceName(), lock);
        }
    }

    private List internalReadSiblings(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List siblings = this.m_driverManager.getVfsDriver().readSiblings(dbc, dbc.currentProject().getUuid(), resource, true);
        siblings.remove(resource);
        return siblings;
    }

    private CmsLock internalSiblingLock(CmsLock exclusiveLock, String siblingName) {
        CmsLock lock = null;
        if (!exclusiveLock.getSystemLock().isUnlocked()) {
            lock = new CmsLock(siblingName, exclusiveLock.getUserId(), exclusiveLock.getProject(), exclusiveLock.getSystemLock().getType());
        }
        if (lock == null || !exclusiveLock.getEditionLock().isNullLock()) {
            CmsLockType type = CmsLockType.SHARED_EXCLUSIVE;
            if (!this.getParentLock(siblingName).isNullLock()) {
                type = CmsLockType.SHARED_INHERITED;
            }
            if (lock == null) {
                lock = new CmsLock(siblingName, exclusiveLock.getUserId(), exclusiveLock.getProject(), type);
            } else {
                CmsLock editionLock = new CmsLock(siblingName, exclusiveLock.getUserId(), exclusiveLock.getProject(), type);
                lock.setRelatedLock(editionLock);
            }
        }
        return lock;
    }

    private void lockResource(CmsLock lock) throws CmsLockException {
        this.m_isDirty = true;
        this.internalLockResource(lock, null);
    }

    private CmsLock unlockResource(String resourceName, boolean systemLocks) {
        this.m_isDirty = true;
        CmsLock lock = OpenCms.getMemoryMonitor().getCachedLock(resourceName);
        if (lock == null) {
            return CmsLock.getNullLock();
        }
        if (systemLocks) {
            if (!lock.getSystemLock().isUnlocked()) {
                OpenCms.getMemoryMonitor().uncacheLock(resourceName);
                return lock;
            }
            return CmsLock.getNullLock();
        }
        if (lock.getSystemLock().isUnlocked()) {
            OpenCms.getMemoryMonitor().uncacheLock(resourceName);
            return lock;
        }
        if (!lock.getEditionLock().isUnlocked()) {
            CmsLock tmp = lock.getEditionLock();
            CmsLock sysLock = lock.getSystemLock();
            sysLock.setRelatedLock(null);
            if (!sysLock.equals(lock)) {
                OpenCms.getMemoryMonitor().cacheLock(sysLock);
            }
            return tmp;
        }
        return CmsLock.getNullLock();
    }
}

