/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;

public class CmsMailSettings {
    public static final String MAIL_DEFAULT_PROTOCOL = "smtp";
    public static final String MAIL_DEFAULT_SENDER = "opencms@unconfigured.com";
    private static final Log LOG = CmsLog.getLog(CmsMailSettings.class);
    private String m_mailFromDefault = "opencms@unconfigured.com";
    private List m_mailHosts = new ArrayList();
    private int m_orderDefault;

    public CmsMailSettings() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_EMPTY_CONSTRUCTOR_CALLED_1"));
        }
    }

    public void addMailHost(String hostname, String order, String protocol, String username, String password) {
        Integer theOrder;
        this.m_orderDefault += 10;
        try {
            theOrder = Integer.valueOf(order);
            if (theOrder > this.m_orderDefault) {
                this.m_orderDefault = theOrder;
            }
        }
        catch (Throwable t) {
            theOrder = new Integer(this.m_orderDefault);
        }
        CmsMailHost host = new CmsMailHost(hostname, theOrder, protocol, username, password);
        this.m_mailHosts.add(host);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_ADD_HOST_1", host));
        }
        Collections.sort(this.m_mailHosts);
    }

    public CmsMailHost getDefaultMailHost() {
        return (CmsMailHost)this.m_mailHosts.get(0);
    }

    public String getMailFromDefault() {
        return this.m_mailFromDefault;
    }

    public List getMailHosts() {
        return Collections.unmodifiableList(this.m_mailHosts);
    }

    public void setMailFromDefault(String sender) {
        this.m_mailFromDefault = sender;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_DEFAULT_SENDER_1", this.m_mailFromDefault));
        }
    }
}

