/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.SimpleEmail;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsSimpleMail
extends SimpleEmail {
    private static final Log LOG = CmsLog.getLog(CmsSimpleMail.class);

    public CmsSimpleMail() {
        CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
        this.setHostName(host.getHostname());
        String userName = host.getUsername();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
            this.setAuthentication(userName, host.getPassword());
        }
        try {
            this.setFrom(OpenCms.getSystemInfo().getMailSettings().getMailFromDefault());
        }
        catch (MessagingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SENDER_ADDRESS_0"), (Throwable)e);
        }
    }

    public void send() throws MessagingException, SendFailedException {
        try {
            super.send();
        }
        catch (SendFailedException sf) {
            MessagingException me = (MessagingException)((Object)sf.getNextException());
            CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
            if (me instanceof AuthenticationFailedException) {
                CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_AUTHENTICATE_2", host.getUsername(), host.getHostname()));
                sf.initCause((Throwable)rte);
                throw sf;
            }
            CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_HOSTNAME_1", host.getHostname()), (Throwable)me);
            sf.initCause((Throwable)rte);
            throw sf;
        }
    }
}

