/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import org.opencms.util.A_CmsModeStringEnumeration;

public class CmsServletContainerSettings {
    public static final CmsServletContainerCfgMode CFG_MODE_AUTO = CmsServletContainerCfgMode.MODE_AUTO;
    public static final CmsServletContainerCfgMode CFG_MODE_MANUAL = CmsServletContainerCfgMode.MODE_MANUAL;
    public static final CmsServletContainerCfgMode CFG_MODE_NONE = CmsServletContainerCfgMode.MODE_NONE;
    private static final String REQUEST_ERROR_PAGE_ATTRIBUTE_WEBLOGIC = "weblogic.servlet.errorPage";
    private static final String SERVLET_CONTAINER_RESIN = "Resin";
    private static final String SERVLET_CONTAINER_WEBLOGIC = "WebLogic Server";
    private static final String SERVLET_CONTAINER_WEBSPHERE = "IBM WebSphere Application Server";
    private CmsServletContainerCfgMode m_mode = CFG_MODE_NONE;
    private boolean m_preventResponseFlush;
    private boolean m_releaseTagsAfterEnd = true;
    private String m_requestErrorPageAttribute;
    private String m_servletContainerName;
    private boolean m_servletThrowsException = true;

    public CmsServletContainerSettings(String servletContainerName) {
        if (servletContainerName == null) {
            this.m_servletContainerName = "";
            return;
        }
        this.m_servletContainerName = servletContainerName;
        this.m_releaseTagsAfterEnd = this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) <= -1;
        this.m_requestErrorPageAttribute = null;
        if (this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBLOGIC) > -1) {
            this.m_requestErrorPageAttribute = REQUEST_ERROR_PAGE_ATTRIBUTE_WEBLOGIC;
        }
        this.m_servletThrowsException = true;
        this.m_servletThrowsException &= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) < 0;
        this.m_servletThrowsException &= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBLOGIC) < 0;
        this.m_preventResponseFlush = false;
        this.m_preventResponseFlush |= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_WEBSPHERE) > -1;
        this.m_preventResponseFlush |= this.m_servletContainerName.indexOf(SERVLET_CONTAINER_RESIN) > -1;
    }

    public CmsServletContainerCfgMode getMode() {
        return this.m_mode;
    }

    public String getRequestErrorPageAttribute() {
        return this.m_requestErrorPageAttribute;
    }

    public String getServletContainerName() {
        return this.m_servletContainerName;
    }

    public boolean isPreventResponseFlush() {
        return this.m_preventResponseFlush;
    }

    public boolean isReleaseTagsAfterEnd() {
        return this.m_releaseTagsAfterEnd;
    }

    public boolean isServletThrowsException() {
        return this.m_servletThrowsException;
    }

    public void setMode(String configValue) {
        this.m_mode = CmsServletContainerCfgMode.valueOf(configValue);
    }

    public void setPreventResponseFlush(boolean preventResponseFlush) {
        this.m_preventResponseFlush = preventResponseFlush;
    }

    public void setReleaseTagsAfterEnd(boolean releaseTagsAfterEnd) {
        this.m_releaseTagsAfterEnd = releaseTagsAfterEnd;
    }

    public void setRequestErrorPageAttribute(String requestErrorPageAttribute) {
        this.m_requestErrorPageAttribute = requestErrorPageAttribute;
    }

    public void setServletThrowsException(boolean servletThrowsException) {
        this.m_servletThrowsException = servletThrowsException;
    }

    public static final class CmsServletContainerCfgMode
    extends A_CmsModeStringEnumeration {
        protected static final CmsServletContainerCfgMode MODE_AUTO = new CmsServletContainerCfgMode("auto");
        protected static final CmsServletContainerCfgMode MODE_MANUAL = new CmsServletContainerCfgMode("manual");
        protected static final CmsServletContainerCfgMode MODE_NONE = new CmsServletContainerCfgMode("none");
        private static final long serialVersionUID = -8191582624108081577L;

        private CmsServletContainerCfgMode(String mode) {
            super(mode);
        }

        public static CmsServletContainerCfgMode valueOf(String mode) {
            if (mode == null) {
                return null;
            }
            if (mode.equalsIgnoreCase(MODE_NONE.getMode())) {
                return MODE_NONE;
            }
            if (mode.equalsIgnoreCase(MODE_MANUAL.getMode())) {
                return MODE_MANUAL;
            }
            if (mode.equalsIgnoreCase(MODE_AUTO.getMode())) {
                return MODE_AUTO;
            }
            return null;
        }

        public boolean isNone() {
            return this == MODE_NONE;
        }

        public boolean isAuto() {
            return this == MODE_AUTO;
        }

        public boolean isManual() {
            return this == MODE_MANUAL;
        }
    }
}

