/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.util.Properties;
import org.opencms.mail.CmsMailSettings;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.Messages;
import org.opencms.util.CmsFileUtil;

public class CmsSystemInfo {
    public static final String FILE_PROPERTIES = "opencms.properties";
    public static final String FOLDER_CONFIG = "config" + File.separatorChar;
    public static final String FOLDER_MODULES = "modules" + File.separatorChar;
    public static final String FOLDER_PACKAGES = "packages" + File.separatorChar;
    public static final String FOLDER_WEBINF = "WEB-INF" + File.separatorChar;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_VERSION_NUMBER = "7.0.x";
    private String m_configurationFileRfsPath;
    private String m_contextPath;
    private String m_defaultEncoding;
    private String m_defaultWebApplicationName;
    private boolean m_historyEnabled;
    private int m_historyVersions;
    private int m_historyVersionsAfterDeletion;
    private CmsHttpAuthenticationSettings m_httpAuthenticationSettings;
    private CmsMailSettings m_mailSettings;
    private String m_notificationProject;
    private int m_notificationTime;
    private String m_openCmsContext;
    private String m_packagesRfsPath;
    private String m_serverName;
    private CmsServletContainerSettings m_servletContainerSettings;
    private String m_servletPath;
    private long m_startupTime = System.currentTimeMillis();
    private String m_version;
    private String m_versionNumber;
    private String m_webApplicationName;
    private String m_webApplicationRfsPath;
    private String m_webInfRfsPath;

    public CmsSystemInfo() {
        this.initVersion();
        this.m_defaultEncoding = DEFAULT_ENCODING.intern();
        this.m_servletContainerSettings = new CmsServletContainerSettings(null);
    }

    public String getAbsoluteRfsPathRelativeToWebApplication(String path) {
        if (path == null || this.getWebApplicationRfsPath() == null) {
            return null;
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            path = f.getAbsolutePath();
            if (f.isDirectory() && !path.endsWith(File.separator)) {
                path = path.concat(File.separator);
            }
            return path;
        }
        return CmsFileUtil.normalizePath(this.getWebApplicationRfsPath() + path);
    }

    public String getAbsoluteRfsPathRelativeToWebInf(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            return f.getAbsolutePath();
        }
        return CmsFileUtil.normalizePath(this.getWebInfRfsPath() + path);
    }

    public String getConfigurationFileRfsPath() {
        if (this.m_configurationFileRfsPath == null) {
            this.m_configurationFileRfsPath = this.getAbsoluteRfsPathRelativeToWebInf(FOLDER_CONFIG + FILE_PROPERTIES);
        }
        return this.m_configurationFileRfsPath;
    }

    public String getContextPath() {
        return this.m_contextPath;
    }

    public String getDefaultEncoding() {
        return this.m_defaultEncoding;
    }

    public String getDefaultWebApplicationName() {
        return this.m_defaultWebApplicationName;
    }

    public int getHistoryVersions() {
        return this.m_historyVersions;
    }

    public int getHistoryVersionsAfterDeletion() {
        return this.m_historyVersionsAfterDeletion;
    }

    public CmsHttpAuthenticationSettings getHttpAuthenticationSettings() {
        return this.m_httpAuthenticationSettings;
    }

    public String getLogFileRfsPath() {
        return CmsLog.getLogFileRfsPath();
    }

    public CmsMailSettings getMailSettings() {
        return this.m_mailSettings;
    }

    public String getNotificationProject() {
        return this.m_notificationProject;
    }

    public int getNotificationTime() {
        return this.m_notificationTime;
    }

    public String getOpenCmsContext() {
        return this.m_openCmsContext;
    }

    public String getPackagesRfsPath() {
        if (this.m_packagesRfsPath == null) {
            this.m_packagesRfsPath = this.getAbsoluteRfsPathRelativeToWebInf(FOLDER_PACKAGES);
        }
        return this.m_packagesRfsPath;
    }

    public long getRuntime() {
        return System.currentTimeMillis() - this.m_startupTime;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public CmsServletContainerSettings getServletContainerSettings() {
        return this.m_servletContainerSettings;
    }

    public String getServletPath() {
        return this.m_servletPath;
    }

    public long getStartupTime() {
        return this.m_startupTime;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getVersionName() {
        return this.getVersionNumber();
    }

    public String getVersionNumber() {
        return this.m_versionNumber;
    }

    public String getWebApplicationName() {
        return this.m_webApplicationName;
    }

    public String getWebApplicationRfsPath() {
        return this.m_webApplicationRfsPath;
    }

    public String getWebInfRfsPath() {
        return this.m_webInfRfsPath;
    }

    public boolean isHistoryEnabled() {
        return this.m_historyEnabled;
    }

    public void setNotificationProject(String notificationProject) {
        this.m_notificationProject = notificationProject;
    }

    public void setNotificationTime(int notificationTime) {
        this.m_notificationTime = notificationTime;
    }

    public void setVersionHistorySettings(boolean historyEnabled, int historyVersions, int historyVersionsAfterDeletion) {
        this.m_historyEnabled = historyEnabled;
        this.m_historyVersions = historyVersions;
        this.m_historyVersionsAfterDeletion = historyVersionsAfterDeletion < 0 ? historyVersions : historyVersionsAfterDeletion;
    }

    protected void init(String webInfRfsPath, String servletMapping, String webApplicationContext, String defaultWebApplication, String servletContainerName, boolean throwException) {
        this.m_servletContainerSettings = new CmsServletContainerSettings(servletContainerName);
        this.m_servletContainerSettings.setServletThrowsException(throwException);
        webInfRfsPath = webInfRfsPath.replace('\\', '/');
        if (!webInfRfsPath.endsWith("/")) {
            webInfRfsPath = webInfRfsPath + "/";
        }
        this.m_webInfRfsPath = CmsFileUtil.normalizePath(webInfRfsPath);
        if (!servletMapping.startsWith("/")) {
            servletMapping = "/" + servletMapping;
        }
        if (servletMapping.endsWith("/*")) {
            servletMapping = servletMapping.substring(0, servletMapping.length() - 2);
        }
        this.m_servletPath = servletMapping;
        if (defaultWebApplication.endsWith("/")) {
            defaultWebApplication = defaultWebApplication.substring(0, defaultWebApplication.length() - 1);
        }
        if (defaultWebApplication.startsWith("/")) {
            defaultWebApplication = defaultWebApplication.substring(1);
        }
        this.m_defaultWebApplicationName = defaultWebApplication;
        File path = new File(this.m_webInfRfsPath);
        this.m_webApplicationName = path.getParentFile().getName();
        String contextPath = webApplicationContext == null ? this.m_webApplicationName : webApplicationContext;
        this.m_contextPath = contextPath.equals(this.getDefaultWebApplicationName()) ? "" : "/" + contextPath;
        if (this.m_contextPath.endsWith(".war")) {
            this.m_contextPath = this.m_contextPath.substring(0, this.m_contextPath.length() - 4);
        }
        this.m_openCmsContext = this.m_contextPath + this.m_servletPath;
        this.m_webApplicationRfsPath = path.getParentFile().getAbsolutePath();
        if (!this.m_webApplicationRfsPath.endsWith(File.separator)) {
            this.m_webApplicationRfsPath = this.m_webApplicationRfsPath + File.separator;
        }
    }

    protected void setDefaultEncoding(String encoding) {
        this.m_defaultEncoding = encoding.intern();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_SET_DEFAULT_ENCODING_1", this.m_defaultEncoding));
        }
    }

    protected void setHttpAuthenticationSettings(CmsHttpAuthenticationSettings httpAuthenticationSettings) {
        this.m_httpAuthenticationSettings = httpAuthenticationSettings;
    }

    protected void setMailSettings(CmsMailSettings mailSettings) {
        this.m_mailSettings = mailSettings;
    }

    protected void setServerName(String serverName) {
        this.m_serverName = serverName;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_SET_SERVERNAME_1", this.m_serverName));
        }
    }

    private void initVersion() {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_version = "OpenCms/" + this.m_versionNumber;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("org/opencms/main/version.properties"));
        }
        catch (Throwable t) {
            return;
        }
        this.m_versionNumber = props.getProperty("version.number", DEFAULT_VERSION_NUMBER);
        this.m_version = "OpenCms/" + this.m_versionNumber;
    }
}

