/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleVersion;
import org.opencms.module.I_CmsModuleAction;
import org.opencms.module.Messages;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsModule
implements Comparable {
    public static final long DEFAULT_DATE = 0L;
    private static final Log LOG = CmsLog.getLog(CmsModule.class);
    private static final String MODULE_PROPERTY_ADDITIONAL_RESOURCES = "additionalresources";
    private static final String MODULE_PROPERTY_ADDITIONAL_RESOURCES_SEPARATOR = ";";
    private String m_actionClass;
    private I_CmsModuleAction m_actionInstance;
    private String m_authorEmail;
    private String m_authorName;
    private boolean m_createClassesFolder;
    private boolean m_createElementsFolder;
    private boolean m_createLibFolder;
    private boolean m_createModuleFolder;
    private boolean m_createResourcesFolder;
    private boolean m_createTemplateFolder;
    private long m_dateCreated;
    private long m_dateInstalled;
    private List m_dependencies;
    private String m_description;
    private List m_explorerTypeSettings;
    private List m_exportPoints;
    private boolean m_frozen;
    private String m_group;
    private String m_name;
    private String m_niceName;
    private SortedMap m_parameters;
    private List m_resources;
    private List m_resourceTypes;
    private String m_userInstalled;
    private CmsModuleVersion m_version;

    public CmsModule() {
        this.m_version = new CmsModuleVersion("0.1");
        this.m_resources = Collections.EMPTY_LIST;
        this.m_exportPoints = Collections.EMPTY_LIST;
        this.m_dependencies = Collections.EMPTY_LIST;
    }

    public CmsModule(String name, String niceName, String group, String actionClass, String description, CmsModuleVersion version, String authorName, String authorEmail, long dateCreated, String userInstalled, long dateInstalled, List dependencies, List exportPoints, List resources, Map parameters) {
        this.m_name = name;
        this.setNiceName(niceName);
        this.setActionClass(actionClass);
        this.setGroup(group);
        this.m_description = CmsStringUtil.isEmpty(description) ? "" : description;
        this.m_version = version;
        this.m_authorName = CmsStringUtil.isEmpty(authorName) ? "" : authorName;
        this.m_authorEmail = CmsStringUtil.isEmpty(authorEmail) ? "" : authorEmail;
        this.m_dateCreated = dateCreated / 1000L * 1000L;
        this.m_userInstalled = CmsStringUtil.isEmpty(userInstalled) ? "" : userInstalled;
        this.m_dateInstalled = dateInstalled / 1000L * 1000L;
        this.m_dependencies = dependencies == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(dependencies);
        this.m_exportPoints = exportPoints == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(exportPoints);
        this.m_resources = resources == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(resources);
        this.m_parameters = parameters == null ? new TreeMap() : new TreeMap(parameters);
        this.initOldAdditionalResources();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MODULE_INSTANCE_CREATED_1", this.m_name));
        }
        this.m_resourceTypes = Collections.EMPTY_LIST;
        this.m_explorerTypeSettings = Collections.EMPTY_LIST;
    }

    public CmsModuleDependency checkDependency(CmsModule module) {
        CmsModuleDependency otherDepdendency = new CmsModuleDependency(module.getName(), module.getVersion());
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            CmsModuleDependency dependency = (CmsModuleDependency)this.m_dependencies.get(i);
            if (!dependency.dependesOn(otherDepdendency)) continue;
            return dependency;
        }
        return null;
    }

    public void checkResources(CmsObject cms) throws CmsIllegalArgumentException {
        CmsFileUtil.checkResources(cms, this.getResources());
    }

    public Object clone() {
        CmsModule result = new CmsModule(this.m_name, this.m_niceName, this.m_group, this.m_actionClass, this.m_description, this.m_version, this.m_authorName, this.m_authorEmail, this.m_dateCreated, this.m_userInstalled, this.m_dateInstalled, this.m_dependencies, this.m_exportPoints, this.m_resources, this.m_parameters);
        result.m_frozen = false;
        if (this.getExplorerTypes() != null) {
            result.setExplorerTypes(new ArrayList(this.getExplorerTypes()));
        }
        if (this.getResourceTypes() != null) {
            result.setResourceTypes(new ArrayList(this.getResourceTypes()));
        }
        if (this.getDependencies() != null) {
            result.setDependencies(new ArrayList(this.getDependencies()));
        }
        result.setCreateClassesFolder(this.m_createClassesFolder);
        result.setCreateElementsFolder(this.m_createElementsFolder);
        result.setCreateLibFolder(this.m_createLibFolder);
        result.setCreateModuleFolder(this.m_createModuleFolder);
        result.setCreateResourcesFolder(this.m_createResourcesFolder);
        result.setCreateTemplateFolder(this.m_createTemplateFolder);
        result.setResources(new ArrayList(this.m_resources));
        result.setExportPoints(new ArrayList(this.m_exportPoints));
        return result;
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsModule) {
            return this.m_name.compareTo(((CmsModule)obj).m_name);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsModule) {
            return ((CmsModule)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public String getActionClass() {
        return this.m_actionClass;
    }

    public I_CmsModuleAction getActionInstance() {
        return this.m_actionInstance;
    }

    public String getAuthorEmail() {
        return this.m_authorEmail;
    }

    public String getAuthorName() {
        return this.m_authorName;
    }

    public long getDateCreated() {
        return this.m_dateCreated;
    }

    public long getDateInstalled() {
        return this.m_dateInstalled;
    }

    public List getDependencies() {
        return this.m_dependencies;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List getExplorerTypes() {
        return this.m_explorerTypeSettings;
    }

    public List getExportPoints() {
        return this.m_exportPoints;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNiceName() {
        return this.m_niceName;
    }

    public String getParameter(String key) {
        return (String)this.m_parameters.get(key);
    }

    public String getParameter(String key, String defaultValue) {
        String value = (String)this.m_parameters.get(key);
        return value != null ? value : defaultValue;
    }

    public SortedMap getParameters() {
        return this.m_parameters;
    }

    public List getResources() {
        return this.m_resources;
    }

    public List getResourceTypes() {
        return this.m_resourceTypes;
    }

    public String getUserInstalled() {
        return this.m_userInstalled;
    }

    public CmsModuleVersion getVersion() {
        return this.m_version;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean isCreateClassesFolder() {
        return this.m_createClassesFolder;
    }

    public boolean isCreateElementsFolder() {
        return this.m_createElementsFolder;
    }

    public boolean isCreateLibFolder() {
        return this.m_createLibFolder;
    }

    public boolean isCreateModuleFolder() {
        return this.m_createModuleFolder;
    }

    public boolean isCreateResourcesFolder() {
        return this.m_createResourcesFolder;
    }

    public boolean isCreateTemplateFolder() {
        return this.m_createTemplateFolder;
    }

    public boolean isIdentical(CmsModule other) {
        if (!this.isEqual(this.m_name, other.m_name)) {
            return false;
        }
        if (!this.isEqual(this.m_niceName, other.m_niceName)) {
            return false;
        }
        if (!this.isEqual(this.m_version, other.m_version)) {
            return false;
        }
        if (!this.isEqual(this.m_actionClass, other.m_actionClass)) {
            return false;
        }
        if (!this.isEqual(this.m_description, other.m_description)) {
            return false;
        }
        if (!this.isEqual(this.m_authorName, other.m_authorName)) {
            return false;
        }
        if (!this.isEqual(this.m_authorEmail, other.m_authorEmail)) {
            return false;
        }
        return this.m_dateCreated == other.m_dateCreated;
    }

    public void setActionClass(String value) {
        this.checkFrozen();
        if (CmsStringUtil.isEmpty(value)) {
            this.m_actionClass = null;
        } else {
            if (!CmsStringUtil.isValidJavaClassName(value)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_ACTION_CLASS_2", value, this.getName()));
            }
            this.m_actionClass = value;
        }
    }

    public void setAuthorEmail(String value) {
        this.checkFrozen();
        this.m_authorEmail = value.trim();
    }

    public void setAuthorName(String value) {
        this.checkFrozen();
        this.m_authorName = value.trim();
    }

    public void setCreateClassesFolder(boolean createClassesFolder) {
        this.m_createClassesFolder = createClassesFolder;
    }

    public void setCreateElementsFolder(boolean createElementsFolder) {
        this.m_createElementsFolder = createElementsFolder;
    }

    public void setCreateLibFolder(boolean createLibFolder) {
        this.m_createLibFolder = createLibFolder;
    }

    public void setCreateModuleFolder(boolean createModuleFolder) {
        this.m_createModuleFolder = createModuleFolder;
    }

    public void setCreateResourcesFolder(boolean createResourcesFolder) {
        this.m_createResourcesFolder = createResourcesFolder;
    }

    public void setCreateTemplateFolder(boolean createTemplateFolder) {
        this.m_createTemplateFolder = createTemplateFolder;
    }

    public void setDateCreated(long value) {
        this.checkFrozen();
        this.m_dateCreated = value;
    }

    public void setDateInstalled(long value) {
        this.checkFrozen();
        this.m_dateInstalled = value;
    }

    public void setDependencies(List dependencies) {
        this.checkFrozen();
        this.m_dependencies = dependencies;
    }

    public void setDescription(String value) {
        this.checkFrozen();
        this.m_description = value.trim();
    }

    public void setExplorerTypes(List explorerTypeSettings) {
        this.m_explorerTypeSettings = explorerTypeSettings;
    }

    public void setExportPoints(List exportPoints) {
        this.m_exportPoints = exportPoints;
    }

    public void setGroup(String value) {
        this.checkFrozen();
        this.m_group = value;
    }

    public void setName(String value) {
        this.checkFrozen();
        if (!CmsStringUtil.isValidJavaClassName(value)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_NAME_1", value));
        }
        this.m_name = value;
    }

    public void setNiceName(String value) {
        this.checkFrozen();
        this.m_niceName = CmsStringUtil.isEmptyOrWhitespaceOnly(value) ? this.getName() : value.trim();
    }

    public void setParameters(SortedMap value) {
        this.checkFrozen();
        this.m_parameters = value;
    }

    public void setResources(List value) {
        this.checkFrozen();
        this.m_resources = value;
    }

    public void setResourceTypes(List resourceTypes) {
        this.m_resourceTypes = Collections.unmodifiableList(resourceTypes);
    }

    public void setUserInstalled(String value) {
        this.checkFrozen();
        this.m_userInstalled = value.trim();
    }

    protected void checkFrozen() throws CmsIllegalArgumentException {
        if (this.m_frozen) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_FROZEN_1", this.getName()));
        }
    }

    protected void initialize(CmsObject cms) throws CmsRoleViolationException {
        this.checkFrozen();
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        this.m_frozen = true;
        this.m_resources = Collections.unmodifiableList(this.m_resources);
    }

    void setActionInstance(I_CmsModuleAction actionInstance) {
        this.m_actionInstance = actionInstance;
    }

    private void initOldAdditionalResources() {
        TreeMap parameters = new TreeMap(this.m_parameters);
        ArrayList<String> resources = new ArrayList<String>(this.m_resources);
        String additionalResources = (String)parameters.get(MODULE_PROPERTY_ADDITIONAL_RESOURCES);
        if (additionalResources != null) {
            StringTokenizer tok = new StringTokenizer(additionalResources, MODULE_PROPERTY_ADDITIONAL_RESOURCES_SEPARATOR);
            while (tok.hasMoreTokens()) {
                String resource = tok.nextToken().trim();
                if ("-".equals(resource) || resources.contains(resource)) continue;
                resources.add(resource);
            }
        }
        this.m_resources = resources;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }
}

