/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsModuleConfiguration;
import org.opencms.db.CmsExportPoint;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.module.I_CmsModuleAction;
import org.opencms.module.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;

public class CmsModuleManager {
    public static final int DEPENDENCY_MODE_DELETE = 0;
    public static final int DEPENDENCY_MODE_IMPORT = 1;
    private static final Log LOG = CmsLog.getLog(CmsModuleManager.class);
    private Set m_moduleExportPoints;
    private Map m_modules;

    public CmsModuleManager(List configuredModules) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MOD_MANAGER_CREATED_0"));
        }
        this.m_modules = new Hashtable();
        for (int i = 0; i < configuredModules.size(); ++i) {
            CmsModule module = (CmsModule)configuredModules.get(i);
            this.m_modules.put(module.getName(), module);
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MOD_CONFIGURED_1", module.getName()));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_MODS_CONFIGURED_1", new Integer(this.m_modules.size())));
        }
        this.m_moduleExportPoints = Collections.EMPTY_SET;
    }

    public static Map buildDepsForAllModules(String rfsAbsPath, boolean mode) throws CmsConfigurationException {
        CmsModule module;
        HashMap ret = new HashMap();
        ArrayList modules = rfsAbsPath == null ? OpenCms.getModuleManager().getAllInstalledModules() : new ArrayList(CmsModuleManager.getAllModulesFromPath(rfsAbsPath).keySet());
        Iterator itMods = modules.iterator();
        while (itMods.hasNext()) {
            module = (CmsModule)itMods.next();
            Iterator itDeps = module.getDependencies().iterator();
            while (itDeps.hasNext()) {
                List<String> moduleDependencies;
                CmsModuleDependency dependency = (CmsModuleDependency)itDeps.next();
                String moduleDependencyName = dependency.getName();
                if (mode) {
                    moduleDependencies = (ArrayList<String>)ret.get(moduleDependencyName);
                    if (moduleDependencies == null) {
                        moduleDependencies = new ArrayList<String>();
                        ret.put(moduleDependencyName, moduleDependencies);
                    }
                    moduleDependencies.add(module.getName());
                    continue;
                }
                moduleDependencies = (List)ret.get(module.getName());
                if (moduleDependencies == null) {
                    moduleDependencies = new ArrayList();
                    ret.put(module.getName(), moduleDependencies);
                }
                moduleDependencies.add(dependency.getName());
            }
        }
        itMods = modules.iterator();
        while (itMods.hasNext()) {
            module = (CmsModule)itMods.next();
            if (ret.get(module.getName()) != null) continue;
            ret.put(module.getName(), new ArrayList());
        }
        return ret;
    }

    public static Map buildDepsForModulelist(List moduleNames, String rfsAbsPath, boolean mode) throws CmsConfigurationException {
        Map ret = CmsModuleManager.buildDepsForAllModules(rfsAbsPath, mode);
        Iterator<Object> itMods = rfsAbsPath == null ? OpenCms.getModuleManager().getAllInstalledModules().iterator() : CmsModuleManager.getAllModulesFromPath(rfsAbsPath).keySet().iterator();
        while (itMods.hasNext()) {
            CmsModule module = (CmsModule)itMods.next();
            if (moduleNames.contains(module.getName())) continue;
            Iterator itDeps = ret.values().iterator();
            while (itDeps.hasNext()) {
                List dependencies = (List)itDeps.next();
                dependencies.remove(module.getName());
            }
            ret.remove(module.getName());
        }
        return ret;
    }

    public static Map getAllModulesFromPath(String rfsAbsPath) throws CmsConfigurationException {
        File[] folderFiles;
        HashMap<CmsModule, String> modules = new HashMap<CmsModule, String>();
        if (rfsAbsPath == null) {
            return modules;
        }
        File folder = new File(rfsAbsPath);
        if (folder.exists() && (folderFiles = folder.listFiles()) != null) {
            for (int i = 0; i < folderFiles.length; ++i) {
                File manifest;
                File moduleFile = folderFiles[i];
                if (moduleFile.isFile() && !moduleFile.getAbsolutePath().toLowerCase().endsWith(".zip") || moduleFile.isDirectory() && (!(manifest = new File(moduleFile, "manifest.xml")).exists() || !manifest.canRead())) continue;
                modules.put(CmsModuleImportExportHandler.readModuleFromImport(moduleFile.getAbsolutePath()), moduleFile.getName());
            }
        }
        return modules;
    }

    public static List topologicalSort(List moduleNames, String rfsAbsPath) throws CmsConfigurationException {
        ArrayList modules = new ArrayList(moduleNames);
        ArrayList<String> retList = new ArrayList<String>();
        Map moduleDependencies = CmsModuleManager.buildDepsForModulelist(moduleNames, rfsAbsPath, true);
        boolean finished = false;
        while (!finished) {
            finished = true;
            Iterator itMods = modules.iterator();
            while (itMods.hasNext()) {
                String moduleName = (String)itMods.next();
                List deps = (List)moduleDependencies.get(moduleName);
                if (deps != null && !deps.isEmpty()) continue;
                retList.add(moduleName);
                Iterator itDeps = moduleDependencies.values().iterator();
                while (itDeps.hasNext()) {
                    List dependencies = (List)itDeps.next();
                    dependencies.remove(moduleName);
                }
                finished = false;
                itMods.remove();
            }
        }
        if (!modules.isEmpty()) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_MODULE_DEPENDENCY_CYCLE_1", ((Object)modules).toString()));
        }
        Collections.reverse(retList);
        return retList;
    }

    public synchronized void addModule(CmsObject cms, CmsModule module) throws CmsSecurityException, CmsConfigurationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        if (this.m_modules.containsKey(module.getName())) {
            throw new CmsConfigurationException(Messages.get().container("ERR_MODULE_ALREADY_CONFIGURED_1", module.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_CREATE_NEW_MOD_1", module.getName()));
        }
        module.initialize(cms);
        this.m_modules.put(module.getName(), module);
        try {
            I_CmsModuleAction moduleAction = module.getActionInstance();
            if (moduleAction != null) {
                moduleAction.moduleUpdate(module);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_MOD_UPDATE_ERR_1", module.getName()), t);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
    }

    public List checkDependencies(CmsModule module, int mode) {
        ArrayList<CmsModuleDependency> result = new ArrayList<CmsModuleDependency>();
        if (mode == 0) {
            Iterator i = this.m_modules.values().iterator();
            while (i.hasNext()) {
                CmsModule otherModule = (CmsModule)i.next();
                CmsModuleDependency dependency = otherModule.checkDependency(module);
                if (dependency == null) continue;
                result.add(new CmsModuleDependency(otherModule.getName(), otherModule.getVersion()));
            }
        } else if (mode == 1) {
            Iterator i = this.m_modules.values().iterator();
            result.addAll(module.getDependencies());
            while (i.hasNext() && result.size() > 0) {
                CmsModule otherModule = (CmsModule)i.next();
                CmsModuleDependency dependency = module.checkDependency(otherModule);
                if (dependency == null) continue;
                result.remove(dependency);
            }
        } else {
            throw new CmsRuntimeException(Messages.get().container("ERR_CHECK_DEPENDENCY_INVALID_MODE_1", new Integer(mode)));
        }
        return result;
    }

    public void checkModuleSelectionList(List moduleNames, String rfsAbsPath, boolean forDeletion) throws CmsIllegalArgumentException, CmsConfigurationException {
        Map moduleDependencies = CmsModuleManager.buildDepsForAllModules(rfsAbsPath, forDeletion);
        Iterator itMods = moduleNames.iterator();
        while (itMods.hasNext()) {
            String moduleName = (String)itMods.next();
            List dependencies = (List)moduleDependencies.get(moduleName);
            if (dependencies == null) continue;
            ArrayList depModules = new ArrayList(dependencies);
            depModules.removeAll(moduleNames);
            if (depModules.isEmpty()) continue;
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODULE_SELECTION_INCONSISTENT_2", moduleName, ((Object)depModules).toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteModule(CmsObject cms, String moduleName, boolean replace, I_CmsReport report) throws CmsRoleViolationException, CmsConfigurationException, CmsLockException {
        CmsProject deleteProject;
        CmsProject previousProject;
        boolean removeResourceTypes;
        CmsModule module;
        block42: {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
            if (!this.m_modules.containsKey(moduleName)) {
                throw new CmsConfigurationException(Messages.get().container("ERR_MODULE_NOT_CONFIGURED_1", moduleName));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MOD_1", moduleName));
            }
            module = (CmsModule)this.m_modules.get(moduleName);
            if (!replace) {
                List dependencies = this.checkDependencies(module, 0);
                if (!dependencies.isEmpty()) {
                    StringBuffer message = new StringBuffer();
                    Iterator it = dependencies.iterator();
                    while (it.hasNext()) {
                        message.append("  ").append(((CmsModuleDependency)it.next()).getName()).append("\r\n");
                    }
                    throw new CmsConfigurationException(Messages.get().container("ERR_MOD_DEPENDENCIES_2", moduleName, message.toString()));
                }
                try {
                    I_CmsModuleAction moduleAction = module.getActionInstance();
                    if (moduleAction != null) {
                        moduleAction.moduleUninstall(module);
                    }
                }
                catch (Throwable t) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_MOD_UNINSTALL_ERR_1", moduleName), t);
                    report.println(Messages.get().container("LOG_MOD_UNINSTALL_ERR_1", moduleName), 1);
                }
            }
            boolean bl = removeResourceTypes = !module.getResourceTypes().isEmpty();
            if (removeResourceTypes) {
                OpenCms.getWorkplaceManager().removeExplorerTypeSettings(module);
            }
            previousProject = cms.getRequestContext().currentProject();
            deleteProject = null;
            try {
                deleteProject = cms.readProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_NAME_1", new Object[]{moduleName}));
            }
            catch (CmsException e) {
                try {
                    deleteProject = cms.createProject(Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_NAME_1", new Object[]{moduleName}), Messages.get().getBundle(cms.getRequestContext().getLocale()).key("GUI_DELETE_MODULE_PROJECT_DESC_1", new Object[]{moduleName}), OpenCms.getDefaultUsers().getGroupAdministrators(), OpenCms.getDefaultUsers().getGroupAdministrators(), CmsProject.PROJECT_TYPE_TEMPORARY);
                }
                catch (CmsException e1) {
                    throw new CmsConfigurationException(e1.getMessageContainer(), (Throwable)e1);
                }
            }
            try {
                cms.getRequestContext().setCurrentProject(deleteProject);
                ArrayList lockedResources = new ArrayList();
                CmsLockFilter filter1 = CmsLockFilter.FILTER_ALL.filterNotLockableByUser(cms.getRequestContext().currentUser());
                CmsLockFilter filter2 = CmsLockFilter.FILTER_INHERITED;
                List moduleResources = module.getResources();
                for (int iLock = 0; iLock < moduleResources.size(); ++iLock) {
                    String resourceName = (String)moduleResources.get(iLock);
                    try {
                        lockedResources.addAll(cms.getLockedResources(resourceName, filter1));
                        lockedResources.addAll(cms.getLockedResources(resourceName, filter2));
                        continue;
                    }
                    catch (CmsException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e.getMessageContainer(), (Throwable)e);
                        }
                        report.println(e.getMessageContainer(), 1);
                    }
                }
                if (lockedResources.isEmpty()) break block42;
                CmsMessageContainer msg = Messages.get().container("ERR_DELETE_MODULE_CHECK_LOCKS_2", moduleName, CmsStringUtil.collectionAsString(lockedResources, ","));
                report.addError(msg.key(cms.getRequestContext().getLocale()));
                report.println(msg);
                cms.getRequestContext().setCurrentProject(previousProject);
                try {
                    cms.deleteProject(deleteProject.getUuid());
                }
                catch (CmsException e1) {
                    throw new CmsConfigurationException(e1.getMessageContainer(), (Throwable)e1);
                }
                throw new CmsLockException(msg);
            }
            finally {
                cms.getRequestContext().setCurrentProject(previousProject);
            }
        }
        module = (CmsModule)this.m_modules.remove(moduleName);
        try {
            int i;
            cms.getRequestContext().setCurrentProject(deleteProject);
            List projectFiles = module.getResources();
            for (i = 0; i < projectFiles.size(); ++i) {
                String resourceName = (String)projectFiles.get(i);
                if (!cms.existsResource(resourceName, CmsResourceFilter.ALL)) continue;
                try {
                    cms.copyResourceToProject(resourceName);
                    continue;
                }
                catch (CmsException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_RESOURCE_FAILED_1", resourceName));
                    }
                    report.println(e.getMessageContainer(), 1);
                }
            }
            report.print(Messages.get().container("RPT_DELETE_MODULE_BEGIN_0"), 2);
            report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_HTML_ITAG_1", moduleName), 2);
            for (i = 0; i < module.getResources().size(); ++i) {
                String currentResource = null;
                try {
                    currentResource = (String)module.getResources().get(i);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_MOD_RESOURCE_1", currentResource));
                    }
                    CmsResource resource = null;
                    try {
                        resource = cms.readResource(currentResource, CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        // empty catch block
                    }
                    if (resource == null) continue;
                    CmsLock lock = cms.getLock(currentResource);
                    if (lock.isUnlocked()) {
                        cms.lockResource(currentResource);
                    } else if (lock.isLockableBy(cms.getRequestContext().currentUser())) {
                        cms.changeLock(currentResource);
                    }
                    if (!resource.getState().isDeleted()) {
                        cms.deleteResource(currentResource, CmsResource.DELETE_PRESERVE_SIBLINGS);
                    }
                    report.print(Messages.get().container("RPT_DELETE_0"), 3);
                    report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", currentResource));
                    if (resource.getState().isNew()) continue;
                    cms.unlockResource(currentResource);
                    continue;
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_DEL_MOD_EXC_1", currentResource), (Throwable)e);
                    report.println(e.getMessageContainer(), 1);
                }
            }
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_BEGIN_0"), 2);
            cms.unlockProject(deleteProject.getUuid());
            OpenCms.getPublishManager().publishProject(cms, report);
            OpenCms.getPublishManager().waitWhileRunning();
            report.println(Messages.get().container("RPT_PUBLISH_PROJECT_END_0"), 2);
            report.println(Messages.get().container("RPT_DELETE_MODULE_END_0"), 2);
        }
        catch (CmsException e) {
            throw new CmsConfigurationException(e.getMessageContainer(), (Throwable)e);
        }
        finally {
            cms.getRequestContext().setCurrentProject(previousProject);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
        if (removeResourceTypes) {
            OpenCms.getResourceManager().initialize(cms);
        }
    }

    public List getAllInstalledModules() {
        return new ArrayList(this.m_modules.values());
    }

    public Set getExportPoints() {
        return this.m_moduleExportPoints;
    }

    public CmsModule getModule(String name) {
        return (CmsModule)this.m_modules.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getModuleNames() {
        Map map = this.m_modules;
        synchronized (map) {
            return new HashSet(this.m_modules.keySet());
        }
    }

    public boolean hasModule(String name) {
        return this.m_modules.containsKey(name);
    }

    public synchronized void initialize(CmsObject cms, CmsConfigurationManager configurationManager) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        }
        int count = 0;
        Iterator it = this.m_modules.keySet().iterator();
        while (it.hasNext()) {
            CmsModule module = (CmsModule)this.m_modules.get(it.next());
            if (module.getActionClass() == null) continue;
            I_CmsModuleAction moduleAction = module.getActionInstance();
            if (module.getActionClass() != null) {
                try {
                    moduleAction = (I_CmsModuleAction)Class.forName(module.getActionClass()).newInstance();
                }
                catch (Exception e) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_CREATE_INSTANCE_FAILED_1", module.getName()), (Throwable)e);
                }
            }
            if (moduleAction == null) continue;
            ++count;
            module.setActionInstance(moduleAction);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INITIALIZE_MOD_CLASS_1", moduleAction.getClass().getName()));
            }
            try {
                CmsObject adminCmsCopy = OpenCms.initCmsObject(cms);
                moduleAction.initialize(adminCmsCopy, configurationManager, module);
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_INIT_ERR_1", moduleAction.getClass().getName()), t);
            }
        }
        this.initModuleExportPoints();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_CLASSES_INITIALIZED_1", new Integer(count)));
        }
    }

    public synchronized void shutDown() {
        int count = 0;
        Iterator it = this.getModuleNames().iterator();
        while (it.hasNext()) {
            I_CmsModuleAction moduleAction;
            String moduleName = (String)it.next();
            CmsModule module = (CmsModule)this.m_modules.get(moduleName);
            if (module == null || (moduleAction = module.getActionInstance()) == null) continue;
            ++count;
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_MOD_CLASS_1", moduleAction.getClass().getName()));
            }
            try {
                moduleAction.shutDown(module);
            }
            catch (Throwable t) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_SHUTDOWN_ERR_1", moduleAction.getClass().getName()), t);
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_NUM_MOD_CLASSES_1", new Integer(count)));
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    public synchronized void updateModule(CmsObject cms, CmsModule module) throws CmsRoleViolationException, CmsConfigurationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.DATABASE_MANAGER);
        CmsModule oldModule = (CmsModule)this.m_modules.get(module.getName());
        if (oldModule == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_OLD_MOD_ERR_1", module.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_MOD_UPDATE_1", module.getName()));
        }
        if (oldModule.getVersion().compareTo(module.getVersion()) == 0) {
            module.getVersion().increment();
        }
        module.getVersion().setUpdated(true);
        module.initialize(cms);
        this.m_modules.put(module.getName(), module);
        try {
            I_CmsModuleAction moduleAction = oldModule.getActionInstance();
            if (moduleAction != null) {
                moduleAction.moduleUpdate(module);
                module.setActionInstance(moduleAction);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_UPDATE_ERR_1", module.getName()), t);
        }
        this.initModuleExportPoints();
        this.updateModuleConfiguration();
    }

    private synchronized void initModuleExportPoints() {
        HashSet<CmsExportPoint> exportPoints = new HashSet<CmsExportPoint>();
        Iterator i = this.m_modules.values().iterator();
        while (i.hasNext()) {
            CmsModule module = (CmsModule)i.next();
            List moduleExportPoints = module.getExportPoints();
            for (int j = 0; j < moduleExportPoints.size(); ++j) {
                CmsExportPoint point = (CmsExportPoint)moduleExportPoints.get(j);
                if (exportPoints.contains(point)) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_DUPLICATE_EXPORT_POINT_2", point, module.getName()));
                    continue;
                }
                exportPoints.add(point);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ADD_EXPORT_POINT_2", point, module.getName()));
            }
        }
        this.m_moduleExportPoints = Collections.unmodifiableSet(exportPoints);
    }

    private void updateModuleConfiguration() {
        OpenCms.writeConfiguration(CmsModuleConfiguration.class);
    }
}

