/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.Email;
import org.opencms.cache.CmsLruCache;
import org.opencms.cache.CmsMemoryObjectCache;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexCache;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockManager;
import org.opencms.mail.CmsMailTransport;
import org.opencms.mail.CmsSimpleMail;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitorConfiguration;
import org.opencms.monitor.CmsMemoryStatus;
import org.opencms.monitor.I_CmsMemoryMonitorable;
import org.opencms.monitor.Messages;
import org.opencms.publish.CmsPublishHistory;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.CmsPublishQueue;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.PrintfFormat;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;

public class CmsMemoryMonitor
implements I_CmsScheduledJob {
    private static final int INTERVAL_CLEAR = 600000;
    private static final Log LOG = CmsLog.getLog(CmsMemoryMonitor.class);
    private static boolean m_currentlyRunning;
    private static final int MAX_DEPTH = 5;
    private Map m_accessControlListCache;
    private boolean m_cacheProperty = true;
    private boolean m_cachePropertyList = true;
    private boolean m_cacheResource = true;
    private boolean m_cacheResourceList = true;
    private CmsMemoryMonitorConfiguration m_configuration;
    private Map m_contentDefinitionsCache;
    private Map m_groupCache;
    private int m_intervalEmail;
    private int m_intervalLog;
    private int m_intervalWarning;
    private long m_lastClearCache;
    private long m_lastEmailStatus;
    private long m_lastEmailWarning;
    private long m_lastLogStatus;
    private long m_lastLogWarning;
    private Map m_localeCache;
    private Map m_lockCache;
    private int m_logCount;
    private int m_maxUsagePercent;
    private Map m_memObjectCache;
    private CmsMemoryStatus m_memoryAverage;
    private CmsMemoryStatus m_memoryCurrent;
    private Map m_monitoredObjects = new HashMap();
    private Map m_orgUnitCache;
    private Map m_permissionCache;
    private Map m_projectCache;
    private Map m_projectResourcesCache;
    private Map m_propertyCache;
    private Map m_propertyListCache;
    private Map m_publishedResourcesCache;
    private Buffer m_publishHistory;
    private Buffer m_publishQueue;
    private Map m_resourceCache;
    private Map m_resourceListCache;
    private Map m_roleListsCache;
    private Map m_rolesCache;
    private Map m_userCache;
    private Map m_userGroupsCache;
    private Map m_vfsObjectCache;
    private boolean m_warningLoggedSinceLastStatus;
    private boolean m_warningSendSinceLastStatus;
    private Map m_xmlPermanentEntityCache;
    private Map m_xmlTemporaryEntityCache;

    public static int getMemorySize(Object obj) {
        if (obj instanceof I_CmsMemoryMonitorable) {
            return ((I_CmsMemoryMonitorable)obj).getMemorySize();
        }
        if (obj instanceof byte[]) {
            return 8 + (int)(Math.ceil((double)((byte[])obj).length / 16.0) * 16.0);
        }
        if (obj instanceof String) {
            return 24 + (int)(Math.ceil((double)((String)obj).length() / 8.0) * 16.0);
        }
        if (obj instanceof CmsFile) {
            CmsFile f = (CmsFile)obj;
            if (f.getContents() != null) {
                return f.getContents().length + 1024;
            }
            return 1024;
        }
        if (obj instanceof CmsUUID) {
            return 184;
        }
        if (obj instanceof CmsPermissionSet) {
            return 16;
        }
        if (obj instanceof CmsResource) {
            return 1024;
        }
        if (obj instanceof CmsPublishedResource) {
            return 512;
        }
        if (obj instanceof CmsUser) {
            return 2048;
        }
        if (obj instanceof CmsGroup) {
            return 512;
        }
        if (obj instanceof CmsProject) {
            return 512;
        }
        if (obj instanceof Boolean) {
            return 8;
        }
        if (obj instanceof CmsProperty) {
            int size = 8;
            CmsProperty property = (CmsProperty)obj;
            size += CmsMemoryMonitor.getMemorySize(property.getName());
            if (property.getResourceValue() != null) {
                size += CmsMemoryMonitor.getMemorySize(property.getResourceValue());
            }
            if (property.getStructureValue() != null) {
                size += CmsMemoryMonitor.getMemorySize(property.getStructureValue());
            }
            return size;
        }
        if (obj instanceof CmsPropertyDefinition) {
            int size = 8;
            CmsPropertyDefinition propDef = (CmsPropertyDefinition)obj;
            size += CmsMemoryMonitor.getMemorySize(propDef.getName());
            return size += CmsMemoryMonitor.getMemorySize(propDef.getId());
        }
        return 8;
    }

    public static long getValueSize(List listValue, int depth) {
        long totalSize;
        block8: {
            totalSize = 0L;
            try {
                Object[] values = listValue.toArray();
                int s = values.length;
                for (int i = 0; i < s; ++i) {
                    Object obj = values[i];
                    if (obj instanceof CmsAccessControlList) {
                        obj = ((CmsAccessControlList)obj).getPermissionMap();
                    }
                    if (obj instanceof CmsFlexCache.CmsFlexCacheVariation) {
                        obj = ((CmsFlexCache.CmsFlexCacheVariation)obj).m_map;
                    }
                    if (obj instanceof Map && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((Map)obj, depth + 1);
                        continue;
                    }
                    if (obj instanceof List && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((List)obj, depth + 1);
                        continue;
                    }
                    totalSize += (long)CmsMemoryMonitor.getMemorySize(obj);
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return totalSize;
    }

    public static long getValueSize(Map mapValue, int depth) {
        long totalSize;
        block8: {
            totalSize = 0L;
            try {
                Object[] values = mapValue.values().toArray();
                int s = values.length;
                for (int i = 0; i < s; ++i) {
                    Object obj = values[i];
                    if (obj instanceof CmsAccessControlList) {
                        obj = ((CmsAccessControlList)obj).getPermissionMap();
                    }
                    if (obj instanceof CmsFlexCache.CmsFlexCacheVariation) {
                        obj = ((CmsFlexCache.CmsFlexCacheVariation)obj).m_map;
                    }
                    if (obj instanceof Map && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((Map)obj, depth + 1);
                        continue;
                    }
                    if (obj instanceof List && depth < 5) {
                        totalSize += CmsMemoryMonitor.getValueSize((List)obj, depth + 1);
                        continue;
                    }
                    totalSize += (long)CmsMemoryMonitor.getMemorySize(obj);
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return totalSize;
    }

    public static long getValueSize(Object obj) {
        if (obj instanceof CmsLruCache) {
            return ((CmsLruCache)obj).size();
        }
        if (obj instanceof Map) {
            return CmsMemoryMonitor.getValueSize((Map)obj, 1);
        }
        if (obj instanceof List) {
            return CmsMemoryMonitor.getValueSize((List)obj, 1);
        }
        try {
            return CmsMemoryMonitor.getMemorySize(obj);
        }
        catch (Exception exc) {
            return 0L;
        }
    }

    public void cacheACL(String key, CmsAccessControlList acl) {
        this.m_accessControlListCache.put(key, acl);
    }

    public void cacheContentDefinition(String key, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinitionsCache.put(key, contentDefinition);
    }

    public void cacheGroup(CmsGroup group) {
        this.m_groupCache.put(group.getId().toString(), group);
        this.m_groupCache.put(group.getName(), group);
    }

    public void cacheLocale(String key, Locale locale) {
        if (this.m_localeCache != null) {
            this.m_localeCache.put(key, locale);
        }
    }

    public void cacheLock(CmsLock lock) {
        this.m_lockCache.put(lock.getResourceName(), lock);
    }

    public void cacheMemObject(String key, Object obj) {
        this.m_memObjectCache.put(key, obj);
    }

    public void cacheOrgUnit(CmsOrganizationalUnit orgUnit) {
        this.m_orgUnitCache.put(orgUnit.getId().toString(), orgUnit);
        this.m_orgUnitCache.put(orgUnit.getName(), orgUnit);
    }

    public void cachePermission(String key, I_CmsPermissionHandler.CmsPermissionCheckResult permission) {
        this.m_permissionCache.put(key, permission);
    }

    public void cacheProject(CmsProject project) {
        this.m_projectCache.put(project.getUuid().toString(), project);
        this.m_projectCache.put(project.getName(), project);
    }

    public void cacheProjectResources(String key, List projectResources) {
        this.m_projectResourcesCache.put(key, projectResources);
    }

    public void cacheProperty(String key, CmsProperty property) {
        if (!this.m_cacheProperty) {
            return;
        }
        this.m_propertyCache.put(key, property);
    }

    public void cachePropertyList(String key, List propertyList) {
        if (!this.m_cachePropertyList) {
            return;
        }
        this.m_propertyListCache.put(key, propertyList);
    }

    public void cachePublishedResources(String cacheKey, List publishedResources) {
        this.m_publishedResourcesCache.put(cacheKey, publishedResources);
    }

    public void cachePublishJob(CmsPublishJobInfoBean publishJob) {
        this.m_publishQueue.add((Object)publishJob);
    }

    public void cachePublishJobInHistory(CmsPublishJobInfoBean publishJob) {
        this.m_publishHistory.add((Object)publishJob);
    }

    public void cacheResource(String key, CmsResource resource) {
        if (!this.m_cacheResource) {
            return;
        }
        this.m_resourceCache.put(key, resource);
    }

    public void cacheResourceList(String key, List resourceList) {
        if (!this.m_cacheResourceList) {
            return;
        }
        this.m_resourceListCache.put(key, resourceList);
    }

    public void cacheRole(String key, boolean hasRole) {
        this.m_rolesCache.put(key, hasRole);
    }

    public void cacheRoleList(String key, List roles) {
        this.m_roleListsCache.put(key, roles);
    }

    public void cacheUser(CmsUser user) {
        this.m_userCache.put(user.getId().toString(), user);
        this.m_userCache.put(user.getName(), user);
    }

    public void cacheUserGroups(String key, List userGroups) {
        this.m_userGroupsCache.put(key, userGroups);
    }

    public void cacheVfsObject(String key, Object obj) {
        this.m_vfsObjectCache.put(key, obj);
    }

    public void cacheXmlPermanentEntity(String systemId, byte[] content) {
        this.m_xmlPermanentEntityCache.put(systemId, content);
    }

    public void cacheXmlTemporaryEntity(String key, byte[] content) {
        this.m_xmlTemporaryEntityCache.put(key, content);
    }

    public void clearAccessControlListCache() {
        this.flushACLs();
        this.flushPermissions();
        this.clearResourceCache();
    }

    public void clearCache() {
        this.clearPrincipalsCache();
        this.flushProjects();
        this.flushResources();
        this.flushResourceLists();
        this.flushProperties();
        this.flushPropertyLists();
        this.flushProjectResources();
        this.flushPublishedResources();
    }

    public void clearPrincipalsCache() {
        this.flushUsers();
        this.flushGroups();
        this.flushOrgUnits();
        this.flushUserGroups();
        this.flushACLs();
        this.flushPermissions();
        this.flushRoles();
        this.flushRoleLists();
    }

    public void clearResourceCache() {
        this.flushResources();
        this.flushRoles();
        this.flushRoleLists();
        this.flushResourceLists();
    }

    public void clearUserCache(CmsUser user) {
        this.uncacheUser(user);
        this.flushResourceLists();
    }

    public boolean enabled() {
        return true;
    }

    public void flushACLs() {
        this.m_accessControlListCache.clear();
    }

    public void flushContentDefinitions() {
        this.m_contentDefinitionsCache.clear();
    }

    public void flushGroups() {
        this.m_groupCache.clear();
    }

    public void flushLocales() {
        this.m_localeCache.clear();
    }

    public void flushLocks(Map newLocks) {
        if (newLocks == null || newLocks.isEmpty()) {
            this.m_lockCache.clear();
            return;
        }
        Map newLockCache = Collections.synchronizedMap(newLocks);
        this.register(CmsLockManager.class.getName(), newLockCache);
        Map oldCache = this.m_lockCache;
        this.m_lockCache = newLockCache;
        oldCache.clear();
    }

    public void flushMemObjects() {
        this.m_memObjectCache.clear();
    }

    public void flushOrgUnits() {
        this.m_orgUnitCache.clear();
    }

    public void flushPermissions() {
        this.m_permissionCache.clear();
    }

    public void flushProjectResources() {
        this.m_projectResourcesCache.clear();
    }

    public void flushProjects() {
        this.m_projectCache.clear();
    }

    public void flushProperties() {
        this.m_propertyCache.clear();
    }

    public void flushPropertyLists() {
        this.m_propertyListCache.clear();
    }

    public void flushPublishedResources() {
        this.m_publishedResourcesCache.clear();
    }

    public void flushPublishJobHistory() {
        this.m_publishHistory.clear();
    }

    public void flushPublishJobs() {
        this.m_publishQueue.clear();
    }

    public void flushResourceLists() {
        this.m_resourceListCache.clear();
    }

    public void flushResources() {
        this.m_resourceCache.clear();
    }

    public void flushRoleLists() {
        this.m_roleListsCache.clear();
    }

    public void flushRoles() {
        this.m_rolesCache.clear();
    }

    public void flushUserGroups() {
        this.m_userGroupsCache.clear();
    }

    public void flushUsers() {
        this.m_userCache.clear();
    }

    public void flushVfsObjects() {
        this.m_vfsObjectCache.clear();
    }

    public void flushXmlPermanentEntities() {
        this.m_xmlPermanentEntityCache.clear();
    }

    public void flushXmlTemporaryEntities() {
        this.m_xmlTemporaryEntityCache.clear();
    }

    public List getAllCachedLockPaths() {
        return new ArrayList(this.m_lockCache.keySet());
    }

    public List getAllCachedLocks() {
        return new ArrayList(this.m_lockCache.values());
    }

    public List getAllCachedPublishJobs() {
        return new ArrayList(this.m_publishQueue);
    }

    public List getAllCachedPublishJobsInHistory() {
        return new ArrayList(this.m_publishHistory);
    }

    public CmsAccessControlList getCachedACL(String key) {
        return (CmsAccessControlList)this.m_accessControlListCache.get(key);
    }

    public CmsXmlContentDefinition getCachedContentDefinition(String key) {
        return (CmsXmlContentDefinition)this.m_contentDefinitionsCache.get(key);
    }

    public CmsGroup getCachedGroup(String key) {
        return (CmsGroup)this.m_groupCache.get(key);
    }

    public Locale getCachedLocale(String key) {
        if (this.m_localeCache == null) {
            return null;
        }
        return (Locale)this.m_localeCache.get(key);
    }

    public CmsLock getCachedLock(String rootPath) {
        return (CmsLock)this.m_lockCache.get(rootPath);
    }

    public Object getCachedMemObject(String key) {
        return this.m_memObjectCache.get(key);
    }

    public CmsOrganizationalUnit getCachedOrgUnit(String key) {
        return (CmsOrganizationalUnit)this.m_orgUnitCache.get(key);
    }

    public I_CmsPermissionHandler.CmsPermissionCheckResult getCachedPermission(String key) {
        return (I_CmsPermissionHandler.CmsPermissionCheckResult)this.m_permissionCache.get(key);
    }

    public CmsProject getCachedProject(String key) {
        return (CmsProject)this.m_projectCache.get(key);
    }

    public List getCachedProjectResources(String key) {
        return (List)this.m_projectResourcesCache.get(key);
    }

    public CmsProperty getCachedProperty(String key) {
        if (!this.m_cacheProperty) {
            return null;
        }
        return (CmsProperty)this.m_propertyCache.get(key);
    }

    public List getCachedPropertyList(String key) {
        if (!this.m_cachePropertyList) {
            return null;
        }
        return (List)this.m_propertyListCache.get(key);
    }

    public List getCachedPublishedResources(String cacheKey) {
        return (List)this.m_publishedResourcesCache.get(cacheKey);
    }

    public CmsPublishJobInfoBean getCachedPublishJob(String key) {
        Iterator i = this.m_publishQueue.iterator();
        while (i.hasNext()) {
            CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)i.next();
            if (!publishJob.getPublishHistoryId().toString().equals(key)) continue;
            return publishJob;
        }
        return null;
    }

    public CmsPublishJobInfoBean getCachedPublishJobInHistory(String key) {
        Iterator i = this.m_publishHistory.iterator();
        while (i.hasNext()) {
            CmsPublishJobInfoBean publishJob = (CmsPublishJobInfoBean)i.next();
            if (!publishJob.getPublishHistoryId().toString().equals(key)) continue;
            return publishJob;
        }
        return null;
    }

    public CmsResource getCachedResource(String key) {
        if (!this.m_cacheResource) {
            return null;
        }
        return (CmsResource)this.m_resourceCache.get(key);
    }

    public List getCachedResourceList(String key) {
        if (!this.m_cacheResourceList) {
            return null;
        }
        return (List)this.m_resourceListCache.get(key);
    }

    public Boolean getCachedRole(String key) {
        return (Boolean)this.m_rolesCache.get(key);
    }

    public List getCachedRoleList(String key) {
        return (List)this.m_roleListsCache.get(key);
    }

    public CmsUser getCachedUser(String key) {
        return (CmsUser)this.m_userCache.get(key);
    }

    public List getCachedUserGroups(String key) {
        return (List)this.m_userGroupsCache.get(key);
    }

    public Object getCachedVfsObject(String key) {
        return this.m_vfsObjectCache.get(key);
    }

    public byte[] getCachedXmlPermanentEntity(String systemId) {
        return (byte[])this.m_xmlPermanentEntityCache.get(systemId);
    }

    public byte[] getCachedXmlTemporaryEntity(String key) {
        return (byte[])this.m_xmlTemporaryEntityCache.get(key);
    }

    public CmsMemoryMonitorConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public CmsPublishJobInfoBean getFirstCachedPublishJob() {
        if (!this.m_publishQueue.isEmpty()) {
            return (CmsPublishJobInfoBean)this.m_publishQueue.get();
        }
        return null;
    }

    public int getLogCount() {
        return this.m_logCount;
    }

    public void initialize(CmsSystemConfiguration configuration) {
        CmsCacheSettings cacheSettings = configuration.getCacheSettings();
        this.m_memoryAverage = new CmsMemoryStatus();
        this.m_memoryCurrent = new CmsMemoryStatus();
        this.m_warningSendSinceLastStatus = false;
        this.m_warningLoggedSinceLastStatus = false;
        this.m_lastEmailWarning = 0L;
        this.m_lastEmailStatus = 0L;
        this.m_lastLogStatus = 0L;
        this.m_lastLogWarning = 0L;
        this.m_lastClearCache = 0L;
        this.m_configuration = configuration.getCmsMemoryMonitorConfiguration();
        this.m_intervalWarning = 43200000;
        this.m_maxUsagePercent = 90;
        this.m_intervalEmail = this.m_configuration.getEmailInterval() * 1000;
        this.m_intervalLog = this.m_configuration.getLogInterval() * 1000;
        if (this.m_configuration.getWarningInterval() > 0) {
            this.m_intervalWarning = this.m_configuration.getWarningInterval();
        }
        this.m_intervalWarning *= 1000;
        if (this.m_configuration.getMaxUsagePercent() > 0) {
            this.m_maxUsagePercent = this.m_configuration.getMaxUsagePercent();
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_LOG_1", new Integer(this.m_intervalLog / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_EMAIL_1", new Integer(this.m_intervalEmail / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_WARNING_1", new Integer(this.m_intervalWarning / 1000)));
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_INTERVAL_MAX_USAGE_1", new Integer(this.m_maxUsagePercent)));
            if (this.m_configuration.getEmailReceiver() == null || this.m_configuration.getEmailSender() == null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_DISABLED_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_SENDER_1", this.m_configuration.getEmailSender()));
                Iterator i = this.m_configuration.getEmailReceiver().iterator();
                int n = 0;
                while (i.hasNext()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_MM_EMAIL_RECEIVER_2", new Integer(n + 1), i.next()));
                    ++n;
                }
            }
        }
        LRUMap xmlTemporaryCache = new LRUMap(128);
        this.m_xmlTemporaryEntityCache = Collections.synchronizedMap(xmlTemporaryCache);
        this.register(CmsXmlEntityResolver.class.getName() + ".xmlEntityTemporaryCache", this.m_xmlTemporaryEntityCache);
        HashMap xmlPermanentCache = new HashMap(32);
        this.m_xmlPermanentEntityCache = Collections.synchronizedMap(xmlPermanentCache);
        this.register(CmsXmlEntityResolver.class.getName() + ".xmlEntityPermanentCache", this.m_xmlPermanentEntityCache);
        LRUMap contentDefinitionsCache = new LRUMap(64);
        this.m_contentDefinitionsCache = Collections.synchronizedMap(contentDefinitionsCache);
        this.register(CmsXmlEntityResolver.class.getName() + ".contentDefinitionsCache", this.m_contentDefinitionsCache);
        HashMap lockCache = new HashMap();
        this.m_lockCache = Collections.synchronizedMap(lockCache);
        this.register(CmsLockManager.class.getName(), lockCache);
        HashMap map = new HashMap();
        this.m_localeCache = Collections.synchronizedMap(map);
        this.register(CmsLocaleManager.class.getName(), map);
        LRUMap lruMap = new LRUMap(cacheSettings.getPermissionCacheSize());
        this.m_permissionCache = Collections.synchronizedMap(lruMap);
        this.register(CmsSecurityManager.class.getName(), lruMap);
        lruMap = new LRUMap(cacheSettings.getUserCacheSize());
        this.m_userCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".userCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getGroupCacheSize());
        this.m_groupCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".groupCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getOrgUnitCacheSize());
        this.m_orgUnitCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".orgUnitCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getUserGroupsCacheSize());
        this.m_userGroupsCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".userGroupsCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getProjectCacheSize());
        this.m_projectCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".projectCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getProjectResourcesCacheSize());
        this.m_projectResourcesCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".projectResourcesCache", lruMap);
        int size = configuration.getPublishManager().getPublishHistorySize();
        Buffer buffer = CmsPublishHistory.getQueue(size);
        this.m_publishHistory = SynchronizedBuffer.decorate((Buffer)buffer);
        this.register(CmsPublishHistory.class.getName() + ".publishHistory", buffer);
        buffer = CmsPublishQueue.getQueue();
        this.m_publishQueue = SynchronizedBuffer.decorate((Buffer)buffer);
        this.register(CmsPublishQueue.class.getName() + ".publishQueue", buffer);
        lruMap = new LRUMap(cacheSettings.getResourceCacheSize());
        this.m_resourceCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".resourceCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getRolesCacheSize());
        this.m_rolesCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".rolesCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getRolesCacheSize());
        this.m_roleListsCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".roleListsCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getResourcelistCacheSize());
        this.m_resourceListCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".resourceListCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getPropertyCacheSize());
        this.m_propertyCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".propertyCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getPropertyListsCacheSize());
        this.m_propertyListCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".propertyListCache", lruMap);
        lruMap = new LRUMap(5);
        this.m_publishedResourcesCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".publishedResourcesCache", lruMap);
        lruMap = new LRUMap(cacheSettings.getAclCacheSize());
        this.m_accessControlListCache = Collections.synchronizedMap(lruMap);
        this.register(CmsDriverManager.class.getName() + ".accessControlListCache", lruMap);
        HashMap vfsObjectCache = new HashMap();
        this.m_vfsObjectCache = Collections.synchronizedMap(vfsObjectCache);
        this.register(CmsVfsMemoryObjectCache.class.getName(), vfsObjectCache);
        HashMap memObjectCache = new HashMap();
        this.m_memObjectCache = Collections.synchronizedMap(memObjectCache);
        this.register(CmsMemoryObjectCache.class.getName(), memObjectCache);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MM_CREATED_1", new Date(System.currentTimeMillis())));
        }
    }

    public boolean isCacheProperty() {
        return this.m_cacheProperty;
    }

    public boolean isCachePropertyList() {
        return this.m_cachePropertyList;
    }

    public boolean isCacheResource() {
        return this.m_cacheResource;
    }

    public boolean isCacheResourceList() {
        return this.m_cacheResourceList;
    }

    public boolean isMonitoring(String key) {
        return this.m_monitoredObjects.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String launch(CmsObject cms, Map parameters) throws Exception {
        CmsMemoryMonitor monitor = OpenCms.getMemoryMonitor();
        if (m_currentlyRunning) {
            return null;
        }
        try {
            m_currentlyRunning = true;
            monitor.updateStatus();
            if (monitor.lowMemory()) {
                monitor.monitorWriteLog(true);
                monitor.monitorSendEmail(true);
                monitor.clearCaches();
            }
            if (System.currentTimeMillis() - monitor.m_lastLogStatus > (long)monitor.m_intervalLog) {
                monitor.monitorWriteLog(false);
            }
            if (System.currentTimeMillis() - monitor.m_lastEmailStatus > (long)monitor.m_intervalEmail) {
                monitor.monitorSendEmail(false);
            }
        }
        finally {
            m_currentlyRunning = false;
        }
        return null;
    }

    public boolean lowMemory() {
        return this.m_maxUsagePercent > 0 && this.m_memoryCurrent.getUsage() > (long)this.m_maxUsagePercent;
    }

    public void register(String objectName, Object object) {
        if (this.enabled()) {
            this.m_monitoredObjects.put(objectName, object);
        }
    }

    public boolean requiresPersistency() {
        return true;
    }

    public void setCacheProperty(boolean cacheProperty) {
        this.m_cacheProperty = cacheProperty;
        this.flushProperties();
    }

    public void setCachePropertyList(boolean cachePropertyList) {
        this.m_cachePropertyList = cachePropertyList;
        this.flushPropertyLists();
    }

    public void setCacheResource(boolean cacheResource) {
        this.m_cacheResource = cacheResource;
        this.flushResources();
    }

    public void setCacheResourceList(boolean cacheResourceList) {
        this.m_cacheResourceList = cacheResourceList;
        this.flushResourceLists();
    }

    public void shutdown() throws Exception {
        this.flushACLs();
        this.flushGroups();
        this.flushLocales();
        this.flushMemObjects();
        this.flushOrgUnits();
        this.flushPermissions();
        this.flushProjectResources();
        this.flushProjects();
        this.flushProperties();
        this.flushPropertyLists();
        this.flushResourceLists();
        this.flushResources();
        this.flushUserGroups();
        this.flushUsers();
        this.flushVfsObjects();
        this.flushLocks(null);
        this.flushContentDefinitions();
        this.flushXmlPermanentEntities();
        this.flushXmlTemporaryEntities();
        this.flushRoles();
        this.flushRoleLists();
    }

    public void uncacheContentDefinition(String key) {
        this.m_contentDefinitionsCache.remove(key);
    }

    public void uncacheGroup(CmsGroup group) {
        this.m_groupCache.remove(group.getId().toString());
        this.m_groupCache.remove(group.getName());
    }

    public void uncacheLock(String rootPath) {
        this.m_lockCache.remove(rootPath);
    }

    public void uncacheOrgUnit(CmsOrganizationalUnit orgUnit) {
        this.m_orgUnitCache.remove(orgUnit.getId().toString());
        this.m_orgUnitCache.remove(orgUnit.getName());
    }

    public void uncacheProject(CmsProject project) {
        this.m_projectCache.remove(project.getUuid().toString());
        this.m_projectCache.remove(project.getName());
    }

    public void uncachePublishJob(CmsPublishJobInfoBean publishJob) {
        this.m_publishQueue.remove((Object)publishJob);
    }

    public void uncachePublishJobInHistory(CmsPublishJobInfoBean publishJob) {
        this.m_publishHistory.remove((Object)publishJob);
    }

    public void uncacheUser(CmsUser user) {
        this.m_userCache.remove(user.getId().toString());
        this.m_userCache.remove(user.getName());
    }

    public void uncacheVfsObject(String key) {
        this.m_vfsObjectCache.remove(key);
    }

    public void uncacheXmlTemporaryEntity(String key) {
        this.m_xmlTemporaryEntityCache.remove(key);
    }

    private void clearCaches() {
        if (this.m_lastClearCache + 600000L > System.currentTimeMillis()) {
            return;
        }
        this.m_lastClearCache = System.currentTimeMillis();
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_CLEAR_CACHE_MEM_CONS_0"));
        }
        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
        System.gc();
    }

    private long getCosts(Object obj) {
        long costs = 0L;
        if (obj instanceof CmsLruCache && (costs = (long)((CmsLruCache)obj).getObjectCosts()) < 0L) {
            costs = 0L;
        }
        return costs;
    }

    private String getItems(Object obj) {
        if (obj instanceof CmsLruCache) {
            return Integer.toString(((CmsLruCache)obj).size());
        }
        if (obj instanceof Map) {
            return Integer.toString(((Map)obj).size());
        }
        return "-";
    }

    private long getKeySize(Map map, int depth) {
        long keySize;
        block5: {
            keySize = 0L;
            try {
                Object[] values = map.values().toArray();
                int s = values.length;
                for (int i = 0; i < s; ++i) {
                    Object obj = values[i];
                    if (!(obj instanceof Map) || depth >= 5) continue;
                    keySize += this.getKeySize((Map)obj, depth + 1);
                }
                values = null;
                Object[] keys = map.keySet().toArray();
                int s2 = keys.length;
                for (int i = 0; i < s2; ++i) {
                    Object obj = keys[i];
                    if (!(obj instanceof String)) continue;
                    String st = (String)obj;
                    keySize += (long)(st.length() * 2);
                }
            }
            catch (ConcurrentModificationException e) {
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CAUGHT_THROWABLE_1", t.getMessage()));
            }
        }
        return keySize;
    }

    private long getKeySize(Object obj) {
        if (obj instanceof Map) {
            return this.getKeySize((Map)obj, 1);
        }
        return 0L;
    }

    private String getLimit(Object obj) {
        if (obj instanceof CmsLruCache) {
            return Integer.toString(((CmsLruCache)obj).getMaxCacheCosts());
        }
        if (obj instanceof LRUMap) {
            return Integer.toString(((LRUMap)obj).maxSize());
        }
        return "-";
    }

    private void monitorSendEmail(boolean warning) {
        CmsSessionManager sm;
        String subject;
        if (this.m_configuration.getEmailSender() == null || this.m_configuration.getEmailReceiver() == null) {
            return;
        }
        if (warning && this.m_warningSendSinceLastStatus && (this.m_intervalEmail > 0 || System.currentTimeMillis() >= this.m_lastEmailWarning + (long)this.m_intervalWarning)) {
            return;
        }
        if (!warning && this.m_intervalEmail <= 0) {
            return;
        }
        String date = CmsDateUtil.getDateTimeShort(System.currentTimeMillis());
        String content = "";
        if (warning) {
            this.m_warningSendSinceLastStatus = true;
            this.m_lastEmailWarning = System.currentTimeMillis();
            subject = "OpenCms Memory W A R N I N G [" + OpenCms.getSystemInfo().getServerName().toUpperCase() + "/" + date + "]";
            content = content + "W A R N I N G !\nOpenCms memory consumption on server " + OpenCms.getSystemInfo().getServerName().toUpperCase() + " has reached a critical level !\n\n" + "The configured limit is " + this.m_maxUsagePercent + "%\n\n";
        } else {
            this.m_warningSendSinceLastStatus = false;
            this.m_lastEmailStatus = System.currentTimeMillis();
            subject = "OpenCms Memory Status [" + OpenCms.getSystemInfo().getServerName().toUpperCase() + "/" + date + "]";
        }
        content = content + "Memory usage report of OpenCms server " + OpenCms.getSystemInfo().getServerName().toUpperCase() + " at " + date + "\n\n" + "Memory maximum heap size: " + this.m_memoryCurrent.getMaxMemory() + " mb\n" + "Memory current heap size: " + this.m_memoryCurrent.getTotalMemory() + " mb\n\n" + "Memory currently used   : " + this.m_memoryCurrent.getUsedMemory() + " mb (" + this.m_memoryCurrent.getUsage() + "%)\n" + "Memory currently unused : " + this.m_memoryCurrent.getFreeMemory() + " mb\n\n\n";
        if (warning) {
            content = content + "*** Please take action NOW to ensure that no OutOfMemoryException occurs.\n\n\n";
        }
        if ((sm = OpenCms.getSessionManager()) != null) {
            content = content + "Current status of the sessions:\n\n";
            content = content + "Logged in users          : " + sm.getSessionCountAuthenticated() + "\n";
            content = content + "Currently active sessions: " + sm.getSessionCountCurrent() + "\n";
            content = content + "Total created sessions   : " + sm.getSessionCountTotal() + "\n\n\n";
        }
        sm = null;
        content = content + "Current status of the caches:\n\n";
        List<Object> keyList = Arrays.asList(this.m_monitoredObjects.keySet().toArray());
        Collections.sort(keyList);
        long totalSize = 0L;
        Iterator<Object> keys = keyList.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] shortKeys = key.split("\\.");
            String shortKey = shortKeys[shortKeys.length - 2] + '.' + shortKeys[shortKeys.length - 1];
            PrintfFormat form = new PrintfFormat("%9s");
            Object obj = this.m_monitoredObjects.get(key);
            long size = this.getKeySize(obj) + CmsMemoryMonitor.getValueSize(obj) + this.getCosts(obj);
            totalSize += size;
            content = content + new PrintfFormat("%-42.42s").sprintf(shortKey) + "  " + "Entries: " + form.sprintf(this.getItems(obj)) + "   " + "Limit: " + form.sprintf(this.getLimit(obj)) + "   " + "Size: " + form.sprintf(Long.toString(size)) + "\n";
        }
        content = content + "\nTotal size of cache memory monitored: " + totalSize + " (" + totalSize / 0x100000L + ")\n\n";
        String from = this.m_configuration.getEmailSender();
        ArrayList<InternetAddress> receivers = new ArrayList<InternetAddress>();
        List receiverEmails = this.m_configuration.getEmailReceiver();
        try {
            if (from != null && receiverEmails != null && !receiverEmails.isEmpty()) {
                Iterator i = receiverEmails.iterator();
                while (i.hasNext()) {
                    receivers.add(new InternetAddress((String)i.next()));
                }
                CmsSimpleMail email = new CmsSimpleMail();
                email.setFrom(from);
                email.setTo(receivers);
                email.setSubject(subject);
                email.setMsg(content);
                new CmsMailTransport((Email)email).send();
            }
            if (LOG.isInfoEnabled()) {
                if (warning) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_EMAIL_SENT_0"));
                } else {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_STATUS_EMAIL_SENT_0"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void monitorWriteLog(boolean warning) {
        if (!LOG.isWarnEnabled()) {
            return;
        }
        if (!warning && !LOG.isInfoEnabled()) {
            return;
        }
        if (warning && this.m_warningLoggedSinceLastStatus && (this.m_intervalLog > 0 || System.currentTimeMillis() >= this.m_lastLogWarning + (long)this.m_intervalWarning)) {
            return;
        }
        if (!warning && this.m_intervalLog <= 0) {
            return;
        }
        if (warning) {
            this.m_lastLogWarning = System.currentTimeMillis();
            this.m_warningLoggedSinceLastStatus = true;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_CONSUME_2", new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent)));
        } else {
            this.m_warningLoggedSinceLastStatus = false;
            this.m_lastLogStatus = System.currentTimeMillis();
        }
        if (warning) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_6", new Object[]{new Long(this.m_memoryCurrent.getMaxMemory()), new Long(this.m_memoryCurrent.getTotalMemory()), new Long(this.m_memoryCurrent.getFreeMemory()), new Long(this.m_memoryCurrent.getUsedMemory()), new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent)}));
        } else {
            ++this.m_logCount;
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_LOG_INFO_2", OpenCms.getSystemInfo().getServerName().toUpperCase(), String.valueOf(this.m_logCount)));
            List<Object> keyList = Arrays.asList(this.m_monitoredObjects.keySet().toArray());
            Collections.sort(keyList);
            long totalSize = 0L;
            Iterator<Object> keys = keyList.iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object obj = this.m_monitoredObjects.get(key);
                long size = this.getKeySize(obj) + CmsMemoryMonitor.getValueSize(obj) + this.getCosts(obj);
                totalSize += size;
                PrintfFormat name1 = new PrintfFormat("%-80s");
                PrintfFormat name2 = new PrintfFormat("%-50s");
                PrintfFormat form = new PrintfFormat("%9s");
                LOG.info((Object)Messages.get().getBundle().key("LOG_MM_NOWARN_STATUS_5", new Object[]{name1.sprintf(key), name2.sprintf(obj.getClass().getName()), form.sprintf(this.getItems(obj)), form.sprintf(this.getLimit(obj)), form.sprintf(Long.toString(size))}));
            }
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_6", new Object[]{new Long(this.m_memoryCurrent.getMaxMemory()), new Long(this.m_memoryCurrent.getTotalMemory()), new Long(this.m_memoryCurrent.getFreeMemory()), new Long(this.m_memoryCurrent.getUsedMemory()), new Long(this.m_memoryCurrent.getUsage()), new Integer(this.m_maxUsagePercent), new Long(totalSize), new Long(totalSize / 0x100000L)}));
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_WARNING_MEM_STATUS_AVG_6", new Object[]{new Long(this.m_memoryAverage.getMaxMemory()), new Long(this.m_memoryAverage.getTotalMemory()), new Long(this.m_memoryAverage.getFreeMemory()), new Long(this.m_memoryAverage.getUsedMemory()), new Long(this.m_memoryAverage.getUsage()), new Integer(this.m_memoryAverage.getCount())}));
            CmsSessionManager sm = OpenCms.getSessionManager();
            if (sm != null) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_MM_SESSION_STAT_3", String.valueOf(sm.getSessionCountAuthenticated()), String.valueOf(sm.getSessionCountCurrent()), String.valueOf(sm.getSessionCountTotal())));
            }
            sm = null;
            Iterator i = OpenCms.getSqlManager().getDbPoolUrls().iterator();
            while (i.hasNext()) {
                String poolname = (String)i.next();
                try {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_CONNECTIONS_3", poolname, Integer.toString(OpenCms.getSqlManager().getActiveConnections(poolname)), Integer.toString(OpenCms.getSqlManager().getIdleConnections(poolname))));
                }
                catch (Exception exc) {
                    LOG.info((Object)Messages.get().getBundle().key("LOG_MM_CONNECTIONS_3", poolname, Integer.toString(-1), Integer.toString(-1)));
                }
            }
            LOG.info((Object)Messages.get().getBundle().key("LOG_MM_STARTUP_TIME_2", CmsDateUtil.getDateTimeShort(OpenCms.getSystemInfo().getStartupTime()), CmsStringUtil.formatRuntime(OpenCms.getSystemInfo().getRuntime())));
        }
    }

    private void updateStatus() {
        this.m_memoryCurrent.update();
        this.m_memoryAverage.calculateAverage(this.m_memoryCurrent);
    }
}

