/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.report.CmsHtmlReport;
import org.opencms.report.CmsPrintStreamReport;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;

public class CmsPublishReport
extends CmsPrintStreamReport {
    protected ByteArrayOutputStream m_outputStream;
    private boolean m_busy;
    private I_CmsReport m_report;

    protected CmsPublishReport(Locale locale) {
        this(new ByteArrayOutputStream(), locale);
    }

    private CmsPublishReport(ByteArrayOutputStream outputStream, Locale locale) {
        super(new PrintStream(outputStream), locale, true);
        this.init(locale, null);
        this.m_outputStream = outputStream;
    }

    private CmsPublishReport(I_CmsReport report) {
        this(new ByteArrayOutputStream(), report.getLocale());
        this.m_report = report;
        if (report instanceof CmsHtmlReport && ((CmsHtmlReport)report).isWriteHtml()) {
            try {
                this.m_outputStream.write(CmsStringUtil.substitute(this.getReportUpdate(), "\\n", "").getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static CmsPrintStreamReport decorate(I_CmsReport report) {
        return new CmsPublishReport(report);
    }

    public void addError(Object obj) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.addError(obj);
        }
        this.m_busy = true;
        super.addError(obj);
        this.m_busy = false;
    }

    public void addWarning(Object obj) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.addWarning(obj);
        }
        this.m_busy = true;
        super.addWarning(obj);
        this.m_busy = false;
    }

    public byte[] getContents() {
        return this.m_outputStream.toByteArray();
    }

    public List getErrors() {
        if (this.m_report != null) {
            return this.m_report.getErrors();
        }
        return super.getErrors();
    }

    public synchronized String getReportUpdate() {
        if (this.m_report != null) {
            return this.m_report.getReportUpdate();
        }
        return super.getReportUpdate();
    }

    public List getWarnings() {
        if (this.m_report != null) {
            return this.m_report.getWarnings();
        }
        return super.getWarnings();
    }

    public void print(CmsMessageContainer container) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.print(container);
        }
        this.m_busy = true;
        super.print(container);
        this.m_busy = false;
    }

    public void print(CmsMessageContainer container, int format) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.print(container, format);
        }
        this.m_busy = true;
        super.print(container, format);
        this.m_busy = false;
    }

    public synchronized void println() {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.println();
        }
        this.m_busy = true;
        super.println();
        this.m_busy = false;
    }

    public void println(CmsMessageContainer container) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.println(container);
        }
        this.m_busy = true;
        super.println(container);
        this.m_busy = false;
    }

    public void println(CmsMessageContainer container, int format) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.println(container, format);
        }
        this.m_busy = true;
        super.println(container, format);
        this.m_busy = false;
    }

    public synchronized void println(Throwable t) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.println(t);
        }
        this.m_busy = true;
        super.println(t);
        this.m_busy = false;
    }

    public void printMessageWithParam(CmsMessageContainer container, Object param) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.printMessageWithParam(container, param);
        }
        this.m_busy = true;
        super.printMessageWithParam(container, param);
        this.m_busy = false;
    }

    public void printMessageWithParam(int m, int n, CmsMessageContainer container, Object param) {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.printMessageWithParam(m, n, container, param);
        }
        this.m_busy = true;
        super.printMessageWithParam(m, n, container, param);
        this.m_busy = false;
    }

    public void resetRuntime() {
        if (!this.m_busy && this.m_report != null) {
            this.m_report.resetRuntime();
        }
        this.m_busy = true;
        super.resetRuntime();
        this.m_busy = false;
    }
}

