/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishException;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.Messages;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;

final class CmsPublishThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsPublishThread.class);
    private boolean m_abort;
    private final CmsPublishEngine m_publishEngine;
    private CmsPublishJobInfoBean m_publishJob;
    private I_CmsReport m_report;
    private boolean m_started;
    private final boolean m_updateSessionInfo;

    protected CmsPublishThread(CmsPublishEngine publishEngine, CmsPublishJobInfoBean publishJob) {
        super(publishJob.getCmsObject(), Messages.get().getBundle().key("GUI_PUBLISH_TRHEAD_NAME_0"));
        this.m_publishJob = publishJob;
        this.m_publishEngine = publishEngine;
        this.m_updateSessionInfo = this.getCms().getRequestContext().currentProject().getType() == CmsProject.PROJECT_TYPE_TEMPORARY;
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public boolean isAborted() {
        return this.m_abort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block21: {
                this.m_publishJob.start(this.getUUID());
                this.m_report = this.m_publishJob.getPublishReport();
                this.m_publishEngine.publishJobStarted(this.m_publishJob);
                this.m_started = true;
                if (!this.isAborted()) break block21;
                var6_1 = null;
                ** GOTO lbl70
            }
            this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_BEGIN_0"), 2);
            dbc = this.m_publishEngine.getDbContextFactory().getDbContext(this.getCms().getRequestContext());
            try {
                try {
                    this.m_publishEngine.getDriverManager().publishJob(this.getCms(), dbc, this.m_publishJob.getPublishList(), this.m_report);
                }
                catch (Throwable e) {
                    this.m_report.println(e);
                    CmsPublishThread.LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_PROJECT_FAILED_0"), e);
                    var4_16 = null;
                    dbc.clear();
                    dbc = null;
                    if (this.m_updateSessionInfo) {
                        OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                    }
                    this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
                    ** GOTO lbl79
                }
                var4_15 = null;
                dbc.clear();
                dbc = null;
                if (this.m_updateSessionInfo) {
                    OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                }
                this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
                ** GOTO lbl79
            }
            catch (Throwable var3_19) {
                var4_17 = null;
                dbc.clear();
                dbc = null;
                if (this.m_updateSessionInfo) {
                    OpenCms.getSessionManager().updateSessionInfos(this.getCms());
                }
                this.m_report.println(Messages.get().container("RPT_PUBLISH_RESOURCE_END_0"), 2);
                throw var3_19;
            }
        }
        catch (Throwable e) {
            CmsPublishThread.LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISH_PROJECT_FAILED_0"), e);
            var6_3 = null;
            try {
                this.m_publishEngine.publishJobFinished(this.getPublishJob());
                return;
            }
            catch (CmsException exc) {
                CmsPublishThread.LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                return;
            }
            catch (Throwable e) {
                CmsPublishThread.LOG.error((Object)e.getMessage(), e);
                return;
            }
        }
        {
            catch (Throwable var5_20) {
                var6_4 = null;
                ** try [egrp 4[TRYBLOCK] [10, 11 : 258->272)] { 
lbl62:
                // 1 sources

                this.m_publishEngine.publishJobFinished(this.getPublishJob());
                throw var5_20;
lbl64:
                // 1 sources

                catch (CmsException exc) {
                    CmsPublishThread.LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                    throw var5_20;
                }
lbl67:
                // 1 sources

                catch (Throwable e) {
                    CmsPublishThread.LOG.error((Object)e.getMessage(), e);
                }
                throw var5_20;
            }
lbl70:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [10, 11 : 258->272)] { 
lbl71:
            // 1 sources

            this.m_publishEngine.publishJobFinished(this.getPublishJob());
            return;
lbl73:
            // 1 sources

            catch (CmsException exc) {
                CmsPublishThread.LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                return;
            }
lbl76:
            // 1 sources

            catch (Throwable e) {
                CmsPublishThread.LOG.error((Object)e.getMessage(), e);
            }
            return;
lbl79:
            // 2 sources

            var6_2 = null;
            ** try [egrp 4[TRYBLOCK] [10, 11 : 258->272)] { 
lbl81:
            // 1 sources

            this.m_publishEngine.publishJobFinished(this.getPublishJob());
            return;
lbl83:
            // 1 sources

            catch (CmsException exc) {
                CmsPublishThread.LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
                return;
            }
lbl86:
            // 1 sources

            catch (Throwable e) {}
            CmsPublishThread.LOG.error((Object)e.getMessage(), e);
            return;
        }
    }

    protected void abort() throws CmsPublishException {
        if (this.m_started) {
            throw new CmsPublishException(Messages.get().container("ERR_PUBLISH_ENGINE_MISSING_PUBLISH_JOB_0"));
        }
        this.m_abort = true;
    }

    protected CmsPublishJobInfoBean getPublishJob() {
        return this.m_publishJob;
    }

    protected I_CmsReport getReport() {
        return this.m_report;
    }
}

