/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;

public final class CmsLinkUpdateUtil {
    private CmsLinkUpdateUtil() {
    }

    public static void updateType(Element element, CmsRelationType type) {
        CmsLinkUpdateUtil.updateAttribute(element, "type", type.getNameForXml());
    }

    public static void updateXml(CmsLink link, Element element, boolean updateOnly) {
        if (!(element == null || updateOnly && element.element("target") == null)) {
            String strId = link.getStructureId() == null ? null : link.getStructureId().toString();
            CmsLinkUpdateUtil.updateNode(element, "target", link.getTarget(), true);
            CmsLinkUpdateUtil.updateNode(element, "uuid", strId, false);
            CmsLinkUpdateUtil.updateNode(element, "anchor", link.getAnchor(), true);
            CmsLinkUpdateUtil.updateNode(element, "query", link.getQuery(), true);
        }
    }

    public static void updateXmlForHtmlValue(CmsLink link, String name, Element element) {
        if (element != null) {
            if (name != null) {
                CmsLinkUpdateUtil.updateAttribute(element, "name", link.getName());
            }
            CmsLinkUpdateUtil.updateAttribute(element, "internal", Boolean.toString(link.isInternal()));
            CmsLinkUpdateUtil.updateXmlForVfsFile(link, element);
        }
    }

    public static void updateXmlForVfsFile(CmsLink link, Element element) {
        if (element != null) {
            CmsLinkUpdateUtil.updateAttribute(element, "type", link.getType().getNameForXml());
            CmsLinkUpdateUtil.updateXml(link, element, false);
        }
    }

    private static void updateAttribute(Element parent, String attrName, String value) {
        if (parent != null) {
            Attribute attribute = parent.attribute(attrName);
            if (value != null) {
                if (attribute == null) {
                    parent.addAttribute(attrName, value);
                } else {
                    attribute.setValue(value);
                }
            } else if (attribute != null) {
                parent.remove(attribute);
            }
        }
    }

    private static void updateNode(Element parent, String nodeName, String value, boolean cdata) {
        Element nodeElement = parent.element(nodeName);
        if (value != null) {
            if (nodeElement == null) {
                nodeElement = parent.addElement(nodeName);
            }
            if (nodeElement != null) {
                nodeElement.clearContent();
                if (cdata) {
                    nodeElement.addCDATA(value);
                } else {
                    nodeElement.addText(value);
                }
            }
        } else if (nodeElement != null) {
            parent.remove(nodeElement);
        }
    }
}

