/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.relations.Messages;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.commons.CmsProgressThread;

public class CmsRelationSystemValidator {
    private static final Log LOG = CmsLog.getLog(CmsRelationSystemValidator.class);
    protected CmsDriverManager m_driverManager;

    public CmsRelationSystemValidator(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public Map validateResources(CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) {
        int count;
        boolean interProject;
        CmsProgressThread thread = null;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)Thread.currentThread();
        }
        HashMap<String, List> invalidResources = new HashMap<String, List>();
        boolean bl = interProject = publishList != null;
        if (report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_BEGIN_0"), 2);
        }
        ArrayList resources = new ArrayList();
        if (publishList == null) {
            CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
            List resTypes = OpenCms.getResourceManager().getResourceTypes();
            Iterator itTypes = resTypes.iterator();
            count = 0;
            while (itTypes.hasNext()) {
                I_CmsResourceType type;
                ++count;
                if (thread != null) {
                    if (thread.isInterrupted()) {
                        throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                    }
                    thread.setProgress(count * 10 / resTypes.size());
                }
                if (!((type = (I_CmsResourceType)itTypes.next()) instanceof I_CmsLinkParseable)) continue;
                filter = filter.addRequireType(type.getTypeId());
                try {
                    resources.addAll(this.m_driverManager.readResources(dbc, this.m_driverManager.readResource(dbc, "/", filter), filter, true));
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_RETRIEVAL_RESOURCES_1", type.getTypeName()), (Throwable)e);
                }
            }
        } else {
            resources.addAll(publishList.getAllResources());
        }
        HashMap<String, CmsResource> offlineFilesLookup = new HashMap<String, CmsResource>();
        ArrayList<CmsResource> validatableResources = new ArrayList<CmsResource>();
        Iterator itResources = resources.iterator();
        count = 0;
        while (itResources.hasNext()) {
            ++count;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(count * 10 / resources.size() + 10);
            }
            CmsResource resource = (CmsResource)itResources.next();
            offlineFilesLookup.put(resource.getRootPath(), resource);
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
                if (!(resourceType instanceof I_CmsLinkParseable)) continue;
                validatableResources.add(resource);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_RETRIEVAL_RESOURCETYPE_1", resource.getRootPath()), (Throwable)e);
            }
        }
        CmsProject project = dbc.currentProject();
        if (interProject) {
            try {
                project = this.m_driverManager.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        boolean foundBrokenLinks = false;
        int size = validatableResources.size();
        for (int index = 0; index < size; ++index) {
            List brokenLinks;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(index * 20 / resources.size() + 20);
            }
            CmsResource resource = (CmsResource)validatableResources.get(index);
            String resourceName = resource.getRootPath();
            if (report != null) {
                report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", new Integer(index + 1), new Integer(size)), 3);
                report.print(Messages.get().container("RPT_HTMLLINK_VALIDATING_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(resourceName)));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            }
            if ((brokenLinks = this.validateLinks(dbc, resource, offlineFilesLookup, project, report)).size() > 0) {
                invalidResources.put(resourceName, brokenLinks);
                foundBrokenLinks = true;
                continue;
            }
            if (report == null) continue;
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        if (foundBrokenLinks && report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_ERROR_0"), 5);
        }
        if (report != null) {
            report.println(Messages.get().container("RPT_HTMLLINK_VALIDATOR_END_0"), 2);
        }
        return invalidResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List validateLinks(CmsDbContext dbc, CmsResource resource, Map fileLookup, CmsProject project, I_CmsReport report) {
        List relations;
        HashMap<String, Boolean> validatedLinks;
        ArrayList<CmsRelation> brokenRelations;
        block33: {
            brokenRelations = new ArrayList<CmsRelation>();
            validatedLinks = new HashMap<String, Boolean>();
            relations = null;
            try {
                if (!resource.getState().isDeleted()) {
                    relations = this.m_driverManager.getRelationsForResource(dbc, resource, CmsRelationFilter.TARGETS);
                    break block33;
                }
                CmsProject currentProject = dbc.currentProject();
                dbc.getRequestContext().setCurrentProject(project);
                try {
                    relations = this.m_driverManager.getRelationsForResource(dbc, resource, CmsRelationFilter.SOURCES);
                }
                finally {
                    dbc.getRequestContext().setCurrentProject(currentProject);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_LINK_SEARCH_1", resource), (Throwable)e);
                if (report != null) {
                    report.println(Messages.get().container("LOG_LINK_SEARCH_1", dbc.removeSiteRoot(resource.getRootPath())), 5);
                }
                return brokenRelations;
            }
        }
        boolean first = true;
        Iterator itRelations = relations.iterator();
        while (true) {
            boolean isValidLink;
            String link;
            CmsRelation relation;
            block35: {
                CmsResource offlineResource;
                Object var16_20;
                if (!itRelations.hasNext()) {
                    return brokenRelations;
                }
                relation = (CmsRelation)itRelations.next();
                link = !resource.getState().isDeleted() ? relation.getTargetPath() : relation.getSourcePath();
                isValidLink = true;
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(link)) continue;
                if (validatedLinks.keySet().contains(link)) {
                    if (!((Boolean)validatedLinks.get(link)).booleanValue()) continue;
                    brokenRelations.add(relation);
                    continue;
                }
                try {
                    block34: {
                        try {
                            CmsResource offlineResource2;
                            if (!resource.getState().isDeleted()) {
                                try {
                                    link = this.m_driverManager.getVfsDriver().readResource(new CmsDbContext(), project.getUuid(), relation.getTargetId(), true).getRootPath();
                                }
                                catch (CmsVfsResourceNotFoundException e) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_READBYID_FAILED_2", relation.getTargetId().toString(), project.getName()), (Throwable)e);
                                    }
                                    this.m_driverManager.getVfsDriver().readResource(new CmsDbContext(), project.getUuid(), relation.getTargetPath(), true);
                                }
                                break block34;
                            }
                            isValidLink = false;
                            if (!fileLookup.containsKey(link) || !(offlineResource2 = (CmsResource)fileLookup.get(link)).getState().isDeleted()) break block34;
                            isValidLink = true;
                        }
                        catch (CmsException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_READBYPATH_FAILED_2", relation.getTargetPath(), project.getName()), (Throwable)e);
                            }
                            if (!fileLookup.containsKey(link)) {
                                isValidLink = false;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_RESOURCENOTINLOOKUP_1", link));
                                }
                            }
                            var16_20 = null;
                            if (!resource.getState().isDeleted() && fileLookup.containsKey(link) && (offlineResource = (CmsResource)fileLookup.get(link)).getState().isDeleted()) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_RESOURCEDELETED_1", link));
                                }
                                isValidLink = false;
                            }
                            break block35;
                        }
                    }
                    var16_20 = null;
                    if (resource.getState().isDeleted() || !fileLookup.containsKey(link)) break block35;
                }
                catch (Throwable throwable) {
                    var16_20 = null;
                    if (!resource.getState().isDeleted() && fileLookup.containsKey(link) && (offlineResource = (CmsResource)fileLookup.get(link)).getState().isDeleted()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_RESOURCEDELETED_1", link));
                        }
                        isValidLink = false;
                    }
                    throw throwable;
                }
                offlineResource = (CmsResource)fileLookup.get(link);
                if (offlineResource.getState().isDeleted()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_LINK_VALIDATION_RESOURCEDELETED_1", link));
                    }
                    isValidLink = false;
                }
            }
            if (!isValidLink) {
                if (first) {
                    if (report != null) {
                        report.println(Messages.get().container("RPT_HTMLLINK_FOUND_BROKEN_LINKS_0"), 1);
                    }
                    first = false;
                }
                brokenRelations.add(relation);
                if (report != null) {
                    if (!resource.getState().isDeleted()) {
                        report.println(Messages.get().container("RPT_HTMLLINK_BROKEN_TARGET_2", relation.getSourcePath(), dbc.removeSiteRoot(link)), 1);
                    } else {
                        report.println(Messages.get().container("RPT_HTMLLINK_BROKEN_SOURCE_2", dbc.removeSiteRoot(link), relation.getTargetPath()), 1);
                    }
                }
            }
            validatedLinks.put(link, !isValidLink);
        }
    }
}

