/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.report.A_CmsReport;
import org.opencms.util.CmsStringUtil;

public class CmsHtmlReport
extends A_CmsReport {
    protected static final String LINEBREAK = "<br>";
    protected static final String LINEBREAK_TRADITIONAL = "<br>\\n";
    private List m_content;
    private int m_indexNext;
    private boolean m_showExceptionStackTrace;
    private boolean m_transient;
    private boolean m_writeHtml;

    public CmsHtmlReport(Locale locale, String siteRoot) {
        this(locale, siteRoot, false, false);
    }

    public CmsHtmlReport(Locale locale, String siteRoot, boolean writeHtml, boolean isTransient) {
        this.init(locale, siteRoot);
        this.m_content = new ArrayList(256);
        this.m_showExceptionStackTrace = true;
        this.m_writeHtml = writeHtml;
        this.m_transient = isTransient;
    }

    public synchronized String getReportUpdate() {
        StringBuffer result = new StringBuffer();
        int indexEnd = this.m_content.size();
        for (int i = this.m_indexNext; i < indexEnd; ++i) {
            int pos = this.m_transient ? 0 : i;
            Object obj = this.m_content.get(pos);
            if (obj instanceof String || obj instanceof StringBuffer) {
                result.append(obj);
            } else if (obj instanceof Throwable) {
                result.append(this.getExceptionElement((Throwable)obj));
            }
            if (!this.m_transient) continue;
            this.m_content.remove(this.m_indexNext);
        }
        this.m_indexNext = this.m_transient ? 0 : indexEnd;
        return result.toString();
    }

    public boolean isWriteHtml() {
        return this.m_writeHtml;
    }

    public synchronized void print(String value, int format) {
        StringBuffer buf = null;
        if (!this.m_writeHtml) {
            value = CmsStringUtil.escapeJavaScript(value);
            switch (format) {
                case 2: {
                    buf = new StringBuffer();
                    buf.append("aH('");
                    buf.append(value);
                    buf.append("'); ");
                    break;
                }
                case 1: {
                    buf = new StringBuffer();
                    buf.append("aW('");
                    buf.append(value);
                    buf.append("'); ");
                    this.addWarning(value);
                    break;
                }
                case 5: {
                    buf = new StringBuffer();
                    buf.append("aE('");
                    buf.append(value);
                    buf.append("'); ");
                    this.addError(value);
                    break;
                }
                case 3: {
                    buf = new StringBuffer();
                    buf.append("aN('");
                    buf.append(value);
                    buf.append("'); ");
                    break;
                }
                case 4: {
                    buf = new StringBuffer();
                    buf.append("aO('");
                    buf.append(value);
                    buf.append("'); ");
                    break;
                }
                default: {
                    buf = new StringBuffer();
                    buf.append("a('");
                    buf.append(value);
                    buf.append("'); ");
                }
            }
            if (value.trim().endsWith(this.getLineBreak())) {
                buf.append("aB(); ");
            }
            this.m_content.add(buf.toString());
        } else {
            switch (format) {
                case 2: {
                    buf = new StringBuffer();
                    buf.append("<span class='head'>");
                    buf.append(value);
                    buf.append("</span>");
                    break;
                }
                case 1: {
                    buf = new StringBuffer();
                    buf.append("<span class='warn'>");
                    buf.append(value);
                    buf.append("</span>");
                    this.addWarning(value);
                    break;
                }
                case 5: {
                    buf = new StringBuffer();
                    buf.append("<span class='err'>");
                    buf.append(value);
                    buf.append("</span>");
                    this.addError(value);
                    break;
                }
                case 3: {
                    buf = new StringBuffer();
                    buf.append("<span class='note'>");
                    buf.append(value);
                    buf.append("</span>");
                    break;
                }
                case 4: {
                    buf = new StringBuffer();
                    buf.append("<span class='ok'>");
                    buf.append(value);
                    buf.append("</span>");
                    break;
                }
                default: {
                    buf = new StringBuffer(value);
                }
            }
            if (value.trim().endsWith(this.getLineBreak())) {
                buf.append("\n");
            }
            this.m_content.add(buf.toString());
        }
    }

    public void println() {
        this.print(this.getLineBreak());
    }

    public synchronized void println(Throwable t) {
        this.addError(t.getMessage());
        this.m_content.add(t);
    }

    protected String getLineBreak() {
        return this.m_writeHtml ? LINEBREAK_TRADITIONAL : LINEBREAK;
    }

    private StringBuffer getExceptionElement(Throwable throwable) {
        StringBuffer buf = new StringBuffer(256);
        if (!this.m_writeHtml) {
            if (this.m_showExceptionStackTrace) {
                buf.append("aT('");
                buf.append(this.getMessages().key("RPT_EXCEPTION_0"));
                String exception = CmsEncoder.escapeXml(CmsException.getStackTraceAsString(throwable));
                StringBuffer excBuffer = new StringBuffer(exception.length() + 50);
                StringTokenizer tok = new StringTokenizer(exception, "\r\n");
                while (tok.hasMoreTokens()) {
                    excBuffer.append(tok.nextToken());
                    excBuffer.append(this.getLineBreak());
                }
                buf.append(CmsStringUtil.escapeJavaScript(excBuffer.toString()));
                buf.append("'); ");
            } else {
                buf.append("aT('");
                buf.append(this.getMessages().key("RPT_EXCEPTION_0"));
                buf.append(CmsStringUtil.escapeJavaScript(throwable.toString()));
                buf.append("'); ");
            }
            this.m_content.add(buf);
        } else if (this.m_showExceptionStackTrace) {
            buf.append("<span class='throw'>");
            buf.append(this.getMessages().key("RPT_EXCEPTION_0"));
            String exception = CmsEncoder.escapeXml(CmsException.getStackTraceAsString(throwable));
            StringBuffer excBuffer = new StringBuffer(exception.length() + 50);
            StringTokenizer tok = new StringTokenizer(exception, "\r\n");
            while (tok.hasMoreTokens()) {
                excBuffer.append(tok.nextToken());
                excBuffer.append(this.getLineBreak());
            }
            buf.append(excBuffer.toString());
            buf.append("</span>");
        } else {
            buf.append("<span class='throw'>");
            buf.append(this.getMessages().key("RPT_EXCEPTION_0"));
            buf.append(throwable.toString());
            buf.append("</span>");
            buf.append(this.getLineBreak());
        }
        return buf;
    }
}

