/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.main.CmsLog;
import org.opencms.repository.A_CmsRepository;
import org.opencms.repository.I_CmsRepository;
import org.opencms.repository.Messages;

public class CmsRepositoryManager {
    private boolean m_configured;
    private boolean m_frozen;
    private List m_repositoryList;
    private Map m_repositoryMap;

    public CmsRepositoryManager() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTING_REPOSITORY_CONFIG_0"));
        }
        this.m_repositoryList = new ArrayList();
        this.m_repositoryMap = new HashMap();
        this.m_frozen = false;
        this.m_configured = true;
    }

    public CmsRepositoryManager(boolean configured) {
        this();
        this.m_configured = configured;
        this.m_repositoryList = Collections.unmodifiableList(this.m_repositoryList);
        this.m_frozen = true;
    }

    public void addRepositoryClass(I_CmsRepository rep) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        this.m_repositoryList.add(rep);
    }

    public List getRepositories() {
        return this.m_repositoryList;
    }

    public I_CmsRepository getRepository(String name) {
        return (I_CmsRepository)this.m_repositoryMap.get(name);
    }

    public void initConfiguration() throws CmsConfigurationException {
        this.m_repositoryList = Collections.unmodifiableList(this.m_repositoryList);
        Iterator iter = this.m_repositoryList.iterator();
        while (iter.hasNext()) {
            A_CmsRepository rep = (A_CmsRepository)iter.next();
            this.m_repositoryMap.put(rep.getName(), rep);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_REPOSITORY_2", rep.getClass().getName(), rep.getName()));
            }
            rep.initConfiguration();
        }
        this.m_frozen = true;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REPOSITORY_CONFIG_FINISHED_0"));
        }
    }

    public boolean isConfigured() {
        return this.m_configured;
    }
}

