/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.repository.A_CmsRepositorySession;
import org.opencms.repository.CmsRepositoryFilter;
import org.opencms.repository.CmsRepositoryItem;
import org.opencms.repository.CmsRepositoryLockInfo;
import org.opencms.repository.I_CmsRepositoryItem;
import org.opencms.repository.Messages;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;

public class CmsRepositorySession
extends A_CmsRepositorySession {
    private static final Log LOG = CmsLog.getLog(CmsRepositorySession.class);
    private final CmsObjectWrapper m_cms;

    public CmsRepositorySession(CmsObjectWrapper cms, CmsRepositoryFilter filter) {
        this.m_cms = cms;
        this.setFilter(filter);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copy(String src, String dest, boolean overwrite) throws CmsException {
        block8: {
            src = this.validatePath(src);
            dest = this.validatePath(dest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COPY_ITEM_2", src, dest));
            }
            if (this.exists(dest)) {
                if (overwrite) {
                    CmsResource srcRes = this.m_cms.readResource(src, CmsResourceFilter.DEFAULT);
                    CmsResource destRes = this.m_cms.readResource(dest, CmsResourceFilter.DEFAULT);
                    if (srcRes.isFile() && destRes.isFile()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_DEST_0"));
                        }
                        this.delete(dest);
                        break block8;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("ERR_OVERWRITE_0"));
                        }
                        throw new CmsException(Messages.get().container("ERR_OVERWRITE_0"));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
        }
        this.m_cms.copyResource(src, dest, CmsResource.COPY_PRESERVE_SIBLING);
        this.m_cms.unlockResource(dest);
    }

    public void create(String path) throws CmsException {
        CmsResource res;
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_ITEM_1", path));
        }
        if (!this.m_cms.getLock(res = this.m_cms.createResource(path, 0)).isInherited()) {
            this.m_cms.unlockResource(path);
        }
    }

    public void delete(String path) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_ITEM_1", path));
        }
        CmsRepositoryLockInfo lock = this.getLock(path);
        this.m_cms.lockResource(path);
        this.m_cms.deleteResource(path, CmsResource.DELETE_PRESERVE_SIBLINGS);
        try {
            if (lock == null) {
                this.m_cms.unlockResource(path);
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public boolean exists(String path) {
        try {
            path = this.validatePath(path);
            return this.m_cms.existsResource(path);
        }
        catch (CmsException ex) {
            return false;
        }
    }

    public I_CmsRepositoryItem getItem(String path) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_ITEM_1", path));
        }
        CmsResource res = this.m_cms.readResource(path, CmsResourceFilter.DEFAULT);
        CmsRepositoryItem item = new CmsRepositoryItem(res, this.m_cms);
        return item;
    }

    public CmsRepositoryLockInfo getLock(String path) {
        try {
            CmsRepositoryLockInfo lockInfo = new CmsRepositoryLockInfo();
            path = this.validatePath(path);
            CmsResource res = this.m_cms.readResource(path, CmsResourceFilter.DEFAULT);
            CmsLock cmsLock = this.m_cms.getLock(res);
            if (!cmsLock.isUnlocked()) {
                lockInfo.setPath(path);
                CmsUser owner = this.m_cms.readUser(cmsLock.getUserId());
                if (owner != null) {
                    lockInfo.setUsername(owner.getName());
                    lockInfo.setOwner(owner.getName() + "||" + owner.getEmail());
                }
                return lockInfo;
            }
            return null;
        }
        catch (CmsException ex) {
            return null;
        }
    }

    public List list(String path) throws CmsException {
        ArrayList<CmsRepositoryItem> ret = new ArrayList<CmsRepositoryItem>();
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_1", path));
        }
        List resources = this.m_cms.getResourcesInFolder(path, CmsResourceFilter.DEFAULT);
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            CmsResource res = (CmsResource)iter.next();
            if (this.isFiltered(this.m_cms.getRequestContext().removeSiteRoot(res.getRootPath()))) continue;
            CmsResource org = this.m_cms.readResource(res.getStructureId(), CmsResourceFilter.DEFAULT);
            if (this.isFiltered(this.m_cms.getRequestContext().removeSiteRoot(org.getRootPath()))) continue;
            ret.add(new CmsRepositoryItem(res, this.m_cms));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LIST_ITEMS_SUCESS_1", new Integer(ret.size())));
        }
        return ret;
    }

    public boolean lock(String path, CmsRepositoryLockInfo lock) throws CmsException {
        path = this.validatePath(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LOCK_ITEM_1", path));
        }
        this.m_cms.lockResource(path);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void move(String src, String dest, boolean overwrite) throws CmsException {
        block8: {
            src = this.validatePath(src);
            dest = this.validatePath(dest);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MOVE_ITEM_2", src, dest));
            }
            if (this.exists(dest)) {
                if (overwrite) {
                    CmsResource srcRes = this.m_cms.readResource(src, CmsResourceFilter.DEFAULT);
                    CmsResource destRes = this.m_cms.readResource(dest, CmsResourceFilter.DEFAULT);
                    if (srcRes.isFile() && destRes.isFile()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_DELETE_DEST_0"));
                        }
                        this.delete(dest);
                        break block8;
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("ERR_OVERWRITE_0"));
                        }
                        throw new CmsException(Messages.get().container("ERR_OVERWRITE_0"));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
        }
        this.m_cms.lockResource(src);
        this.m_cms.moveResource(src, dest);
        this.m_cms.unlockResource(dest);
    }

    public void save(String path, InputStream inputStream, boolean overwrite) throws CmsException, IOException {
        block8: {
            path = this.validatePath(path);
            byte[] content = CmsFileUtil.readFully(inputStream);
            try {
                CmsFile file = this.m_cms.readFile(path, CmsResourceFilter.DEFAULT);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_ITEM_1", path));
                }
                if (overwrite) {
                    file.setContents(content);
                    CmsLock lock = this.m_cms.getLock(file);
                    if (!lock.isInherited()) {
                        this.m_cms.lockResource(path);
                    }
                    this.m_cms.writeFile(file);
                    if (lock.isNullLock()) {
                        this.m_cms.unlockResource(path);
                    }
                    break block8;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("ERR_DEST_EXISTS_0"));
                }
                throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_DEST_EXISTS_0"));
            }
            catch (CmsVfsResourceNotFoundException ex) {
                int type;
                CmsResource res;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_CREATE_ITEM_1", path));
                }
                if (this.m_cms.getLock(res = this.m_cms.createResource(path, type = OpenCms.getResourceManager().getDefaultTypeForName(path).getTypeId(), content, null)).isInherited()) break block8;
                this.m_cms.unlockResource(path);
            }
        }
    }

    public void unlock(String path) {
        block3: {
            try {
                path = this.validatePath(path);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_UNLOCK_ITEM_1", path));
                }
                this.m_cms.unlockResource(path);
            }
            catch (CmsException ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)Messages.get().getBundle().key("ERR_UNLOCK_FAILED_0"), (Throwable)ex);
            }
        }
    }

    protected boolean isFiltered(String name) {
        boolean ret = super.isFiltered(this.m_cms.getRequestContext().addSiteRoot(name));
        if (ret && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("ERR_ITEM_FILTERED_1", name));
        }
        return ret;
    }

    private String validatePath(String path) throws CmsSecurityException {
        String ret = this.m_cms.getRequestContext().getFileTranslator().translateResource(path);
        if ("/system".equals(ret)) {
            ret = ret.concat("/");
        }
        if (this.isFiltered(ret)) {
            throw new CmsSecurityException(Messages.get().container("ERR_ITEM_FILTERED_1", path));
        }
        return ret;
    }
}

