/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.loader.CmsImageLoader;
import org.opencms.loader.CmsImageScaler;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.report.CmsLogReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.jobs.Messages;

public class CmsCreateImageSizeJob
implements I_CmsScheduledJob {
    public static final String PARAM_DOWNSCALE = "downscale";

    public String launch(CmsObject cms, Map parameters) throws Exception {
        if (!CmsImageLoader.isEnabled()) {
            return Messages.get().getBundle().key("LOG_IMAGE_SCALING_DISABLED_0");
        }
        boolean downscale = Boolean.valueOf((String)parameters.get(PARAM_DOWNSCALE));
        CmsLogReport report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsCreateImageSizeJob.class);
        report.println(Messages.get().container("RPT_IMAGE_SIZE_START_0"), 2);
        List resources = Collections.EMPTY_LIST;
        try {
            resources = cms.readResources("/", CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(CmsResourceTypeImage.getStaticTypeId()));
        }
        catch (CmsException e) {
            report.println(e);
        }
        int count = 0;
        for (int i = 0; i < resources.size(); ++i) {
            try {
                CmsResource res = (CmsResource)resources.get(i);
                report.print(Messages.get().container("RPT_IMAGE_SIZE_PROCESS_3", String.valueOf(i + 1), String.valueOf(resources.size()), res.getRootPath()), 2);
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                CmsLock lock = cms.getLock(res);
                if (lock.isNullLock() || lock.isOwnedBy(cms.getRequestContext().currentUser())) {
                    CmsFile file = cms.readFile(res);
                    CmsImageScaler scaler = new CmsImageScaler(file.getContents(), file.getRootPath());
                    if (scaler.isValid()) {
                        boolean updated = false;
                        CmsImageScaler downScaler = null;
                        if (downscale) {
                            downScaler = CmsResourceTypeImage.getDownScaler(cms, res.getRootPath());
                        }
                        if (scaler.isDownScaleRequired(downScaler)) {
                            this.lockResource(cms, lock, res);
                            cms.writeFile(file);
                            scaler = scaler.getDownScaler(downScaler);
                            updated = true;
                        } else {
                            CmsProperty prop = cms.readPropertyObject(res, "image.size", false);
                            if (prop.isNullProperty() || !prop.getValue().equals(scaler.toString())) {
                                this.lockResource(cms, lock, res);
                                if (prop.isNullProperty()) {
                                    prop = new CmsProperty("image.size", null, scaler.toString());
                                } else {
                                    prop.setStructureValue("");
                                    prop.setResourceValue(scaler.toString());
                                }
                                cms.writePropertyObject(res.getRootPath(), prop);
                                updated = true;
                            }
                        }
                        if (updated) {
                            this.unlockResource(cms, lock, res);
                            ++count;
                            report.println(Messages.get().container("RPT_IMAGE_SIZE_UPDATE_1", scaler.toString()), 0);
                            continue;
                        }
                        report.println(Messages.get().container("RPT_IMAGE_SIZE_SKIP_1", scaler.toString()), 0);
                        continue;
                    }
                    report.println(Messages.get().container("RPT_IMAGE_SIZE_UNABLE_TO_CALCULATE_0"), 0);
                    continue;
                }
                report.println(Messages.get().container("RPT_IMAGE_SIZE_LOCKED_0"), 0);
                continue;
            }
            catch (CmsException e) {
                report.println(e);
            }
        }
        report.println(Messages.get().container("RPT_IMAGE_SIZE_END_0"), 2);
        return Messages.get().getBundle().key("LOG_IMAGE_SIZE_UPDATE_COUNT_1", new Integer(count));
    }

    private void lockResource(CmsObject cms, CmsLock lock, CmsResource res) throws CmsException {
        if (lock.isNullLock()) {
            cms.lockResource(res.getRootPath());
        }
    }

    private void unlockResource(CmsObject cms, CmsLock lock, CmsResource res) throws CmsException {
        if (lock.isNullLock()) {
            cms.unlockResource(res.getRootPath());
        }
    }
}

