/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.GregorianCalendar;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.report.CmsLogReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.util.CmsStringUtil;

public class CmsHistoryClearJob
implements I_CmsScheduledJob {
    public static final String PARAM_KEEPVERSIONS = "keepVersions";
    public static final String PARAM_CLEARDELETED = "clearDeleted";
    public static final String PARAM_KEEPTIMERANGE = "keepTimeRange";

    public String launch(CmsObject cms, Map parameters) throws Exception {
        int keepVersions = Integer.parseInt((String)parameters.get(PARAM_KEEPVERSIONS));
        boolean clearDeleted = Boolean.valueOf((String)parameters.get(PARAM_CLEARDELETED));
        String keepTimeRangeStr = (String)parameters.get(PARAM_KEEPTIMERANGE);
        int keepTimeRange = -1;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(keepTimeRangeStr)) {
            keepTimeRange = Integer.parseInt(keepTimeRangeStr);
        }
        long timeDeleted = -1L;
        if (clearDeleted) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(6, keepTimeRange * -1);
            timeDeleted = cal.getTimeInMillis();
        }
        int keepDeletedVersions = keepVersions;
        if (!clearDeleted) {
            keepDeletedVersions = -1;
        }
        CmsLogReport report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsHistoryClearJob.class);
        cms.deleteHistoricalVersions(cms.getRequestContext().getUri(), keepVersions, keepDeletedVersions, timeDeleted, report);
        return null;
    }
}

