/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexWriter;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexingThread;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;

public class CmsIndexingThreadManager {
    private static final Log LOG = CmsLog.getLog(CmsIndexingThreadManager.class);
    private int m_abandonedCounter;
    private long m_lastLogErrorTime;
    private long m_lastLogWarnTime;
    private int m_returnedCounter;
    private int m_startedCounter;
    private long m_timeout;

    public CmsIndexingThreadManager(long timeout) {
        this.m_timeout = timeout;
    }

    public void createIndexingThread(CmsObject cms, IndexWriter writer, CmsResource res, CmsSearchIndex index, I_CmsReport report) {
        boolean excludeFromIndex;
        block13: {
            excludeFromIndex = false;
            try {
                excludeFromIndex = Boolean.valueOf(cms.readPropertyObject(res, "search.exclude", true).getValue());
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_PROPERTY_1", res.getRootPath()));
            }
        }
        if (!excludeFromIndex) {
            List locales = OpenCms.getLocaleManager().getDefaultLocales(cms, res);
            Locale match = OpenCms.getLocaleManager().getFirstMatchingLocale(Collections.singletonList(index.getLocale()), locales);
            excludeFromIndex = match == null;
        }
        I_CmsDocumentFactory documentType = null;
        if (!excludeFromIndex) {
            documentType = index.getDocumentFactory(res);
        }
        if (documentType == null) {
            ++this.m_startedCounter;
            ++this.m_returnedCounter;
            if (report != null) {
                report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 3);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SKIPPED_1", res.getRootPath()));
            }
            return;
        }
        CmsIndexingThread thread = new CmsIndexingThread(cms, writer, res, documentType, index, report);
        ++this.m_startedCounter;
        thread.start();
        try {
            thread.join(this.m_timeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (thread.isAlive()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_INDEXING_TIMEOUT_1", res.getRootPath()));
            }
            if (report != null) {
                report.println();
                report.print(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 1);
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_TIMEOUT_1", res.getRootPath()), 1);
            }
            ++this.m_abandonedCounter;
            thread.interrupt();
        } else {
            ++this.m_returnedCounter;
        }
    }

    public int getCounter() {
        return this.m_startedCounter;
    }

    public boolean isRunning() {
        boolean result;
        if (this.m_lastLogErrorTime <= 0L) {
            this.m_lastLogWarnTime = this.m_lastLogErrorTime = System.currentTimeMillis();
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.m_lastLogWarnTime > 30000L) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_WAITING_ABANDONED_THREADS_2", new Integer(this.m_abandonedCounter), new Integer(this.m_startedCounter - this.m_returnedCounter)));
                }
                this.m_lastLogWarnTime = currentTime;
            }
            if (currentTime - this.m_lastLogErrorTime > 600000L) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WAITING_ABANDONED_THREADS_2", new Integer(this.m_abandonedCounter), new Integer(this.m_startedCounter - this.m_returnedCounter)));
                this.m_lastLogErrorTime = currentTime;
            }
        }
        boolean bl = result = this.m_returnedCounter + this.m_abandonedCounter < this.m_startedCounter;
        if (result && LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_THREADS_FINISHED_0"));
        }
        return result;
    }

    public void reportStatistics(I_CmsReport report) {
        if (report != null) {
            CmsMessageContainer message = Messages.get().container("RPT_SEARCH_INDEXING_STATS_4", new Object[]{new Integer(this.m_startedCounter), new Integer(this.m_returnedCounter), new Integer(this.m_abandonedCounter), report.formatRuntime()});
            report.println(message);
            if (!(report instanceof CmsLogReport) && LOG.isInfoEnabled()) {
                LOG.info((Object)message.key());
            }
        }
    }

    public void run() {
        int max = 20;
        try {
            Thread.sleep(30000L);
            while (this.m_startedCounter > this.m_returnedCounter && max-- > 0) {
                Thread.sleep(30000L);
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_WAITING_ABANDONED_THREADS_2", new Integer(this.m_abandonedCounter), new Integer(this.m_startedCounter - this.m_returnedCounter)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (max > 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_THREADS_FINISHED_0"));
            }
        } else {
            LOG.error((Object)Messages.get().getBundle().key("LOG_THREADS_FINISHED_0", new Integer(this.m_startedCounter - this.m_returnedCounter)));
        }
    }
}

