/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.opencms.main.CmsLog;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearchCategoryCollector
extends HitCollector {
    public static final String UNKNOWN_CATEGORY = "unknown";
    private static final Log LOG = CmsLog.getLog(CmsSearchCategoryCollector.class);
    private Map m_categories;
    private IndexSearcher m_searcher;

    public CmsSearchCategoryCollector(IndexSearcher searcher) {
        this.m_searcher = searcher;
        this.m_categories = new HashMap();
    }

    public static final String formatCategoryMap(Map categories) {
        StringBuffer result = new StringBuffer(256);
        result.append("Total categories: ");
        result.append(categories.size());
        result.append('\n');
        Iterator i = categories.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String category = (String)entry.getKey();
            Integer count = (Integer)entry.getValue();
            result.append(CmsStringUtil.padRight(category, 30));
            result.append(count);
            result.append('\n');
        }
        return result.toString();
    }

    public void collect(int id, float score) {
        CmsCategroyCount count;
        String category;
        block5: {
            category = null;
            try {
                Document doc = this.m_searcher.doc(id);
                category = doc.get("category");
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_CATEGORY_FAILED_1", new Integer(id)), (Throwable)e);
            }
        }
        if (category == null) {
            category = UNKNOWN_CATEGORY;
        }
        if ((count = (CmsCategroyCount)this.m_categories.get(category)) != null) {
            count.inc();
        } else {
            count = new CmsCategroyCount();
            this.m_categories.put(category, count);
        }
    }

    public Map getCategoryCountResult() {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Iterator i = this.m_categories.keySet().iterator();
        while (i.hasNext()) {
            String category = (String)i.next();
            CmsCategroyCount count = (CmsCategroyCount)this.m_categories.get(category);
            result.put(category, count.toInteger());
        }
        return result;
    }

    public String toString() {
        return CmsSearchCategoryCollector.formatCategoryMap(this.getCategoryCountResult());
    }

    private static class CmsCategroyCount {
        int m_count = 1;

        CmsCategroyCount() {
        }

        int getCount() {
            return this.m_count;
        }

        void inc() {
            ++this.m_count;
        }

        Integer toInteger() {
            return new Integer(this.m_count);
        }
    }
}

