/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearchIndexSource
implements Comparable {
    private static final Log LOG = CmsLog.getLog(CmsSearchIndexSource.class);
    private List m_documentTypes;
    private I_CmsIndexer m_indexer;
    private String m_indexerClassName;
    private String m_name;
    private Map m_params = new HashMap();
    private List m_resourcesNames = new ArrayList();

    public CmsSearchIndexSource() {
        this.m_documentTypes = new ArrayList();
    }

    public void addConfigurationParameter(String key, String value) {
        this.m_params.put(key, value);
    }

    public void addDocumentType(String key) {
        this.m_documentTypes.add(key);
    }

    public void addResourceName(String resourceName) {
        this.m_resourcesNames.add(resourceName);
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsSearchIndexSource) {
            return this.getName().compareTo(((CmsSearchIndexSource)obj).getName());
        }
        return -1;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public List getDocumentTypes() {
        return this.m_documentTypes;
    }

    public I_CmsIndexer getIndexer() {
        return this.m_indexer;
    }

    public String getIndexerClassName() {
        return this.m_indexerClassName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParam(String key) {
        return (String)this.m_params.get(key);
    }

    public Map getParams() {
        return this.m_params;
    }

    public List getResourcesNames() {
        return this.m_resourcesNames;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public boolean isContaining(String rootPath) {
        if (rootPath != null && this.m_resourcesNames != null) {
            Iterator i = this.m_resourcesNames.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                if (!rootPath.startsWith(path)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIndexing(String rootPath, String documentType) {
        return this.m_documentTypes.contains(documentType) && this.isContaining(rootPath);
    }

    public boolean removeDocumentType(String key) {
        return this.m_documentTypes.remove(key);
    }

    public void setDocumentTypes(List documentTypes) {
        this.m_documentTypes = documentTypes;
    }

    public void setIndexerClassName(String indexerClassName) throws CmsIllegalArgumentException {
        try {
            this.m_indexer = (I_CmsIndexer)Class.forName(indexerClassName).newInstance();
            this.m_indexerClassName = indexerClassName;
        }
        catch (Exception exc) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_INDEXER_CREATION_FAILED_1", this.m_indexerClassName), (Throwable)exc);
            }
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INDEXSOURCE_INDEXER_CLASS_NAME_2", indexerClassName, I_CmsIndexer.class.getName()));
        }
    }

    public void setName(String name) throws CmsIllegalArgumentException {
        CmsSearchManager mngr;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INDEXSOURCE_CREATE_MISSING_NAME_0"));
        }
        if (OpenCms.getRunLevel() > 2 && (mngr = OpenCms.getSearchManager()).getIndexSource(name) != this && mngr.getSearchIndexSources().keySet().contains(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INDEXSOURCE_CREATE_INVALID_NAME_1", name));
        }
        this.m_name = name;
    }

    public void setParams(Map params) {
        this.m_params = params;
    }

    public void setResourcesNames(List resources) {
        this.m_resourcesNames = resources;
    }
}

