/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchAnalyzer;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.CmsSearchSimilarity;
import org.opencms.search.Messages;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.CmsExtractionResultCache;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSearchManager
implements I_CmsScheduledJob,
I_CmsEventListener {
    public static final int DEFAULT_EXCERPT_LENGTH = 1024;
    public static final float DEFAULT_EXTRACTION_CACHE_MAX_AGE = 672.0f;
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final String JOB_PARAM_INDEXLIST = "indexList";
    public static final String JOB_PARAM_WRITELOG = "writeLog";
    private static final Log LOG = CmsLog.getLog(CmsSearchManager.class);
    private CmsObject m_adminCms;
    private HashMap m_analyzers;
    private List m_documentTypeConfigs;
    private Map m_documentTypes = new HashMap();
    private float m_extractionCacheMaxAge = 672.0f;
    private CmsExtractionResultCache m_extractionResultCache;
    private Map m_fieldConfigurations;
    private CmsSearchForceUnlockMode m_forceUnlockMode;
    private I_CmsTermHighlighter m_highlighter;
    private List m_indexes;
    private int m_indexLockMaxWaitSeconds = 10;
    private Map m_indexSources;
    private int m_maxExcerptLength = 1024;
    private String m_path;
    private long m_timeout;

    public CmsSearchManager() {
        this.m_documentTypeConfigs = new ArrayList();
        this.m_analyzers = new HashMap();
        this.m_indexes = new ArrayList();
        this.m_indexSources = new TreeMap();
        this.m_fieldConfigurations = new HashMap();
        this.addFieldConfiguration(CmsSearchFieldConfiguration.DEFAULT_STANDARD);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SEARCH_CONFIG_0"));
        }
    }

    public void addAnalyzer(CmsSearchAnalyzer analyzer) {
        this.m_analyzers.put(analyzer.getLocale(), analyzer);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_ANALYZER_2", analyzer.getLocale(), analyzer.getClassName()));
        }
    }

    public void addDocumentTypeConfig(CmsSearchDocumentType documentType) {
        this.m_documentTypeConfigs.add(documentType);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_DOC_TYPES_2", documentType.getName(), documentType.getClassName()));
        }
    }

    public void addFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) {
        this.m_fieldConfigurations.put(fieldConfiguration.getName(), fieldConfiguration);
    }

    public void addSearchIndex(CmsSearchIndex searchIndex) {
        String name;
        if ((searchIndex.getSources() == null || searchIndex.getPath() == null) && OpenCms.getRunLevel() > 2) {
            try {
                searchIndex.initialize();
            }
            catch (CmsSearchException e) {
                // empty catch block
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name = searchIndex.getName())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_MISSING_NAME_0"));
        }
        if (this.m_indexSources.keySet().contains(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_SEARCHINDEX_CREATE_INVALID_NAME_1", name));
        }
        this.m_indexes.add(searchIndex);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void addSearchIndexSource(CmsSearchIndexSource searchIndexSource) {
        this.m_indexSources.put(searchIndexSource.getName(), searchIndexSource);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_INDEX_SOURCE_2", searchIndexSource.getName(), searchIndexSource.getIndexerClassName()));
        }
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 32: {
                List indexNames = null;
                if (event.getData() != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)event.getData().get("indexNames"))) {
                    indexNames = CmsStringUtil.splitAsList((String)event.getData().get("indexNames"), ",", true);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")));
                    }
                    if (indexNames == null) {
                        this.rebuildAllIndexes(this.getEventReport(event));
                        break;
                    }
                    this.rebuildIndexes(indexNames, this.getEventReport(event));
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break;
                    LOG.error((Object)Messages.get().getBundle().key("ERR_EVENT_REBUILD_SEARCHINDEX_1", indexNames == null ? "" : CmsStringUtil.collectionAsString(indexNames, ",")), (Throwable)e);
                }
                break;
            }
            case 5: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_CLEAR_CACHES_0"));
                break;
            }
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_1", publishHistoryId));
                }
                this.updateAllIndexes(this.m_adminCms, publishHistoryId, this.getEventReport(event));
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_FINISHED_1", publishHistoryId));
                break;
            }
        }
    }

    public Map getAnalyzers() {
        return Collections.unmodifiableMap(this.m_analyzers);
    }

    public CmsSearchAnalyzer getCmsSearchAnalyzer(Locale locale) {
        return (CmsSearchAnalyzer)this.m_analyzers.get(locale);
    }

    public String getDirectory() {
        return this.m_path;
    }

    public CmsSearchDocumentType getDocumentTypeConfig(String name) {
        for (int i = 0; i < this.m_documentTypeConfigs.size(); ++i) {
            CmsSearchDocumentType type = (CmsSearchDocumentType)this.m_documentTypeConfigs.get(i);
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public List getDocumentTypeConfigs() {
        return Collections.unmodifiableList(this.m_documentTypeConfigs);
    }

    public float getExtractionCacheMaxAge() {
        return this.m_extractionCacheMaxAge;
    }

    public CmsSearchFieldConfiguration getFieldConfiguration(String name) {
        return (CmsSearchFieldConfiguration)this.m_fieldConfigurations.get(name);
    }

    public List getFieldConfigurations() {
        ArrayList result = new ArrayList(this.m_fieldConfigurations.values());
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    public CmsSearchForceUnlockMode getForceunlock() {
        return this.m_forceUnlockMode;
    }

    public I_CmsTermHighlighter getHighlighter() {
        return this.m_highlighter;
    }

    public CmsSearchIndex getIndex(String indexName) {
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            CmsSearchIndex searchIndex = (CmsSearchIndex)this.m_indexes.get(i);
            if (!indexName.equalsIgnoreCase(searchIndex.getName())) continue;
            return searchIndex;
        }
        return null;
    }

    public int getIndexLockMaxWaitSeconds() {
        return this.m_indexLockMaxWaitSeconds;
    }

    public List getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>();
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            indexNames.add(((CmsSearchIndex)this.m_indexes.get(i)).getName());
        }
        return indexNames;
    }

    public CmsSearchIndexSource getIndexSource(String sourceName) {
        return (CmsSearchIndexSource)this.m_indexSources.get(sourceName);
    }

    public int getMaxExcerptLength() {
        return this.m_maxExcerptLength;
    }

    public List getSearchIndexes() {
        return Collections.unmodifiableList(this.m_indexes);
    }

    public Map getSearchIndexSources() {
        return Collections.unmodifiableMap(this.m_indexSources);
    }

    public long getTimeout() {
        return this.m_timeout;
    }

    public void initialize(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_MANAGER);
        try {
            this.m_adminCms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        this.m_adminCms.getRequestContext().setSiteRoot("/");
        this.m_extractionResultCache = new CmsExtractionResultCache(OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(this.getDirectory()), "/extractCache");
        this.initializeIndexes();
        Similarity.setDefault((Similarity)new CmsSearchSimilarity());
        OpenCms.addCmsEventListener(this, new int[]{5, 2, 32});
    }

    public void initializeIndexes() {
        this.initAvailableDocumentTypes();
        this.initSearchIndexes();
    }

    public String launch(CmsObject cms, Map parameters) throws Exception {
        CmsSearchManager manager = OpenCms.getSearchManager();
        CmsLogReport report = null;
        boolean writeLog = Boolean.valueOf((String)parameters.get(JOB_PARAM_WRITELOG));
        if (writeLog) {
            report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
        }
        ArrayList<String> updateList = null;
        String indexList = (String)parameters.get(JOB_PARAM_INDEXLIST);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(indexList)) {
            updateList = new ArrayList<String>();
            String[] indexNames = CmsStringUtil.splitAsArray(indexList, '|');
            for (int i = 0; i < indexNames.length; ++i) {
                if (manager.getIndex(indexNames[i]) != null) {
                    updateList.add(indexNames[i]);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexNames[i]));
            }
        }
        long startTime = System.currentTimeMillis();
        if (updateList == null) {
            manager.rebuildAllIndexes(report);
        } else {
            manager.rebuildIndexes(updateList, report);
        }
        long runTime = System.currentTimeMillis() - startTime;
        String finishMessage = Messages.get().getBundle().key("LOG_REBUILD_INDEXES_FINISHED_1", CmsStringUtil.formatRuntime(runTime));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)finishMessage);
        }
        return finishMessage;
    }

    public synchronized void rebuildAllIndexes(I_CmsReport report) throws CmsException {
        CmsMessageContainer container = null;
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            CmsSearchIndex searchIndex = (CmsSearchIndex)this.m_indexes.get(i);
            try {
                this.updateIndex(searchIndex, report, null);
                continue;
            }
            catch (CmsException e) {
                container = new CmsMessageContainer(Messages.get(), "ERR_INDEX_REBUILD_ALL_1", new Object[]{searchIndex.getName()});
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_REBUILD_ALL_1", searchIndex.getName()), (Throwable)e);
            }
        }
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
        if (container != null) {
            throw new CmsSearchException(container);
        }
    }

    public synchronized void rebuildIndex(String indexName, I_CmsReport report) throws CmsException {
        CmsSearchIndex index = this.getIndex(indexName);
        this.updateIndex(index, report, null);
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
    }

    public synchronized void rebuildIndexes(List indexNames, I_CmsReport report) throws CmsException {
        Iterator i = indexNames.iterator();
        while (i.hasNext()) {
            String indexName = (String)i.next();
            CmsSearchIndex index = this.getIndex(indexName);
            if (index != null) {
                this.updateIndex(index, report, null);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
        }
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
    }

    public boolean removeSearchFieldConfiguration(CmsSearchFieldConfiguration fieldConfiguration) throws CmsIllegalStateException {
        if (fieldConfiguration.getName().equals("standard")) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_STANDARD_1", fieldConfiguration.getName()));
        }
        Iterator itIndexes = this.m_indexes.iterator();
        LinkedList<CmsSearchIndex> referrers = new LinkedList<CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            CmsSearchIndex idx = (CmsSearchIndex)itIndexes.next();
            CmsSearchFieldConfiguration refFieldConfig = idx.getFieldConfiguration();
            if (!refFieldConfig.equals(fieldConfiguration)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_CONFIGURATION_DELETE_2", fieldConfiguration.getName(), ((Object)referrers).toString()));
        }
        return this.m_fieldConfigurations.remove(fieldConfiguration.getName()) != null;
    }

    public boolean removeSearchFieldConfigurationField(CmsSearchFieldConfiguration fieldConfiguration, CmsSearchField field) throws CmsIllegalStateException {
        if (fieldConfiguration.getFields().size() < 2) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_CONFIGURATION_FIELD_DELETE_2", field.getName(), fieldConfiguration.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELDCONFIGURATION_FIELD_INDEX_2", field.getName(), fieldConfiguration.getName()));
        }
        return fieldConfiguration.getFields().remove(field);
    }

    public boolean removeSearchFieldMapping(CmsSearchField field, CmsSearchFieldMapping mapping) throws CmsIllegalStateException {
        if (field.getMappings().size() < 2) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_FIELD_MAPPING_DELETE_2", mapping.getType().toString(), field.getName()));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_FIELD_MAPPING_INDEX_2", mapping.toString(), field.getName()));
        }
        return field.getMappings().remove(mapping);
    }

    public void removeSearchIndex(CmsSearchIndex searchIndex) {
        this.m_indexes.remove(searchIndex);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REMOVE_SEARCH_INDEX_2", searchIndex.getName(), searchIndex.getProject()));
        }
    }

    public void removeSearchIndexes(List indexNames) {
        Iterator i = indexNames.iterator();
        while (i.hasNext()) {
            String indexName = (String)i.next();
            CmsSearchIndex index = this.getIndex(indexName);
            if (index != null) {
                this.removeSearchIndex(index);
                continue;
            }
            if (!LOG.isWarnEnabled()) continue;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_NO_INDEX_WITH_NAME_1", indexName));
        }
    }

    public boolean removeSearchIndexSource(CmsSearchIndexSource indexsource) throws CmsIllegalStateException {
        Iterator itIndexes = this.m_indexes.iterator();
        LinkedList<CmsSearchIndex> referrers = new LinkedList<CmsSearchIndex>();
        while (itIndexes.hasNext()) {
            CmsSearchIndex idx = (CmsSearchIndex)itIndexes.next();
            List refsources = idx.getSources();
            if (refsources == null || !refsources.contains(indexsource)) continue;
            referrers.add(idx);
        }
        if (referrers.size() > 0) {
            throw new CmsIllegalStateException(Messages.get().container("ERR_INDEX_SOURCE_DELETE_2", indexsource.getName(), ((Object)referrers).toString()));
        }
        return this.m_indexSources.remove(indexsource.getName()) != null;
    }

    public void setDirectory(String value) {
        this.m_path = value;
    }

    public void setExtractionCacheMaxAge(float extractionCacheMaxAge) {
        this.m_extractionCacheMaxAge = extractionCacheMaxAge;
    }

    public void setExtractionCacheMaxAge(String extractionCacheMaxAge) {
        try {
            this.setExtractionCacheMaxAge(Float.parseFloat(extractionCacheMaxAge));
        }
        catch (NumberFormatException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXTRACTION_CACHE_AGE_FAILED_2", extractionCacheMaxAge, new Float(672.0f)), (Throwable)e);
            this.setExtractionCacheMaxAge(672.0f);
        }
    }

    public void setForceunlock(String value) {
        this.m_forceUnlockMode = CmsSearchForceUnlockMode.valueOf(value);
    }

    public void setHighlighter(String highlighter) {
        try {
            this.m_highlighter = (I_CmsTermHighlighter)Class.forName(highlighter).newInstance();
        }
        catch (Exception exc) {
            this.m_highlighter = null;
        }
    }

    public void setIndexLockMaxWaitSeconds(int value) {
        this.m_indexLockMaxWaitSeconds = value;
    }

    public void setMaxExcerptLength(int maxExcerptLength) {
        this.m_maxExcerptLength = maxExcerptLength;
    }

    public void setMaxExcerptLength(String maxExcerptLength) {
        try {
            this.setMaxExcerptLength(Integer.parseInt(maxExcerptLength));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_EXCERPT_LENGTH_FAILED_2", maxExcerptLength, new Integer(1024)), (Throwable)e);
            this.setMaxExcerptLength(1024);
        }
    }

    public void setTimeout(long value) {
        this.m_timeout = value;
    }

    public void setTimeout(String value) {
        try {
            this.setTimeout(Long.parseLong(value));
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_TIMEOUT_FAILED_2", value, new Long(60000L)), (Throwable)e);
            this.setTimeout(60000L);
        }
    }

    protected void forceIndexUnlock(CmsSearchIndex index, I_CmsReport report, boolean mode) throws CmsIndexException {
        File indexPath = new File(index.getPath());
        boolean indexLocked = true;
        if (indexPath.exists()) {
            try {
                indexLocked = IndexReader.isLocked((String)index.getPath());
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_OPEN_2", index.getPath(), index.getName()), (Throwable)e);
            }
            if (indexLocked) {
                if (this.m_forceUnlockMode != null && this.m_forceUnlockMode.equals(CmsSearchForceUnlockMode.ALWAYS)) {
                    try {
                        IndexReader.unlock((Directory)FSDirectory.getDirectory((String)index.getPath()));
                    }
                    catch (Exception e) {
                        CmsMessageContainer msg = Messages.get().container("ERR_INDEX_LOCK_FAILED_1", index.getName());
                        report.println(msg, 5);
                        throw new CmsIndexException(msg, (Throwable)e);
                    }
                }
                if (this.m_forceUnlockMode != null && this.m_forceUnlockMode.equals(CmsSearchForceUnlockMode.NEVER)) {
                    if (indexLocked = this.waitIndexLock(index, report, indexLocked)) {
                        CmsMessageContainer msg = Messages.get().container("ERR_INDEX_LOCK_FAILED_1", index.getName());
                        report.println(msg, 5);
                        throw new CmsIndexException(msg);
                    }
                } else {
                    if (mode) {
                        indexLocked = this.waitIndexLock(index, report, indexLocked);
                    }
                    if (indexLocked) {
                        if (mode) {
                            CmsMessageContainer msg = Messages.get().container("ERR_INDEX_LOCK_FAILED_1", index.getName());
                            report.println(msg, 5);
                            throw new CmsIndexException(msg);
                        }
                        try {
                            IndexReader.unlock((Directory)FSDirectory.getDirectory((String)index.getPath()));
                        }
                        catch (Exception e) {
                            CmsMessageContainer msg = Messages.get().container("ERR_INDEX_LOCK_FAILED_1", index.getName());
                            report.println(msg, 5);
                            throw new CmsIndexException(msg, (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    protected Analyzer getAnalyzer(Locale locale) throws CmsIndexException {
        Analyzer analyzer = null;
        String className = null;
        CmsSearchAnalyzer analyzerConf = (CmsSearchAnalyzer)this.m_analyzers.get(locale);
        if (analyzerConf == null) {
            throw new CmsIndexException(Messages.get().container("ERR_ANALYZER_NOT_FOUND_1", locale));
        }
        try {
            className = analyzerConf.getClassName();
            Class<?> analyzerClass = Class.forName(className);
            String stemmerAlgorithm = analyzerConf.getStemmerAlgorithm();
            analyzer = stemmerAlgorithm != null ? (Analyzer)analyzerClass.getDeclaredConstructor(String.class).newInstance(stemmerAlgorithm) : (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_LOAD_ANALYZER_1", className), (Throwable)e);
        }
        PerFieldAnalyzerWrapper wrapper = new PerFieldAnalyzerWrapper(analyzer);
        wrapper.addAnalyzer("root", (Analyzer)new WhitespaceAnalyzer());
        return wrapper;
    }

    protected I_CmsDocumentFactory getDocumentFactory(CmsResource resource) {
        String documentTypeKey;
        String mimeType = OpenCms.getResourceManager().getMimeType(resource.getRootPath(), null, "text/plain");
        I_CmsDocumentFactory result = null;
        String typeName = null;
        try {
            typeName = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            // empty catch block
        }
        if (typeName != null && (result = (I_CmsDocumentFactory)this.m_documentTypes.get(documentTypeKey = A_CmsVfsDocument.getDocumentKey(typeName, mimeType))) == null) {
            result = (I_CmsDocumentFactory)this.m_documentTypes.get(A_CmsVfsDocument.getDocumentKey(typeName, null));
        }
        return result;
    }

    protected List getDocumentTypes() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = this.m_documentTypes.values().iterator();
        while (i.hasNext()) {
            I_CmsDocumentFactory factory = (I_CmsDocumentFactory)i.next();
            names.add(factory.getName());
        }
        return names;
    }

    protected void initAvailableDocumentTypes() {
        CmsSearchDocumentType documenttype = null;
        String className = null;
        String name = null;
        I_CmsDocumentFactory documentFactory = null;
        List resourceTypes = null;
        List mimeTypes = null;
        Class<?> c = null;
        this.m_documentTypes = new HashMap();
        int n = this.m_documentTypeConfigs.size();
        for (int i = 0; i < n; ++i) {
            documenttype = (CmsSearchDocumentType)this.m_documentTypeConfigs.get(i);
            name = documenttype.getName();
            try {
                className = documenttype.getClassName();
                resourceTypes = documenttype.getResourceTypes();
                mimeTypes = documenttype.getMimeTypes();
                if (name == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_NAME_0"));
                }
                if (className == null) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_CLASS_DEF_0"));
                }
                if (resourceTypes.size() == 0) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCTYPE_NO_RESOURCETYPE_DEF_0"));
                }
                try {
                    c = Class.forName(className);
                    documentFactory = (I_CmsDocumentFactory)c.getConstructor(class$java$lang$String == null ? CmsSearchManager.class$("java.lang.String") : class$java$lang$String).newInstance(name);
                }
                catch (ClassNotFoundException exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_NOT_FOUND_1", className), (Throwable)exc);
                }
                catch (Exception exc) {
                    throw new CmsIndexException(Messages.get().container("ERR_DOCCLASS_INIT_1", className), (Throwable)exc);
                }
                if (documentFactory.isUsingCache()) {
                    documentFactory.setCache(this.m_extractionResultCache);
                }
                Iterator key = documentFactory.getDocumentKeys(resourceTypes, mimeTypes).iterator();
                while (key.hasNext()) {
                    this.m_documentTypes.put(key.next(), documentFactory);
                }
                continue;
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_DOCTYPE_CONFIG_FAILED_1", name), (Throwable)e);
            }
        }
    }

    protected void initSearchIndexes() {
        CmsSearchIndex index = null;
        int n = this.m_indexes.size();
        for (int i = 0; i < n; ++i) {
            block5: {
                index = (CmsSearchIndex)this.m_indexes.get(i);
                index.setEnabled(true);
                if (index.checkConfiguration(this.m_adminCms)) {
                    try {
                        index.initialize();
                    }
                    catch (CmsException e) {
                        if (!CmsLog.INIT.isInfoEnabled()) break block5;
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_INIT_FAILED_1", index.getName()), (Throwable)e);
                    }
                }
            }
            if (!CmsLog.INIT.isInfoEnabled()) continue;
            if (index.isEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INDEX_CONFIGURED_2", index.getName(), index.getProject()));
                continue;
            }
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_INDEX_NOT_CONFIGURED_2", index.getName(), index.getProject()));
        }
    }

    protected synchronized void updateAllIndexes(CmsObject adminCms, CmsUUID publishHistoryId, I_CmsReport report) {
        List publishedResources;
        try {
            publishedResources = adminCms.readPublishedResources(publishHistoryId);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READING_CHANGED_RESOURCES_FAILED_1", publishHistoryId), (Throwable)e);
            return;
        }
        ArrayList<CmsPublishedResource> updateResources = new ArrayList<CmsPublishedResource>();
        Iterator itPubRes = publishedResources.iterator();
        while (itPubRes.hasNext()) {
            CmsPublishedResource res = (CmsPublishedResource)itPubRes.next();
            if (res.isFolder() || res.getState().isUnchanged() || !res.getState().isDeleted() && !res.getState().isNew() && !res.getState().isChanged()) continue;
            if (updateResources.contains(res)) {
                updateResources.remove(res);
                updateResources.add(res);
                continue;
            }
            updateResources.add(res);
            if (res.getState().isDeleted() || res.getSiblingCount() <= 1) continue;
            try {
                List siblings = adminCms.readSiblings(res.getRootPath(), CmsResourceFilter.ALL);
                Iterator itSib = siblings.iterator();
                while (itSib.hasNext()) {
                    CmsResource sibling = (CmsResource)itSib.next();
                    CmsPublishedResource sib = new CmsPublishedResource(sibling);
                    if (updateResources.contains(sib)) continue;
                    updateResources.add(sib);
                }
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SIBLINGS_1", res.getRootPath()), (Throwable)e);
            }
        }
        if (!updateResources.isEmpty()) {
            Collections.sort(updateResources);
            Iterator i = this.m_indexes.iterator();
            while (i.hasNext()) {
                CmsSearchIndex index = (CmsSearchIndex)i.next();
                if (!"auto".equals(index.getRebuildMode())) continue;
                try {
                    this.updateIndex(index, report, updateResources);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_UPDATE_INDEX_FAILED_1", index.getName()), (Throwable)e);
                }
            }
        }
        this.m_extractionResultCache.cleanCache(this.m_extractionCacheMaxAge);
    }

    private I_CmsReport getEventReport(CmsEvent event) {
        I_CmsReport report = null;
        if (event.getData() != null) {
            report = (I_CmsReport)event.getData().get("report");
        }
        if (report == null) {
            report = new CmsLogReport(Locale.ENGLISH, this.getClass());
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void updateIndex(CmsSearchIndex index, I_CmsReport report, List resourcesToIndex) throws CmsException {
        block44: {
            block43: {
                cms = OpenCms.initCmsObject(this.m_adminCms);
                if (report == null) {
                    report = new CmsLogReport(cms.getRequestContext().getLocale(), CmsSearchManager.class);
                }
                if (!index.checkConfiguration(cms)) {
                    return;
                }
                cms.getRequestContext().setSiteRoot("/");
                cms.getRequestContext().setCurrentProject(cms.readProject(index.getProject()));
                if (resourcesToIndex != null && !resourcesToIndex.isEmpty()) break block43;
                this.forceIndexUnlock(index, report, false);
                threadManager = new CmsIndexingThreadManager(this.m_timeout);
                writer = null;
                try {
                    block41: {
                        writer = index.getIndexWriter(true);
                        report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_BEGIN_1", index.getName()), 2);
                        sources = index.getSources().iterator();
                        while (sources.hasNext()) {
                            source = (CmsSearchIndexSource)sources.next();
                            indexer = source.getIndexer().newInstance(cms, report, index);
                            indexer.rebuildIndex(writer, threadManager, source);
                        }
                        while (threadManager.isRunning()) {
                            try {
                                this.wait(1000L);
                            }
                            catch (InterruptedException e) {}
                        }
                        try {
                            writer.optimize();
                        }
                        catch (IOException e) {
                            if (!CmsSearchManager.LOG.isWarnEnabled()) break block41;
                            CmsSearchManager.LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_OPTIMIZE_1", index.getPath(), index.getName()), (Throwable)e);
                        }
                    }
                    report.println(Messages.get().container("RPT_SEARCH_INDEXING_REBUILD_END_1", index.getName()), 2);
                    var11_17 = null;
                    ** if (writer == null) goto lbl-1000
                }
                catch (Throwable var10_24) {
                    block42: {
                        var11_18 = null;
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                if (!CmsSearchManager.LOG.isWarnEnabled()) break block42;
                                CmsSearchManager.LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                            }
                        }
                    }
                    throw var10_24;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        if (CmsSearchManager.LOG.isWarnEnabled()) {
                            CmsSearchManager.LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                        }
                    }
                }
lbl-1000:
                // 4 sources

                {
                }
                threadManager.reportStatistics(report);
                break block44;
            }
            updateCollections = new ArrayList<CmsSearchIndexUpdateData>();
            hasResourcesToDelete = false;
            hasResourcesToUpdate = false;
            sources = index.getSources().iterator();
            while (sources.hasNext()) {
                source = (CmsSearchIndexSource)sources.next();
                indexer = source.getIndexer().newInstance(cms, report, index);
                updateData = indexer.getUpdateData(source, resourcesToIndex);
                if (updateData.isEmpty()) continue;
                updateCollections.add(updateData);
                hasResourcesToDelete |= updateData.hasResourcesToDelete();
                hasResourcesToUpdate |= updateData.hasResourceToUpdate();
            }
            if (hasResourcesToDelete || hasResourcesToUpdate) {
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_BEGIN_1", index.getName()), 2);
            }
            this.forceIndexUnlock(index, report, true);
            if (hasResourcesToDelete) {
                reader = null;
                try {
                    reader = IndexReader.open((String)index.getPath());
                }
                catch (IOException e) {
                    CmsSearchManager.LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_OPEN_2", index.getPath(), index.getName()), (Throwable)e);
                }
                if (reader != null) {
                    try {
                        i = updateCollections.iterator();
                        while (i.hasNext()) {
                            updateCollection = (CmsSearchIndexUpdateData)i.next();
                            if (!updateCollection.hasResourcesToDelete()) continue;
                            updateCollection.getIndexer().deleteResources(reader, updateCollection.getResourcesToDelete());
                        }
                        var14_27 = null;
                    }
                    catch (Throwable var13_31) {
                        var14_28 = null;
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            CmsSearchManager.LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                        }
                        throw var13_31;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        CmsSearchManager.LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                    }
                }
            }
            if (hasResourcesToUpdate) {
                threadManager = new CmsIndexingThreadManager(this.m_timeout);
                writer = null;
                try {
                    writer = index.getIndexWriter(false);
                    i = updateCollections.iterator();
                    while (i.hasNext()) {
                        updateCollection = (CmsSearchIndexUpdateData)i.next();
                        if (!updateCollection.hasResourceToUpdate()) continue;
                        updateCollection.getIndexer().updateResources(writer, threadManager, updateCollection.getResourcesToUpdate());
                    }
                    while (threadManager.isRunning()) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {}
                    }
                    var17_32 = null;
                    ** if (writer == null) goto lbl-1000
                }
                catch (Throwable var16_36) {
                    var17_33 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            CmsSearchManager.LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                        }
                    }
                    throw var16_36;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        CmsSearchManager.LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_WRITER_CLOSE_2", index.getPath(), index.getName()), (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            if (hasResourcesToDelete || hasResourcesToUpdate) {
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_UPDATE_END_1", index.getName()), 2);
            }
        }
    }

    private boolean waitIndexLock(CmsSearchIndex index, I_CmsReport report, boolean indexLocked) {
        try {
            int lockSecs = 0;
            while (indexLocked && lockSecs < this.m_indexLockMaxWaitSeconds) {
                indexLocked = IndexReader.isLocked((String)index.getPath());
                if (!indexLocked) continue;
                report.println(Messages.get().container("RPT_SEARCH_INDEXING_LOCK_WAIT_2", index.getName(), new Integer(this.m_indexLockMaxWaitSeconds - lockSecs)), 5);
                Thread.sleep(1000L);
                ++lockSecs;
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_IO_INDEX_READER_OPEN_2", index.getPath(), index.getName()), (Throwable)e);
        }
        return indexLocked;
    }

    public static final class CmsSearchForceUnlockMode
    extends A_CmsModeStringEnumeration {
        public static final CmsSearchForceUnlockMode ALWAYS = new CmsSearchForceUnlockMode("always");
        public static final CmsSearchForceUnlockMode NEVER = new CmsSearchForceUnlockMode("never");
        public static final CmsSearchForceUnlockMode ONLYFULL = new CmsSearchForceUnlockMode("onlyfull");
        private static final long serialVersionUID = 74746076708908673L;

        protected CmsSearchForceUnlockMode(String mode) {
            super(mode);
        }

        public static CmsSearchForceUnlockMode valueOf(String type) {
            if (type.equals(ALWAYS.toString())) {
                return ALWAYS;
            }
            if (type.equals(NEVER.toString())) {
                return NEVER;
            }
            return ONLYFULL;
        }
    }
}

