/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.Messages;

public class CmsVfsIndexer
implements I_CmsIndexer {
    private static final Log LOG = CmsLog.getLog(CmsVfsIndexer.class);
    private CmsObject m_cms;
    private CmsSearchIndex m_index;
    private I_CmsReport m_report;

    public void deleteResources(IndexReader reader, List resourcesToDelete) {
        if (resourcesToDelete == null || resourcesToDelete.isEmpty()) {
            return;
        }
        ArrayList<String> resourcesAlreadyDeleted = new ArrayList<String>(resourcesToDelete.size());
        Iterator i = resourcesToDelete.iterator();
        while (i.hasNext()) {
            CmsPublishedResource res = (CmsPublishedResource)i.next();
            String rootPath = res.getRootPath();
            if (resourcesAlreadyDeleted.contains(rootPath)) continue;
            resourcesAlreadyDeleted.add(rootPath);
            Term term = new Term("path", rootPath);
            try {
                reader.deleteDocuments(term);
            }
            catch (IOException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_IO_INDEX_DOCUMENT_DELETE_2", rootPath, this.m_index.getName()), (Throwable)e);
            }
        }
    }

    public CmsSearchIndexUpdateData getUpdateData(CmsSearchIndexSource source, List publishedResources) {
        CmsSearchIndexUpdateData result = new CmsSearchIndexUpdateData(source, this);
        Iterator i = publishedResources.iterator();
        while (i.hasNext()) {
            CmsPublishedResource resource = (CmsPublishedResource)i.next();
            if (resource.getStructureId().isNullUUID() || !CmsProject.isInsideProject(source.getResourcesNames(), resource.getRootPath())) continue;
            if (resource.getState().isNew()) {
                if (!this.isResourceInTimeWindow(resource)) continue;
                result.addResourceToUpdate(resource);
                continue;
            }
            if (resource.getState().isDeleted()) {
                result.addResourceToDelete(resource);
                continue;
            }
            if (!resource.getState().isChanged() && !resource.getState().isUnchanged()) continue;
            result.addResourceToDelete(resource);
            if (!this.isResourceInTimeWindow(resource)) continue;
            result.addResourceToUpdate(resource);
        }
        return result;
    }

    public I_CmsIndexer newInstance(CmsObject cms, I_CmsReport report, CmsSearchIndex index) {
        CmsVfsIndexer indexer = new CmsVfsIndexer();
        indexer.m_cms = cms;
        indexer.m_report = report;
        indexer.m_index = index;
        return indexer;
    }

    public void rebuildIndex(IndexWriter writer, CmsIndexingThreadManager threadManager, CmsSearchIndexSource source) throws CmsIndexException {
        List resourceNames = source.getResourcesNames();
        Iterator i = resourceNames.iterator();
        while (i.hasNext()) {
            List resources;
            block5: {
                String resourceName = (String)i.next();
                resources = null;
                try {
                    resources = this.m_cms.readResources(resourceName, CmsResourceFilter.DEFAULT.addRequireFile());
                }
                catch (CmsException e) {
                    if (this.m_report != null) {
                        this.m_report.println(Messages.get().container("RPT_UNABLE_TO_READ_SOURCE_2", resourceName, e.getLocalizedMessage()), 1);
                    }
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SOURCE_2", resourceName, this.m_index.getName()), (Throwable)e);
                }
            }
            if (resources == null) continue;
            Iterator j = resources.iterator();
            while (j.hasNext()) {
                CmsResource resource = (CmsResource)j.next();
                this.updateResource(writer, threadManager, resource);
            }
        }
    }

    public void updateResources(IndexWriter writer, CmsIndexingThreadManager threadManager, List resourcesToUpdate) throws CmsIndexException {
        if (resourcesToUpdate == null || resourcesToUpdate.isEmpty()) {
            return;
        }
        ArrayList<String> resourcesAlreadyUpdated = new ArrayList<String>(resourcesToUpdate.size());
        Iterator i = resourcesToUpdate.iterator();
        while (i.hasNext()) {
            CmsResource resource;
            block4: {
                CmsPublishedResource res = (CmsPublishedResource)i.next();
                resource = null;
                try {
                    resource = this.m_cms.readResource(res.getRootPath());
                }
                catch (CmsException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_RESOURCE_2", res.getRootPath(), this.m_index.getName()), (Throwable)e);
                }
            }
            if (resource == null || resourcesAlreadyUpdated.contains(resource.getRootPath())) continue;
            resourcesAlreadyUpdated.add(resource.getRootPath());
            this.updateResource(writer, threadManager, resource);
        }
    }

    protected boolean isResourceInTimeWindow(CmsPublishedResource resource) {
        return this.m_cms.existsResource(this.m_cms.getRequestContext().removeSiteRoot(resource.getRootPath()), CmsResourceFilter.DEFAULT);
    }

    protected void updateResource(IndexWriter writer, CmsIndexingThreadManager threadManager, CmsResource resource) throws CmsIndexException {
        if (resource.isInternal()) {
            return;
        }
        try {
            if (this.m_report != null) {
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(threadManager.getCounter() + 1)), 3);
                this.m_report.print(Messages.get().container("RPT_SEARCH_INDEXING_FILE_BEGIN_0"), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", this.m_report.removeSiteRoot(resource.getRootPath())));
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 0);
            }
            threadManager.createIndexingThread(this.m_cms, writer, resource, this.m_index, this.m_report);
        }
        catch (Exception e) {
            if (this.m_report != null) {
                this.m_report.println(Messages.get().container("RPT_SEARCH_INDEXING_FAILED_0"), 1);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", resource.getRootPath(), this.m_index.getName()), (Throwable)e);
            }
            throw new CmsIndexException(Messages.get().container("ERR_INDEX_RESOURCE_FAILED_2", resource.getRootPath(), this.m_index.getName()));
        }
    }
}

