/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDocumentXmlContent
extends A_CmsVfsDocument {
    static /* synthetic */ Class class$org$opencms$file$types$CmsResourceTypeXmlContent;

    public CmsDocumentXmlContent(String name) {
        super(name);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        try {
            CmsFile file = this.readFile(cms, resource);
            String absolutePath = cms.getSitePath(file);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
            List locales = xmlContent.getLocales();
            if (locales.size() == 0) {
                locales = OpenCms.getLocaleManager().getDefaultLocales(cms, absolutePath);
            }
            Locale locale = OpenCms.getLocaleManager().getBestMatchingLocale(index.getLocale(), OpenCms.getLocaleManager().getDefaultLocales(cms, absolutePath), locales);
            List elements = xmlContent.getNames(locale);
            StringBuffer content = new StringBuffer();
            HashMap<String, String> items = new HashMap<String, String>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String extracted;
                String xpath = (String)i.next();
                I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                if (!value.getContentDefinition().getContentHandler().isSearchable(value) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted = value.getPlainText(cms))) continue;
                items.put(xpath, extracted);
                content.append(extracted);
                content.append('\n');
            }
            return new CmsExtractionResult(content.toString(), items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    public List getDocumentKeys(List resourceTypes, List mimeTypes) throws CmsException {
        if (resourceTypes.contains("*")) {
            ArrayList<String> allTypes = new ArrayList<String>();
            Iterator i = OpenCms.getResourceManager().getResourceTypes().iterator();
            while (i.hasNext()) {
                I_CmsResourceType resourceType = (I_CmsResourceType)i.next();
                if (!(resourceType instanceof CmsResourceTypeXmlContent) || !((CmsResourceTypeXmlContent)resourceType).getConfiguration().containsKey("schema") && (class$org$opencms$file$types$CmsResourceTypeXmlContent == null ? CmsDocumentXmlContent.class$("org.opencms.file.types.CmsResourceTypeXmlContent") : class$org$opencms$file$types$CmsResourceTypeXmlContent).equals(resourceType.getClass())) continue;
                allTypes.add(resourceType.getTypeName());
            }
            resourceTypes = allTypes;
        }
        return super.getDocumentKeys(resourceTypes, mimeTypes);
    }

    public boolean isLocaleDependend() {
        return true;
    }

    public boolean isUsingCache() {
        return true;
    }
}

