/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsDocumentXmlPage
extends A_CmsVfsDocument {
    public CmsDocumentXmlPage(String name) {
        super(name);
    }

    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        try {
            CmsFile file = this.readFile(cms, resource);
            String absolutePath = cms.getSitePath(file);
            CmsXmlPage page = CmsXmlPageFactory.unmarshal(cms, file);
            List pageLocales = page.getLocales();
            if (pageLocales.size() == 0) {
                pageLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, absolutePath);
            }
            Locale locale = OpenCms.getLocaleManager().getBestMatchingLocale(index.getLocale(), OpenCms.getLocaleManager().getDefaultLocales(cms, absolutePath), pageLocales);
            List elements = page.getNames(locale);
            StringBuffer content = new StringBuffer();
            HashMap<String, String> items = new HashMap<String, String>();
            Iterator i = elements.iterator();
            while (i.hasNext()) {
                String elementName = (String)i.next();
                String value = page.getStringValue(cms, elementName, locale);
                String extracted = CmsHtmlExtractor.extractText(value, page.getEncoding());
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted)) continue;
                items.put(elementName, extracted);
                content.append(extracted);
                content.append('\n');
            }
            return new CmsExtractionResult(content.toString(), items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    public boolean isLocaleDependend() {
        return true;
    }

    public boolean isUsingCache() {
        return true;
    }
}

