/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.documents.I_CmsTermHighlighter;

public class CmsTermHighlighterHtml
implements I_CmsTermHighlighter {
    private static final String EXCERPT_FRAGMENT_SEPARATOR = " ... ";
    private static final int EXCERPT_REQUIRED_FRAGMENTS = 5;

    public String getExcerpt(Document doc, CmsSearchIndex index, CmsSearchParameters params, Query query, Analyzer analyzer) throws IOException {
        if (doc == null || index == null || params == null || analyzer == null || query == null) {
            return null;
        }
        Highlighter highlighter = null;
        Iterator excerptFieldNames = index.getFieldConfiguration().getExcerptFieldNames().iterator();
        StringBuffer excerptBuffer = new StringBuffer();
        while (excerptFieldNames.hasNext()) {
            String fieldName = (String)excerptFieldNames.next();
            boolean createExcerpt = !params.isExcerptOnlySearchedFields() || params.getFields().contains(fieldName);
            if (!createExcerpt || doc.getField(fieldName) == null) continue;
            String text = doc.getField(fieldName).stringValue();
            text = CmsEncoder.escapeXml(text);
            TokenStream stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            if (params.isExcerptOnlySearchedFields()) {
                highlighter = new Highlighter((Scorer)new QueryScorer(query, fieldName));
            } else if (highlighter == null) {
                highlighter = new Highlighter((Scorer)new QueryScorer(query));
            }
            String fragment = highlighter.getBestFragments(stream, text, 5, EXCERPT_FRAGMENT_SEPARATOR);
            fragment = fragment.replace('\t', ' ');
            fragment = fragment.replace('\n', ' ');
            fragment = fragment.replace('\r', ' ');
            fragment = fragment.replace('\f', ' ');
            if (excerptBuffer.length() > 0) {
                excerptBuffer.append(EXCERPT_FRAGMENT_SEPARATOR);
            }
            excerptBuffer.append(fragment);
        }
        String result = null;
        if (excerptBuffer.length() > 0) {
            result = excerptBuffer.toString();
        }
        int maxLength = OpenCms.getSearchManager().getMaxExcerptLength();
        if (result != null && result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        return result;
    }
}

