/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.opencms.search.extractors.A_CmsTextExtractorMsOfficeBase;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;
import org.opencms.util.CmsStringUtil;

public final class CmsExtractorMsExcel
extends A_CmsTextExtractorMsOfficeBase {
    private static final CmsExtractorMsExcel INSTANCE = new CmsExtractorMsExcel();

    private CmsExtractorMsExcel() {
    }

    public static I_CmsTextExtractor getExtractor() {
        return INSTANCE;
    }

    public I_CmsExtractionResult extractText(InputStream in, String encoding) throws Exception {
        String rawContent = this.extractTableContent(this.getStreamCopy(in));
        rawContent = this.removeControlChars(rawContent);
        POIFSReader reader = new POIFSReader();
        reader.registerListener((POIFSReaderListener)this);
        reader.read(this.getStreamCopy(in));
        return this.createExtractionResult(rawContent);
    }

    protected String extractTableContent(InputStream in) throws IOException {
        HSSFWorkbook excelWb = new HSSFWorkbook(in);
        StringBuffer result = new StringBuffer(4096);
        int numberOfSheets = excelWb.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            HSSFSheet sheet = excelWb.getSheetAt(i);
            int numberOfRows = sheet.getPhysicalNumberOfRows();
            if (numberOfRows <= 0) continue;
            if (CmsStringUtil.isNotEmpty(excelWb.getSheetName(i))) {
                if (i > 0) {
                    result.append("\n\n");
                }
                result.append(excelWb.getSheetName(i).trim());
                result.append(":\n\n");
            }
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                HSSFRow row = (HSSFRow)rowIt.next();
                if (row == null) continue;
                boolean hasContent = false;
                Iterator it = row.cellIterator();
                while (it.hasNext()) {
                    HSSFCell cell = (HSSFCell)it.next();
                    String text = null;
                    try {
                        switch (cell.getCellType()) {
                            case 3: 
                            case 5: {
                                break;
                            }
                            case 0: {
                                text = Double.toString(cell.getNumericCellValue());
                                break;
                            }
                            case 4: {
                                text = Boolean.toString(cell.getBooleanCellValue());
                                break;
                            }
                            default: {
                                text = cell.getStringCellValue();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (text == null || text.length() == 0) continue;
                    result.append(text.trim());
                    result.append(' ');
                    hasContent = true;
                }
                if (!hasContent) continue;
                result.append('\n');
            }
        }
        return result.toString();
    }
}

