/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.InputStream;
import java.util.HashMap;
import org.opencms.search.extractors.A_CmsTextExtractor;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;
import org.opencms.util.CmsStringUtil;
import org.pdfbox.encryption.DocumentEncryption;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.util.PDFTextStripper;

public final class CmsExtractorPdf
extends A_CmsTextExtractor {
    private static final CmsExtractorPdf INSTANCE = new CmsExtractorPdf();

    private CmsExtractorPdf() {
    }

    public static I_CmsTextExtractor getExtractor() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I_CmsExtractionResult extractText(InputStream in, String encoding) throws Exception {
        PDDocument pdfDocument = null;
        try {
            PDFParser parser = new PDFParser(in);
            parser.parse();
            pdfDocument = parser.getPDDocument();
            if (pdfDocument.isEncrypted()) {
                DocumentEncryption decryptor = new DocumentEncryption(pdfDocument);
                decryptor.decryptDocument("");
            }
            PDFTextStripper stripper = new PDFTextStripper();
            PDDocumentInformation info = pdfDocument.getDocumentInformation();
            HashMap<String, String> contentItems = new HashMap<String, String>();
            String result = stripper.getText(pdfDocument);
            StringBuffer content = new StringBuffer(result);
            if (CmsStringUtil.isNotEmpty(result)) {
                contentItems.put("__raw", result);
            }
            this.combineContentItem(info.getTitle(), "title", content, contentItems);
            this.combineContentItem(info.getKeywords(), "keywords", content, contentItems);
            this.combineContentItem(info.getSubject(), "subject", content, contentItems);
            this.combineContentItem(info.getAuthor(), "author", content, contentItems);
            this.combineContentItem(info.getCreator(), "creator", content, contentItems);
            this.combineContentItem(info.getProducer(), "producer", content, contentItems);
            stripper = null;
            info = null;
            CmsExtractionResult cmsExtractionResult = new CmsExtractionResult(content.toString(), contentItems);
            return cmsExtractionResult;
        }
        finally {
            if (pdfDocument != null) {
                pdfDocument.close();
            }
        }
    }
}

