/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.search.Messages;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.util.CmsStringUtil;

public class CmsSearchFieldMapping {
    private String m_defaultValue;
    private int m_hashCode;
    private String m_param;
    private CmsSearchFieldMappingType m_type;

    public CmsSearchFieldMapping() {
    }

    public CmsSearchFieldMapping(CmsSearchFieldMappingType type, String param) {
        this();
        this.setType(type);
        this.setParam(param);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchFieldMapping) {
            CmsSearchFieldMapping other = (CmsSearchFieldMapping)obj;
            return CmsStringUtil.isEqual(this.m_type, other.m_type) && CmsStringUtil.isEqual(this.m_param, other.m_param);
        }
        return false;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getStringValue(CmsObject cms, CmsResource res, I_CmsExtractionResult extractionResult) {
        String content = null;
        switch (this.getType().getMode()) {
            case 0: {
                if (extractionResult == null) break;
                content = extractionResult.getContent();
                break;
            }
            case 1: 
            case 2: {
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                boolean search = this.getType() == CmsSearchFieldMappingType.PROPERTY_SEARCH;
                try {
                    content = cms.readPropertyObject(res, this.getParam(), search).getValue();
                }
                catch (CmsException e) {}
                break;
            }
            case 3: {
                if (extractionResult == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParam())) break;
                content = (String)extractionResult.getContentItems().get(this.getParam());
                break;
            }
        }
        if (content == null) {
            content = this.getDefaultValue();
        }
        return content;
    }

    public CmsSearchFieldMappingType getType() {
        return this.m_type;
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int hashCode = 73 * (this.m_type == null ? 29 : this.m_type.hashCode());
            if (this.m_param != null) {
                hashCode += this.m_param.hashCode();
            }
            this.m_hashCode = hashCode;
        }
        return this.m_hashCode;
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    public void setParam(String param) {
        this.m_param = CmsStringUtil.isNotEmptyOrWhitespaceOnly(param) ? param.trim() : null;
    }

    public void setType(CmsSearchFieldMappingType type) {
        this.m_type = type;
    }

    public void setType(String type) {
        CmsSearchFieldMappingType mappingType = CmsSearchFieldMappingType.valueOf(type);
        if (mappingType == null) {
            throw new CmsRuntimeException(new CmsMessageContainer(Messages.get(), "ERR_FIELD_TYPE_UNKNOWN_1", new Object[]{type}));
        }
        this.setType(mappingType);
    }
}

