/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsUser;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsAccessControlList {
    private HashMap m_permissions = new HashMap();

    public void add(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = (CmsPermissionSetCustom)this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.addPermissions(entry.getPermissions());
    }

    public Object clone() {
        CmsAccessControlList acl = new CmsAccessControlList();
        Iterator i = this.m_permissions.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            acl.m_permissions.put(key, ((CmsPermissionSetCustom)this.m_permissions.get(key)).clone());
        }
        return acl;
    }

    public HashMap getPermissionMap() {
        return this.m_permissions;
    }

    public CmsPermissionSetCustom getPermissions(CmsUser user, List groups, List roles) {
        int i;
        int size;
        CmsPermissionSetCustom sum = new CmsPermissionSetCustom();
        boolean hasPermissions = false;
        CmsPermissionSet p = (CmsPermissionSet)this.m_permissions.get(user.getId());
        if (p != null) {
            sum.addPermissions(p);
            hasPermissions = true;
        }
        if (groups != null) {
            size = groups.size();
            for (i = 0; i < size; ++i) {
                I_CmsPrincipal principal = (I_CmsPrincipal)groups.get(i);
                p = (CmsPermissionSet)this.m_permissions.get(principal.getId());
                if (p == null) continue;
                sum.addPermissions(p);
                hasPermissions = true;
            }
        }
        if (roles != null) {
            size = roles.size();
            for (i = 0; i < size; ++i) {
                CmsRole role = (CmsRole)roles.get(i);
                p = (CmsPermissionSet)this.m_permissions.get(role.getId());
                if (p == null) continue;
                sum.addPermissions(p);
                hasPermissions = true;
            }
        }
        if (!hasPermissions && (p = (CmsPermissionSet)this.m_permissions.get(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID)) != null) {
            sum.addPermissions(p);
        }
        return sum;
    }

    public CmsPermissionSetCustom getPermissions(CmsUUID principalId) {
        return (CmsPermissionSetCustom)this.m_permissions.get(principalId);
    }

    public String getPermissionString(CmsUser user, List groups, List roles) {
        return this.getPermissions(user, groups, roles).getPermissionString();
    }

    public List getPrincipals() {
        ArrayList principals = new ArrayList(this.m_permissions.keySet());
        Collections.sort(principals, CmsAccessControlEntry.COMPARATOR_PRINCIPALS);
        return principals;
    }

    public void setAllowedPermissions(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = (CmsPermissionSetCustom)this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.setPermissions(entry.getAllowedPermissions(), p.getDeniedPermissions());
    }

    public void setDeniedPermissions(CmsAccessControlEntry entry) {
        CmsPermissionSetCustom p = (CmsPermissionSetCustom)this.m_permissions.get(entry.getPrincipal());
        if (p == null) {
            p = new CmsPermissionSetCustom();
            this.m_permissions.put(entry.getPrincipal(), p);
        }
        p.setPermissions(p.getAllowedPermissions(), entry.getDeniedPermissions());
    }
}

