/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.opencms.file.CmsObject;
import org.opencms.main.A_CmsAuthorizationHandler;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;

public class CmsDefaultAuthorizationHandler
extends A_CmsAuthorizationHandler {
    public static final String AUTHORIZATION_BASIC_PREFIX = "BASIC ";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String SEPARATOR_CREDENTIALS = ":";

    public CmsObject initCmsObject(HttpServletRequest request) {
        CmsObject cms = this.checkBasicAuthorization(request);
        if (cms != null) {
            try {
                return this.registerSession(request, cms);
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return null;
    }

    public CmsObject initCmsObject(HttpServletRequest request, String userName, String pwd) throws CmsException {
        CmsObject cms = this.initCmsObjectFromSession(request);
        if (cms != null) {
            return cms;
        }
        cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
        cms.loginUser(userName, pwd);
        return this.registerSession(request, cms);
    }

    protected CmsObject checkBasicAuthorization(HttpServletRequest req) {
        try {
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
            String auth = req.getHeader(HEADER_AUTHORIZATION);
            if (auth == null || !auth.toUpperCase().startsWith(AUTHORIZATION_BASIC_PREFIX)) {
                return cms;
            }
            String base64Token = auth.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = null;
            String password = null;
            int pos = token.indexOf(SEPARATOR_CREDENTIALS);
            if (pos != -1) {
                username = token.substring(0, pos);
                password = token.substring(pos + 1);
            }
            cms.loginUser(username, password);
            req.getSession(true);
            return cms;
        }
        catch (CmsException e) {
            return null;
        }
    }
}

