/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.List;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.security.CmsOrganizationalUnit;

public class CmsOrgUnitManager {
    private final CmsSecurityManager m_securityManager;

    public CmsOrgUnitManager(CmsSecurityManager securityManager) {
        this.m_securityManager = securityManager;
    }

    public void addResourceToOrgUnit(CmsObject cms, String ouFqn, String resourceName) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        CmsResource resource = cms.readResource(resourceName);
        this.m_securityManager.addResourceToOrgUnit(cms.getRequestContext(), orgUnit, resource);
    }

    public CmsOrganizationalUnit createOrganizationalUnit(CmsObject cms, String ouFqn, String description, int flags, String resourceName) throws CmsException {
        CmsResource resource = null;
        if ((flags & 8) == 0 || resourceName != null) {
            resource = cms.readResource(resourceName);
        }
        return this.m_securityManager.createOrganizationalUnit(cms.getRequestContext(), ouFqn, description, flags, resource);
    }

    public void deleteOrganizationalUnit(CmsObject cms, String ouFqn) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        this.m_securityManager.deleteOrganizationalUnit(cms.getRequestContext(), orgUnit);
    }

    public List getAllAccessibleProjects(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getAllAccessibleProjects(cms.getRequestContext(), orgUnit, includeSubOus);
    }

    public List getAllManageableProjects(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getAllManageableProjects(cms.getRequestContext(), orgUnit, includeSubOus);
    }

    public List getGroups(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getGroups(cms.getRequestContext(), orgUnit, includeSubOus, false);
    }

    public List getOrganizationalUnits(CmsObject cms, String ouFqn, boolean includeChildren) throws CmsException {
        CmsOrganizationalUnit parent = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getOrganizationalUnits(cms.getRequestContext(), parent, includeChildren);
    }

    public List getResourcesForOrganizationalUnit(CmsObject cms, String ouFqn) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getResourcesForOrganizationalUnit(cms.getRequestContext(), orgUnit);
    }

    public List getUsers(CmsObject cms, String ouFqn, boolean recursive) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        return this.m_securityManager.getUsers(cms.getRequestContext(), orgUnit, recursive);
    }

    public CmsOrganizationalUnit readOrganizationalUnit(CmsObject cms, String ouFqn) throws CmsException {
        return this.m_securityManager.readOrganizationalUnit(cms.getRequestContext(), ouFqn);
    }

    public void removeResourceFromOrgUnit(CmsObject cms, String ouFqn, String resourceName) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        CmsResource resource = cms.readResource(resourceName, CmsResourceFilter.ALL);
        this.m_securityManager.removeResourceFromOrgUnit(cms.getRequestContext(), orgUnit, resource);
    }

    public void setUsersOrganizationalUnit(CmsObject cms, String ouFqn, String userName) throws CmsException {
        CmsOrganizationalUnit orgUnit = this.readOrganizationalUnit(cms, ouFqn);
        CmsUser user = cms.readUser(userName);
        this.m_securityManager.setUsersOrganizationalUnit(cms.getRequestContext(), orgUnit, user);
    }

    public void writeOrganizationalUnit(CmsObject cms, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        this.m_securityManager.writeOrganizationalUnit(cms.getRequestContext(), organizationalUnit);
    }
}

