/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;

public class CmsRoleManager {
    private final CmsSecurityManager m_securityManager;

    public CmsRoleManager(CmsSecurityManager securityManager) {
        this.m_securityManager = securityManager;
    }

    public void addUserToRole(CmsObject cms, CmsRole role, String username) throws CmsException {
        this.m_securityManager.addUserToGroup(cms.getRequestContext(), username, role.getGroupName(), true);
    }

    public void checkRole(CmsObject cms, CmsRole role) throws CmsRoleViolationException {
        this.m_securityManager.checkRole(cms.getRequestContext(), role);
    }

    public void checkRoleForResource(CmsObject cms, CmsRole role, String resourceName) throws CmsException, CmsRoleViolationException {
        CmsResource resource = cms.readResource(resourceName);
        this.m_securityManager.checkRoleForResource(cms.getRequestContext(), role, resource);
    }

    public List getManageableGroups(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        ArrayList groups = new ArrayList();
        Iterator it = this.getOrgUnitsForRole(cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(ouFqn), includeSubOus).iterator();
        while (it.hasNext()) {
            CmsOrganizationalUnit orgUnit = (CmsOrganizationalUnit)it.next();
            groups.addAll(OpenCms.getOrgUnitManager().getGroups(cms, orgUnit.getName(), false));
        }
        return groups;
    }

    public List getManageableResources(CmsObject cms, CmsRole role) throws CmsException {
        return this.m_securityManager.getManageableResources(cms.getRequestContext(), role);
    }

    public List getManageableUsers(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        return this.getManageableUsers(cms, ouFqn, includeSubOus, false);
    }

    public List getManageableUsers(CmsObject cms, String ouFqn, boolean includeSubOus, boolean includeWebusers) throws CmsException {
        ArrayList users = new ArrayList();
        Iterator it = this.getOrgUnitsForRole(cms, CmsRole.ACCOUNT_MANAGER.forOrgUnit(ouFqn), includeSubOus).iterator();
        while (it.hasNext()) {
            CmsOrganizationalUnit orgUnit = (CmsOrganizationalUnit)it.next();
            if (!includeWebusers && orgUnit.hasFlagWebuser()) continue;
            users.addAll(OpenCms.getOrgUnitManager().getUsers(cms, orgUnit.getName(), false));
        }
        return users;
    }

    public List getOrgUnitsForRole(CmsObject cms, CmsRole role, boolean includeSubOus) throws CmsException {
        return this.m_securityManager.getOrgUnitsForRole(cms.getRequestContext(), role, includeSubOus);
    }

    public List getRoles(CmsObject cms, String ouFqn, boolean includeSubOus) throws CmsException {
        CmsOrganizationalUnit ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(cms, ouFqn);
        List groups = this.m_securityManager.getGroups(cms.getRequestContext(), ou, includeSubOus, true);
        ArrayList<CmsRole> roles = new ArrayList<CmsRole>(groups.size());
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            roles.add(CmsRole.valueOf(group));
        }
        return roles;
    }

    public List getRolesForResource(CmsObject cms, String userFqn, String resourceName) throws CmsException {
        CmsUser user = cms.readUser(userFqn);
        CmsResource resource = cms.readResource(resourceName, CmsResourceFilter.ALL);
        return this.m_securityManager.getRolesForResource(cms.getRequestContext(), user, resource);
    }

    public List getRolesOfUser(CmsObject cms, String username, String ouFqn, boolean includeChildOus, boolean directRolesOnly, boolean recursive) throws CmsException {
        List<CmsGroup> groups;
        ouFqn = CmsOrganizationalUnit.removeLeadingSeparator(ouFqn);
        if (!recursive) {
            groups = this.m_securityManager.getGroupsOfUser(cms.getRequestContext(), username, ouFqn, includeChildOus, true, directRolesOnly, cms.getRequestContext().getRemoteAddress());
        } else {
            groups = new ArrayList();
            Iterator itAllGroups = this.m_securityManager.getGroupsOfUser(cms.getRequestContext(), username, "", true, true, directRolesOnly, cms.getRequestContext().getRemoteAddress()).iterator();
            while (itAllGroups.hasNext()) {
                CmsGroup role = (CmsGroup)itAllGroups.next();
                if (!includeChildOus && role.getOuFqn().equals(ouFqn)) {
                    groups.add(role);
                }
                if (!includeChildOus || !role.getOuFqn().startsWith(ouFqn)) continue;
                groups.add(role);
            }
        }
        ArrayList<CmsRole> roles = new ArrayList<CmsRole>(groups.size());
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            roles.add(CmsRole.valueOf(group));
        }
        return roles;
    }

    public List getUsersOfRole(CmsObject cms, CmsRole role, boolean includeOtherOuUsers, boolean directUsersOnly) throws CmsException {
        return this.m_securityManager.getUsersOfGroup(cms.getRequestContext(), role.getGroupName(), includeOtherOuUsers, directUsersOnly, true);
    }

    public boolean hasRole(CmsObject cms, CmsRole role) {
        return this.m_securityManager.hasRole(cms.getRequestContext(), cms.getRequestContext().currentUser(), role);
    }

    public boolean hasRole(CmsObject cms, String userName, CmsRole role) {
        CmsUser user;
        try {
            user = cms.readUser(userName);
        }
        catch (CmsException e) {
            return false;
        }
        return this.m_securityManager.hasRole(cms.getRequestContext(), user, role);
    }

    public boolean hasRoleForResource(CmsObject cms, CmsRole role, String resourceName) {
        CmsResource resource;
        try {
            resource = cms.readResource(resourceName, CmsResourceFilter.ALL);
        }
        catch (CmsException e) {
            return false;
        }
        return this.m_securityManager.hasRoleForResource(cms.getRequestContext(), cms.getRequestContext().currentUser(), role, resource);
    }

    public boolean hasRoleForResource(CmsObject cms, String userName, CmsRole role, String resourceName) {
        CmsUser user;
        CmsResource resource;
        try {
            resource = cms.readResource(resourceName);
        }
        catch (CmsException e) {
            return false;
        }
        try {
            user = cms.readUser(userName);
        }
        catch (CmsException e) {
            return false;
        }
        return this.m_securityManager.hasRoleForResource(cms.getRequestContext(), user, role, resource);
    }

    public void removeUserFromRole(CmsObject cms, CmsRole role, String username) throws CmsException {
        this.m_securityManager.removeUserFromGroup(cms.getRequestContext(), username, role.getGroupName(), true);
    }
}

