/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsSecurityException;
import org.opencms.staticexport.I_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public abstract class A_CmsStaticExportHandler
implements I_CmsStaticExportHandler {
    private static final Log LOG = CmsLog.getLog(A_CmsStaticExportHandler.class);
    protected boolean m_busy;

    public boolean isBusy() {
        return this.m_busy;
    }

    public abstract void performEventPublishProject(CmsUUID var1, I_CmsReport var2);

    public List scrubExportFolders(CmsUUID publishHistoryId) {
        List publishedResources;
        CmsObject cms;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SCRUBBING_EXPORT_FOLDERS_1", publishHistoryId));
        }
        HashSet scrubbedFolders = new HashSet();
        HashSet scrubbedFiles = new HashSet();
        try {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_FAILED_0"), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        try {
            publishedResources = cms.readPublishedResources(publishHistoryId);
        }
        catch (CmsException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READING_CHANGED_RESOURCES_FAILED_1", publishHistoryId), (Throwable)e);
            return Collections.EMPTY_LIST;
        }
        publishedResources = this.addMovedLinkSources(cms, publishedResources);
        Iterator itPubRes = publishedResources.iterator();
        while (itPubRes.hasNext()) {
            CmsPublishedResource res = (CmsPublishedResource)itPubRes.next();
            if (res.getState().isUnchanged()) continue;
            this.scrubResource(cms, res, scrubbedFolders, scrubbedFiles);
        }
        return publishedResources;
    }

    protected List addMovedLinkSources(CmsObject cms, List publishedResources) {
        publishedResources = new ArrayList<CmsPublishedResource>(publishedResources);
        HashSet<String> pubResources = new HashSet<String>(publishedResources.size());
        Iterator itPubRes = publishedResources.iterator();
        while (itPubRes.hasNext()) {
            CmsPublishedResource pubRes = (CmsPublishedResource)itPubRes.next();
            pubResources.add(pubRes.getRootPath());
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            Iterator itPrePubRes = new ArrayList(publishedResources).iterator();
            while (itPrePubRes.hasNext()) {
                List relations;
                block8: {
                    CmsPublishedResource res = (CmsPublishedResource)itPrePubRes.next();
                    if (res.getMovedState() != CmsPublishedResource.STATE_MOVED_DESTINATION) continue;
                    relations = null;
                    try {
                        relations = cms.getRelationsForResource(cms.getRequestContext().removeSiteRoot(res.getRootPath()), CmsRelationFilter.SOURCES);
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block8;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (relations == null || relations.isEmpty()) continue;
                Iterator itRelations = relations.iterator();
                while (itRelations.hasNext()) {
                    CmsPublishedResource source;
                    block9: {
                        CmsRelation relation = (CmsRelation)itRelations.next();
                        source = null;
                        try {
                            source = new CmsPublishedResource(relation.getSource(cms, CmsResourceFilter.ALL));
                        }
                        catch (CmsException e) {
                            if (!LOG.isWarnEnabled()) break block9;
                            LOG.warn((Object)e.getLocalizedMessage());
                        }
                    }
                    if (source == null || pubResources.contains(source.getRootPath())) continue;
                    modified = true;
                    pubResources.add(source.getRootPath());
                    publishedResources.add(source);
                }
            }
        }
        return publishedResources;
    }

    protected abstract List getRelatedFilesToPurge(String var1, String var2);

    protected List getSiblingsList(CmsObject cms, String resPath) {
        ArrayList<String> siblings;
        block6: {
            siblings = new ArrayList<String>();
            try {
                List li = cms.readSiblings(resPath, CmsResourceFilter.ALL);
                int l = li.size();
                for (int i = 0; i < l; ++i) {
                    String vfsName = ((CmsResource)li.get(i)).getRootPath();
                    siblings.add(vfsName);
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            catch (CmsSecurityException e) {
            }
            catch (CmsException e) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_FETCHING_SIBLINGS_FAILED_1", resPath), (Throwable)e);
            }
        }
        if (!siblings.contains(resPath)) {
            siblings.add(resPath);
        }
        return siblings;
    }

    protected void purgeFile(String rfsFilePath, String vfsName) {
        File[] paramVariants;
        File rfsFile = new File(rfsFilePath);
        this.deleteFile(rfsFile, vfsName);
        File parent = rfsFile.getParentFile();
        if (parent != null && (paramVariants = parent.listFiles(new PrefixFileFilter(rfsFile))) != null) {
            for (int v = 0; v < paramVariants.length; ++v) {
                this.deleteFile(paramVariants[v], vfsName);
            }
        }
    }

    protected void scrubResource(CmsObject cms, CmsPublishedResource res, Set scrubbedFolders, Set scrubbedFiles) {
        String resPath = cms.getRequestContext().removeSiteRoot(res.getRootPath());
        List siblings = this.getSiblingsList(cms, resPath);
        Iterator itSibs = siblings.iterator();
        while (itSibs.hasNext()) {
            String vfsName = (String)itSibs.next();
            String rfsName = OpenCms.getStaticExportManager().getRfsName(cms, vfsName);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_CHECKING_STATIC_EXPORT_2", vfsName, rfsName));
            }
            if (!rfsName.startsWith(OpenCms.getStaticExportManager().getRfsPrefix(vfsName)) || scrubbedFiles.contains(rfsName) || scrubbedFolders.contains(CmsResource.getFolderPath(rfsName))) continue;
            if (res.isFolder()) {
                block10: {
                    if (res.getState().isDeleted()) {
                        String exportFolderName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
                        try {
                            File exportFolder = new File(exportFolderName);
                            if (exportFolder.exists() && exportFolder.canWrite()) {
                                CmsFileUtil.purgeDirectory(exportFolder);
                                if (LOG.isInfoEnabled()) {
                                    LOG.info((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETED_1", exportFolderName));
                                }
                                scrubbedFolders.add(rfsName);
                                continue;
                            }
                        }
                        catch (Throwable t) {
                            if (!LOG.isWarnEnabled()) break block10;
                            LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_2", vfsName, exportFolderName));
                        }
                    }
                }
                rfsName = rfsName + "index_export.html";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_FOLDER_1", rfsName));
                }
            }
            String rfsExportFileName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName.substring(OpenCms.getStaticExportManager().getRfsPrefix(vfsName).length()));
            this.purgeFile(rfsExportFileName, vfsName);
            scrubbedFiles.add(rfsName);
            List fileList = this.getRelatedFilesToPurge(rfsExportFileName, vfsName);
            Iterator iter = fileList.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                this.purgeFile(file.getAbsolutePath(), vfsName);
                rfsName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getRfsPrefix(vfsName) + "/" + file.getAbsolutePath().substring(OpenCms.getStaticExportManager().getExportPath(vfsName).length()));
                rfsName = CmsStringUtil.substitute(rfsName, new String(new char[]{File.separatorChar}), "/");
                scrubbedFiles.add(rfsName);
            }
        }
    }

    private void deleteFile(File file, String vfsName) {
        block4: {
            try {
                if (file.exists() && file.canWrite()) {
                    file.delete();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_FILE_DELETED_1", this.getRfsName(file, vfsName)));
                    }
                }
            }
            catch (Throwable t) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn((Object)Messages.get().getBundle().key("LOG_FILE_DELETION_FAILED_1", this.getRfsName(file, vfsName)), t);
            }
        }
    }

    private String getRfsName(File file, String vfsName) {
        String filePath = file.getAbsolutePath();
        String result = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getRfsPrefix(vfsName) + filePath.substring(OpenCms.getStaticExportManager().getExportPath(vfsName).length()));
        return CmsStringUtil.substitute(result, new String(new char[]{File.separatorChar}), "/");
    }

    private static class PrefixFileFilter
    implements FileFilter {
        private String m_baseExtension;
        private String m_baseName;

        public PrefixFileFilter(File baseFile) {
            String fileName = baseFile.getName();
            this.m_baseExtension = CmsFileUtil.getExtension(fileName);
            this.m_baseName = fileName + "_";
        }

        public boolean accept(File f) {
            return f.getName().startsWith(this.m_baseName) && f.getName().endsWith(this.m_baseExtension);
        }
    }
}

