/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultLinkSubstitutionHandler
implements I_CmsLinkSubstitutionHandler {
    private static final Log LOG = CmsLog.getLog(CmsDefaultLinkSubstitutionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLink(CmsObject cms, String link, String siteRoot, boolean forceSecure) {
        String parameters;
        String vfsName;
        if (CmsStringUtil.isEmpty(link)) {
            return "";
        }
        String absoluteLink = CmsLinkManager.getAbsoluteUri(link, cms.getRequestContext().getUri());
        int pos = absoluteLink.indexOf(63);
        if (pos >= 0) {
            vfsName = absoluteLink.substring(0, pos);
            parameters = absoluteLink.substring(pos);
        } else {
            vfsName = absoluteLink;
            parameters = null;
        }
        String resultLink = null;
        String uriBaseName = null;
        boolean useRelativeLinks = false;
        CmsSite currentSite = OpenCms.getSiteManager().getCurrentSite(cms);
        CmsSite targetSite = null;
        if (CmsStringUtil.isNotEmpty(siteRoot)) {
            targetSite = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
        }
        if (targetSite == null) {
            targetSite = currentSite;
        }
        String serverPrefix = targetSite != currentSite ? targetSite.getUrl() : "";
        if (cms.getRequestContext().currentProject().isOnlineProject()) {
            CmsStaticExportManager exportManager = OpenCms.getStaticExportManager();
            if (exportManager.relativeLinksInExport(cms.getRequestContext().getSiteRoot() + cms.getRequestContext().getUri())) {
                uriBaseName = exportManager.getCachedOnlineLink(exportManager.getCacheKey(cms.getRequestContext().getSiteRoot(), cms.getRequestContext().getUri()));
                if (uriBaseName == null) {
                    uriBaseName = exportManager.isExportLink(cms, cms.getRequestContext().getUri()) ? exportManager.getRfsName(cms, cms.getRequestContext().getUri()) : exportManager.getVfsPrefix() + cms.getRequestContext().getUri();
                    exportManager.cacheOnlineLink(exportManager.getCacheKey(cms.getRequestContext().getSiteRoot(), cms.getRequestContext().getUri()), uriBaseName);
                }
                useRelativeLinks = uriBaseName.startsWith(OpenCms.getStaticExportManager().getRfsPrefix(cms.getRequestContext().getSiteRoot() + cms.getRequestContext().getUri()));
            }
            if ((resultLink = exportManager.getCachedOnlineLink(cms.getRequestContext().getSiteRoot() + ":" + absoluteLink)) == null) {
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot(targetSite.getSiteRoot());
                    if (exportManager.isExportLink(cms, vfsName)) {
                        resultLink = exportManager.getRfsName(cms, vfsName, parameters);
                        parameters = null;
                    } else {
                        resultLink = exportManager.getVfsPrefix().concat(vfsName);
                        if (parameters != null) {
                            resultLink = resultLink.concat(parameters);
                        }
                    }
                }
                finally {
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                }
                exportManager.cacheOnlineLink(cms.getRequestContext().getSiteRoot() + ":" + absoluteLink, resultLink);
            }
            if ((targetSite.hasSecureServer() || currentSite.hasSecureServer()) && !vfsName.startsWith("/system/")) {
                int linkType;
                block28: {
                    linkType = -1;
                    try {
                        linkType = cms.readResource(vfsName).getTypeId();
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block28;
                        String message = Messages.get().getBundle().key("LOG_RESOURCE_ACESS_ERROR_3", vfsName, cms.getRequestContext().currentUser().getName(), cms.getRequestContext().getSiteRoot());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)message, (Throwable)e);
                        }
                        LOG.info((Object)message);
                    }
                }
                if (linkType != CmsResourceTypeImage.getStaticTypeId()) {
                    boolean secureLink = exportManager.isSecureLink(cms, vfsName, targetSite.getSiteRoot());
                    boolean secureRequest = exportManager.isSecureLink(cms, cms.getRequestContext().getUri());
                    if (secureLink && (forceSecure || !secureRequest)) {
                        serverPrefix = targetSite.getSecureUrl();
                    } else if (!secureLink && secureRequest) {
                        serverPrefix = targetSite.getUrl();
                    }
                }
            }
            if (useRelativeLinks && CmsStringUtil.isEmpty(serverPrefix)) {
                resultLink = CmsLinkManager.getRelativeUri(uriBaseName, resultLink);
            }
        } else {
            if (OpenCms.getRunLevel() >= 3) {
                resultLink = OpenCms.getStaticExportManager().getVfsPrefix().concat(vfsName);
            }
            if (parameters != null && resultLink != null) {
                resultLink = resultLink.concat(parameters);
            }
        }
        return serverPrefix.concat(resultLink);
    }

    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        String query;
        String fragment;
        String path;
        URI uri;
        if (cms == null) {
            return targetUri;
        }
        try {
            uri = new URI(targetUri);
            path = uri.getPath();
            fragment = uri.getFragment();
            fragment = fragment != null ? "#" + fragment : "";
            query = uri.getQuery();
            query = query != null ? "?" + query : "";
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_MALFORMED_URI_1", targetUri), (Throwable)e);
            }
            return null;
        }
        String suffix = fragment.concat(query);
        if (uri.isOpaque()) {
            return null;
        }
        if (uri.isAbsolute()) {
            CmsSiteMatcher matcher = new CmsSiteMatcher(targetUri);
            if (OpenCms.getSiteManager().isMatching(matcher)) {
                if (path.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                    path = path.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                }
                if (OpenCms.getSiteManager().isWorkplaceRequest(matcher)) {
                    return cms.getRequestContext().addSiteRoot(path + suffix);
                }
                return cms.getRequestContext().addSiteRoot(OpenCms.getSiteManager().matchSite(matcher).getSiteRoot(), path + suffix);
            }
            return null;
        }
        String context = OpenCms.getSystemInfo().getOpenCmsContext();
        if (context != null && path.startsWith(context)) {
            String siteRoot = null;
            if (basePath != null) {
                siteRoot = OpenCms.getSiteManager().getSiteRoot(basePath);
            }
            path = path.substring(context.length());
            if (siteRoot != null) {
                if (!path.startsWith(siteRoot)) {
                    return cms.getRequestContext().addSiteRoot(siteRoot, path + suffix);
                }
                return path + suffix;
            }
            return cms.getRequestContext().addSiteRoot(path + suffix);
        }
        if (CmsStringUtil.isNotEmpty(path) && path.charAt(0) != '/') {
            if (basePath != null) {
                int pos = path.indexOf("../../galleries/pics/");
                if (pos >= 0) {
                    return "/system/" + path.substring(pos + 6) + suffix;
                }
                String absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().addSiteRoot(basePath));
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
                absolutePath = CmsLinkManager.getAbsoluteUri(path, cms.getRequestContext().getSiteRoot() + "/system/workplace/editors/" + "xmlcontent/");
                if (OpenCms.getSiteManager().getSiteRoot(absolutePath) != null) {
                    return absolutePath + suffix;
                }
            }
            return null;
        }
        if (CmsStringUtil.isNotEmpty(path)) {
            return cms.getRequestContext().addSiteRoot(path) + suffix;
        }
        return suffix;
    }
}

