/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.i18n.CmsAcceptLanguageHeaderParser;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsSecurityException;
import org.opencms.staticexport.CmsAfterPublishStaticExportHandler;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.CmsExportFolderMatcher;
import org.opencms.staticexport.CmsOnDemandStaticExportHandler;
import org.opencms.staticexport.CmsStaticExportData;
import org.opencms.staticexport.CmsStaticExportException;
import org.opencms.staticexport.CmsStaticExportExportRule;
import org.opencms.staticexport.CmsStaticExportResponseWrapper;
import org.opencms.staticexport.CmsStaticExportRfsRule;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.staticexport.I_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsStaticExportManager
implements I_CmsEventListener {
    public static final String EXPORT_ATTRIBUTE_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String EXPORT_ATTRIBUTE_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String EXPORT_ATTRIBUTE_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String EXPORT_ATTRIBUTE_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String EXPORT_BACKUP_FOLDER_NAME = "backup";
    public static final Integer EXPORT_DEFAULT_BACKUPS = new Integer(0);
    public static final String EXPORT_DEFAULT_FILE = "index_export.html";
    public static final String EXPORT_DEFAULT_WORKPATH = CmsSystemInfo.FOLDER_WEBINF + "temp";
    public static final int EXPORT_LINK_WITH_PARAMETER = 2;
    public static final int EXPORT_LINK_WITHOUT_PARAMETER = 1;
    public static final String EXPORT_MARKER = "exporturi";
    public static final int HANDLER_FINISH_TIME = 60;
    private static final String CACHEVALUE_404 = "?404";
    private static final Log LOG = CmsLog.getLog(CmsStaticExportManager.class);
    private String m_acceptCharsetHeader;
    private String m_acceptLanguageHeader;
    private Map m_cacheExportLinks;
    private Map m_cacheExportUris;
    private Map m_cacheOnlineLinks;
    private Map m_cacheSecureLinks;
    private String m_defaultAcceptCharsetHeader;
    private String m_defaultAcceptLanguageHeader;
    private CmsExportFolderMatcher m_exportFolderMatcher;
    private List m_exportFolders;
    private List m_exportHeaders;
    private Map m_exportnameResources;
    private boolean m_exportPropertyDefault;
    private boolean m_exportRelativeLinks;
    private List m_exportRules;
    private List m_exportSuffixes;
    private CmsStaticExportExportRule m_exportTmpRule;
    private String m_exportUrl;
    private String m_exportUrlConfigured;
    private String m_exportUrlPrefix;
    private boolean m_fullStaticExport = false;
    private I_CmsStaticExportHandler m_handler;
    private I_CmsLinkSubstitutionHandler m_linkSubstitutionHandler;
    private Object m_lockCmsEvent = new Object();
    private Object m_lockScrubExportFolders = new Object();
    private Object m_lockSetExportnames = new Object();
    private boolean m_quickPlainExport;
    private String m_remoteAddr;
    private String m_rfsPrefix;
    private String m_rfsPrefixConfigured;
    private List m_rfsRules;
    private CmsStaticExportRfsRule m_rfsTmpRule;
    private Integer m_staticExportBackups;
    private boolean m_staticExportEnabled;
    private String m_staticExportPath;
    private String m_staticExportPathConfigured;
    private String m_staticExportWorkPath;
    private String m_staticExportWorkPathConfigured;
    private String m_testResource;
    private boolean m_useTempDirs = true;
    private String m_vfsPrefix;
    private String m_vfsPrefixConfigured;

    public CmsStaticExportManager() {
        this.m_exportSuffixes = new ArrayList();
        this.m_exportFolders = new ArrayList();
        this.m_exportHeaders = new ArrayList();
        this.m_rfsRules = new ArrayList();
        this.m_exportRules = new ArrayList();
        this.m_exportTmpRule = new CmsStaticExportExportRule("", "");
        this.m_rfsTmpRule = new CmsStaticExportRfsRule("", "", "", "", "", "", null, null);
    }

    public void addExportRule(String name, String description) {
        this.m_exportRules.add(new CmsStaticExportExportRule(name, description, this.m_exportTmpRule.getModifiedResources(), this.m_exportTmpRule.getExportResourcePatterns()));
        this.m_exportTmpRule = new CmsStaticExportExportRule("", "");
    }

    public void addExportRuleRegex(String regex) {
        this.m_exportTmpRule.addModifiedResource(regex);
    }

    public void addExportRuleUri(String exportUri) {
        this.m_exportTmpRule.addExportResourcePattern(exportUri);
    }

    public void addRfsRule(String name, String description, String source, String rfsPrefix, String exportPath, String exportWorkPath, String exportBackups, String useRelativeLinks) {
        if (this.m_staticExportPathConfigured != null && exportPath.equals(this.m_staticExportPathConfigured)) {
            this.m_useTempDirs = false;
        }
        Iterator itRules = this.m_rfsRules.iterator();
        while (this.m_useTempDirs && itRules.hasNext()) {
            CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)itRules.next();
            if (!exportPath.equals(rule.getExportPathConfigured())) continue;
            this.m_useTempDirs = false;
        }
        Boolean relativeLinks = useRelativeLinks == null ? null : Boolean.valueOf(useRelativeLinks);
        Integer backups = exportBackups == null ? null : Integer.valueOf(exportBackups);
        this.m_rfsRules.add(new CmsStaticExportRfsRule(name, description, source, rfsPrefix, exportPath, exportWorkPath, backups, relativeLinks, this.m_rfsTmpRule.getRelatedSystemResources()));
        this.m_rfsTmpRule = new CmsStaticExportRfsRule("", "", "", "", "", "", null, null);
    }

    public void addRfsRuleSystemRes(String regex) {
        this.m_rfsTmpRule.addRelatedSystemRes(regex);
    }

    public void cacheExportUri(String rfsName, String vfsName, String parameters) {
        this.m_cacheExportUris.put(rfsName, new CmsStaticExportData(vfsName, parameters));
    }

    public void cacheOnlineLink(Object linkName, Object vfsName) {
        this.m_cacheOnlineLinks.put(linkName, vfsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cmsEvent(CmsEvent event) {
        if (!this.isStaticExportEnabled()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORT_DISABLED_0"));
            }
            return;
        }
        I_CmsReport report = null;
        Map data = event.getData();
        if (data != null) {
            report = (I_CmsReport)data.get("report");
        }
        if (report == null) {
            report = new CmsLogReport(CmsLocaleManager.getDefaultLocale(), this.getClass());
        }
        switch (event.getType()) {
            case 19: {
                this.scrubExportFolders(report);
                this.clearCaches(event);
                break;
            }
            case 2: {
                if (data == null) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_EMPTY_EVENT_DATA_0"));
                    }
                    return;
                }
                CmsUUID publishHistoryId = new CmsUUID((String)data.get("publishHistoryId"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_1", publishHistoryId));
                }
                Object object = this.m_lockCmsEvent;
                synchronized (object) {
                    this.getHandler().performEventPublishProject(publishHistoryId, report);
                }
                this.clearCaches(event);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EVENT_PUBLISH_PROJECT_FINISHED_1", publishHistoryId));
                break;
            }
            case 5: {
                this.clearCaches(event);
                break;
            }
        }
    }

    public int export(HttpServletRequest req, HttpServletResponse res, CmsObject cms, CmsStaticExportData data) throws CmsException, IOException, ServletException, CmsStaticExportException {
        CmsFile file;
        String vfsName = data.getVfsName();
        String rfsName = data.getRfsName();
        CmsResource resource = data.getResource();
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(vfsName);
        CmsI18nInfo i18nInfo = OpenCms.getLocaleManager().getI18nInfo(req, cms.getRequestContext().currentUser(), cms.getRequestContext().currentProject(), vfsName);
        String remoteAddr = this.m_remoteAddr;
        if (remoteAddr == null) {
            remoteAddr = "127.0.0.1";
        }
        CmsContextInfo contextInfo = new CmsContextInfo(cms.getRequestContext().currentUser(), cms.getRequestContext().currentProject(), vfsName, "/", i18nInfo.getLocale(), i18nInfo.getEncoding(), remoteAddr, -1L, cms.getRequestContext().getOuFqn());
        cms = OpenCms.initCmsObject(null, contextInfo);
        if (siteRoot != null) {
            vfsName = vfsName.substring(siteRoot.length());
        } else {
            siteRoot = "/";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORT_SITE_ROOT_2", siteRoot, vfsName));
        }
        cms.getRequestContext().setSiteRoot(siteRoot);
        String oldUri = null;
        boolean exportOnDemand = req != null && res != null;
        CmsStaticExportResponseWrapper wrapRes = null;
        if (res != null) {
            wrapRes = new CmsStaticExportResponseWrapper(res);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SE_RESOURCE_START_1", data));
        }
        if (resource.isFile()) {
            file = cms.readFile(vfsName);
        } else {
            file = cms.readFile(OpenCms.initResource(cms, vfsName, req, (HttpServletResponse)wrapRes));
            if (cms.existsResource(vfsName + file.getName())) {
                vfsName = vfsName + file.getName();
            }
            rfsName = rfsName + EXPORT_DEFAULT_FILE;
        }
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(file);
        if (loader == null || !loader.isStaticExportEnabled()) {
            Object[] arguments = new Object[]{vfsName, new Integer(file.getTypeId())};
            throw new CmsStaticExportException(Messages.get().container("ERR_EXPORT_NOT_SUPPORTED_2", arguments));
        }
        if (exportOnDemand) {
            String mimetype = OpenCms.getResourceManager().getMimeType(file.getName(), cms.getRequestContext().getEncoding());
            if (wrapRes != null) {
                wrapRes.setContentType(mimetype);
            }
            oldUri = cms.getRequestContext().getUri();
            cms.getRequestContext().setUri(vfsName);
        }
        int status = -1;
        if (this.isExportLink(cms, vfsName)) {
            CmsLocaleManager locManager = OpenCms.getLocaleManager();
            List locales = locManager.getDefaultLocales(cms, vfsName);
            boolean exported = false;
            boolean matched = false;
            Iterator it = this.getRfsRules().iterator();
            while (it.hasNext()) {
                byte[] content;
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                boolean export = rule.getSource().matcher(siteRoot + vfsName).matches();
                matched |= export;
                if (!(export |= vfsName.startsWith("/system/") && rule.match(vfsName))) continue;
                CmsObject locCms = cms;
                Locale locale = CmsLocaleManager.getLocale(rule.getName());
                if (locales.contains(locale)) {
                    CmsContextInfo ctxInfo = new CmsContextInfo(cms.getRequestContext());
                    ctxInfo.setLocale(locale);
                    locCms = OpenCms.initCmsObject(cms, ctxInfo);
                }
                if ((content = loader.export(locCms, file, req, (HttpServletResponse)wrapRes)) == null) continue;
                exported = true;
                String locRfsName = rfsName;
                if (locales.contains(locale)) {
                    locRfsName = rule.getLocalizedRfsName(rfsName, "/");
                }
                this.writeResource(req, rule.getExportPath(), locRfsName, resource, content);
            }
            if (!matched) {
                String exportPath = this.getExportPath(siteRoot + vfsName);
                byte[] content = loader.export(cms, file, req, (HttpServletResponse)wrapRes);
                if (content != null) {
                    exported = true;
                    this.writeResource(req, exportPath, rfsName, resource, content);
                }
            }
            if (exported) {
                int n = status = wrapRes != null ? wrapRes.getStatus() : -1;
                if (status < 0) {
                    status = 200;
                }
            } else {
                status = 304;
            }
        } else {
            status = 303;
        }
        if (exportOnDemand) {
            cms.getRequestContext().setUri(oldUri);
        }
        return status;
    }

    public synchronized void exportFullStaticRender(boolean purgeFirst, I_CmsReport report) throws CmsException, IOException, ServletException {
        this.m_fullStaticExport = true;
        String staticExportPathStore = this.m_staticExportPath;
        if (this.m_useTempDirs) {
            this.m_staticExportPath = this.m_staticExportWorkPath;
        }
        if (purgeFirst) {
            HashMap<String, I_CmsReport> eventData = new HashMap<String, I_CmsReport>();
            eventData.put("report", report);
            CmsEvent clearCacheEvent = new CmsEvent(5, eventData);
            OpenCms.fireCmsEvent(clearCacheEvent);
            this.scrubExportFolders(report);
            CmsObject cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            cms.deleteAllStaticExportPublishedResources(1);
            cms.deleteAllStaticExportPublishedResources(2);
        }
        CmsAfterPublishStaticExportHandler handler = new CmsAfterPublishStaticExportHandler();
        handler.doExportAfterPublish(null, report);
        this.m_staticExportPath = staticExportPathStore;
        this.m_fullStaticExport = false;
        if (this.m_useTempDirs && !report.hasError()) {
            File staticExport = new File(this.m_staticExportPath);
            this.createExportBackupFolders(staticExport, this.m_staticExportPath, this.getExportBackups(), null);
            File staticExportWork = new File(this.m_staticExportWorkPath);
            staticExportWork.renameTo(new File(this.m_staticExportPath));
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                File staticExportRule = new File(rule.getExportPath());
                File staticExportWorkRule = new File(rule.getExportWorkPath());
                if (!staticExportWorkRule.exists()) continue;
                this.createExportBackupFolders(staticExportRule, rule.getExportPath(), rule.getExportBackups(), OpenCms.getResourceManager().getFileTranslator().translateResource(rule.getName()));
                staticExportWorkRule.renameTo(new File(rule.getExportPath()));
            }
        } else if (report.hasError()) {
            report.println(Messages.get().container("ERR_EXPORT_NOT_SUCCESSFUL_0"), 1);
        }
    }

    public String getAcceptCharsetHeader() {
        return this.m_acceptCharsetHeader;
    }

    public String getAcceptLanguageHeader() {
        return this.m_acceptLanguageHeader;
    }

    public CmsStaticExportData getCachedExportUri(String rfsName) {
        return (CmsStaticExportData)this.m_cacheExportUris.get(rfsName);
    }

    public String getCachedOnlineLink(String vfsName) {
        return (String)this.m_cacheOnlineLinks.get(vfsName);
    }

    public String getCacheKey(String siteRoot, String uri) {
        return siteRoot + uri;
    }

    public String getDefault() {
        return String.valueOf(this.m_exportPropertyDefault);
    }

    public String getDefaultAcceptCharsetHeader() {
        return this.m_defaultAcceptCharsetHeader;
    }

    public String getDefaultAcceptLanguageHeader() {
        return this.m_defaultAcceptLanguageHeader;
    }

    public String getDefaultRfsPrefix() {
        return this.m_rfsPrefix;
    }

    public Integer getExportBackups() {
        if (this.m_staticExportBackups != null) {
            return this.m_staticExportBackups;
        }
        return EXPORT_DEFAULT_BACKUPS;
    }

    public CmsStaticExportData getExportData(HttpServletRequest request, CmsObject cms) {
        if (!this.isStaticExportEnabled()) {
            return null;
        }
        String rfsName = request.getParameter(EXPORT_MARKER);
        if (rfsName == null) {
            rfsName = (String)request.getAttribute(EXPORT_ATTRIBUTE_ERROR_REQUEST_URI);
        }
        if (request.getHeader("OpenCms-Export") != null) {
            int prefix;
            int n = prefix = rfsName.startsWith(this.getExportUrlPrefix()) ? this.getExportUrlPrefix().length() : 0;
            if (prefix > 0) {
                rfsName = rfsName.substring(prefix);
            } else {
                return null;
            }
        }
        if (!this.isValidRfsName(rfsName)) {
            return null;
        }
        return this.getExportData(rfsName, null, cms);
    }

    public CmsStaticExportData getExportData(String vfsName, CmsObject cms) {
        return this.getExportData(this.getRfsName(cms, vfsName), vfsName, cms);
    }

    public String getExportEnabled() {
        return String.valueOf(this.m_staticExportEnabled);
    }

    public CmsExportFolderMatcher getExportFolderMatcher() {
        return this.m_exportFolderMatcher;
    }

    public List getExportFolderPatterns() {
        return Collections.unmodifiableList(this.m_exportFolders);
    }

    public List getExportHeaders() {
        return Collections.unmodifiableList(this.m_exportHeaders);
    }

    public Map getExportnames() {
        return this.m_exportnameResources;
    }

    public String getExportPath(String vfsName) {
        if (vfsName != null) {
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getExportPath();
            }
        }
        if (this.m_useTempDirs && this.isFullStaticExport()) {
            return this.getExportWorkPath();
        }
        return this.m_staticExportPath;
    }

    public String getExportPathForConfiguration() {
        return this.m_staticExportPathConfigured;
    }

    public boolean getExportPropertyDefault() {
        return this.m_exportPropertyDefault;
    }

    public List getExportRules() {
        return Collections.unmodifiableList(this.m_exportRules);
    }

    public List getExportSuffixes() {
        return this.m_exportSuffixes;
    }

    public String getExportUrl() {
        return this.m_exportUrl;
    }

    public String getExportUrlForConfiguration() {
        return this.m_exportUrlConfigured;
    }

    public String getExportUrlPrefix() {
        return this.m_exportUrlPrefix;
    }

    public String getExportWorkPath() {
        return this.m_staticExportWorkPath;
    }

    public String getExportWorkPathForConfiguration() {
        if (this.m_staticExportWorkPathConfigured != null) {
            return this.m_staticExportWorkPathConfigured;
        }
        return EXPORT_DEFAULT_WORKPATH;
    }

    public I_CmsStaticExportHandler getHandler() {
        if (this.m_handler == null) {
            this.setHandler(CmsOnDemandStaticExportHandler.class.getName());
        }
        return this.m_handler;
    }

    public I_CmsLinkSubstitutionHandler getLinkSubstitutionHandler() {
        if (this.m_linkSubstitutionHandler == null) {
            this.setLinkSubstitutionHandler(CmsDefaultLinkSubstitutionHandler.class.getName());
        }
        return this.m_linkSubstitutionHandler;
    }

    public String getPlainExportOptimization() {
        return String.valueOf(this.m_quickPlainExport);
    }

    public boolean getQuickPlainExport() {
        return this.m_quickPlainExport;
    }

    public String getRelativeLinks() {
        return String.valueOf(this.m_exportRelativeLinks);
    }

    public String getRemoteAddr() {
        return this.m_remoteAddr;
    }

    public String getRemoteAddress() {
        return this.m_remoteAddr;
    }

    public String getRfsName(CmsObject cms, String vfsName) {
        return this.getRfsName(cms, vfsName, null);
    }

    public String getRfsName(CmsObject cms, String vfsName, String parameters) {
        String rfsName = vfsName;
        try {
            CmsProperty exportNameProperty = cms.readPropertyObject(CmsResource.getFolderPath(rfsName), "exportname", true);
            if (exportNameProperty.isNullProperty()) {
                rfsName = cms.getRequestContext().addSiteRoot(rfsName);
            } else {
                boolean cont;
                String exportname = exportNameProperty.getValue();
                if (exportname.charAt(0) != '/') {
                    exportname = '/' + exportname;
                }
                if (exportname.charAt(exportname.length() - 1) != '/') {
                    exportname = exportname + '/';
                }
                String value = null;
                String resourceName = rfsName;
                do {
                    try {
                        CmsProperty prop = cms.readPropertyObject(resourceName, "exportname", false);
                        if (prop.isIdentical(exportNameProperty)) {
                            value = prop.getValue();
                        }
                        cont = value == null && resourceName.length() > 1;
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        cont = resourceName.length() > 1;
                    }
                    catch (CmsSecurityException se) {
                        cont = false;
                    }
                    if (!cont) continue;
                    resourceName = CmsResource.getParentFolder(resourceName);
                } while (cont);
                rfsName = exportname + rfsName.substring(resourceName.length());
            }
            String extension = CmsFileUtil.getExtension(rfsName);
            boolean isJsp = extension.equals(".jsp");
            if (isJsp) {
                String suffix = null;
                try {
                    CmsResource res = cms.readResource(vfsName);
                    boolean bl = isJsp = res.getTypeId() == CmsResourceTypeJsp.getStaticTypeId();
                    if (isJsp) {
                        suffix = cms.readPropertyObject(vfsName, "exportsuffix", true).getValue(".html");
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    File rfsFile = new File(CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(vfsName) + rfsName));
                    File parent = rfsFile.getParentFile();
                    if (parent != null) {
                        File[] paramVariants = parent.listFiles(new CmsPrefixFileFilter(rfsFile.getName()));
                        if (paramVariants != null && paramVariants.length > 0) {
                            suffix = paramVariants[0].getAbsolutePath().substring(rfsFile.getAbsolutePath().length());
                        }
                    }
                    suffix = ".html";
                }
                if (suffix != null && !extension.equals(suffix.toLowerCase())) {
                    rfsName = rfsName + suffix;
                    extension = suffix;
                }
            }
            if (parameters != null) {
                rfsName = CmsFileUtil.getRfsPath(rfsName, extension, parameters);
                try {
                    cms.writeStaticExportPublishedResource(rfsName, 2, parameters, System.currentTimeMillis());
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_WRITE_FAILED_1", rfsName), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            rfsName = vfsName;
        }
        if (!vfsName.startsWith("/system/")) {
            return this.getRfsPrefix(cms.getRequestContext().addSiteRoot(vfsName)).concat(rfsName);
        }
        String source = cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri());
        Iterator it = this.m_rfsRules.iterator();
        while (it.hasNext()) {
            CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
            if (!rule.getSource().matcher(source).matches() || !rule.match(vfsName)) continue;
            return rule.getRfsPrefix().concat(rfsName);
        }
        return this.getRfsPrefix(cms.getRequestContext().getSiteRoot() + "/").concat(rfsName);
    }

    public String getRfsPrefix(String vfsName) {
        if (vfsName != null) {
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getRfsPrefix();
            }
        }
        return this.m_rfsPrefix;
    }

    public String getRfsPrefixForConfiguration() {
        return this.m_rfsPrefixConfigured;
    }

    public List getRfsRules() {
        return Collections.unmodifiableList(this.m_rfsRules);
    }

    public String getTestResource() {
        return this.m_testResource;
    }

    public String getVfsName(CmsObject cms, String rfsName) {
        CmsStaticExportData data = this.getExportData(rfsName, null, cms);
        if (data != null) {
            String result = data.getVfsName();
            if (result != null && result.startsWith(cms.getRequestContext().getSiteRoot())) {
                result = result.substring(cms.getRequestContext().getSiteRoot().length());
            }
            return result;
        }
        return null;
    }

    public String getVfsPrefix() {
        return this.m_vfsPrefix;
    }

    public String getVfsPrefixForConfiguration() {
        return this.m_vfsPrefixConfigured;
    }

    public void initialize(CmsObject cms) {
        int pos2;
        this.m_staticExportPath = this.normalizeExportPath(this.m_staticExportPathConfigured);
        this.m_staticExportWorkPath = this.normalizeExportPath(this.getExportWorkPathForConfiguration());
        if (this.m_staticExportPath.equals(OpenCms.getSystemInfo().getWebApplicationRfsPath())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_EXPORT_PATH_0"));
        }
        this.m_rfsPrefix = this.normalizeRfsPrefix(this.m_rfsPrefixConfigured);
        Iterator itRfsRules = this.m_rfsRules.iterator();
        while (itRfsRules.hasNext()) {
            CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)itRfsRules.next();
            try {
                rule.setExportPath(this.normalizeExportPath(rule.getExportPathConfigured()));
            }
            catch (CmsIllegalArgumentException e) {
                CmsLog.INIT.warn((Object)e.getMessageContainer());
                rule.setExportPath(this.m_staticExportPath);
            }
            try {
                rule.setExportWorkPath(this.normalizeExportPath(rule.getExportWorkPathConfigured()));
            }
            catch (CmsIllegalArgumentException e) {
                CmsLog.INIT.warn((Object)e.getMessageContainer());
                rule.setExportWorkPath(this.m_staticExportWorkPath);
            }
            rule.setRfsPrefix(this.normalizeRfsPrefix(rule.getRfsPrefixConfigured()));
        }
        this.m_vfsPrefix = this.insertContextStrings(this.m_vfsPrefixConfigured);
        this.m_vfsPrefix = CmsFileUtil.normalizePath(this.m_vfsPrefix, '/');
        if (CmsResource.isFolder(this.m_vfsPrefix)) {
            this.m_vfsPrefix = this.m_vfsPrefix.substring(0, this.m_vfsPrefix.length() - 1);
        }
        if (CmsLog.INIT.isDebugEnabled()) {
            if (cms != null) {
                CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_SE_MANAGER_CREATED_1", cms));
            } else {
                CmsLog.INIT.debug((Object)Messages.get().getBundle().key("INIT_SE_MANAGER_CREATED_0"));
            }
        }
        LRUMap lruMap1 = new LRUMap(2048);
        this.m_cacheOnlineLinks = Collections.synchronizedMap(lruMap1);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheOnlineLinks", lruMap1);
        LRUMap lruMap2 = new LRUMap(2048);
        this.m_cacheExportUris = Collections.synchronizedMap(lruMap2);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheExportUris", lruMap2);
        LRUMap lruMap3 = new LRUMap(2048);
        this.m_cacheSecureLinks = Collections.synchronizedMap(lruMap3);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheSecureLinks", lruMap3);
        LRUMap lruMap4 = new LRUMap(2048);
        this.m_cacheExportLinks = Collections.synchronizedMap(lruMap4);
        OpenCms.getMemoryMonitor().register(this.getClass().getName() + ".m_cacheExportLinks", lruMap4);
        OpenCms.addCmsEventListener(this, new int[]{2, 5, 19});
        this.m_exportFolderMatcher = new CmsExportFolderMatcher(this.m_exportFolders, this.m_testResource);
        this.setExportnames();
        this.m_defaultAcceptLanguageHeader = CmsAcceptLanguageHeaderParser.createLanguageHeader();
        this.m_defaultAcceptCharsetHeader = OpenCms.getSystemInfo().getDefaultEncoding();
        int pos = this.m_exportUrl.indexOf("://");
        this.m_exportUrlPrefix = pos > 0 ? ((pos2 = this.m_exportUrl.indexOf(47, pos + 3)) > 0 ? this.m_exportUrl.substring(pos2) : "") : this.m_exportUrl;
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.isStaticExportEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_ENABLED_0"));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_DEFAULT_1", (Object)this.getExportPropertyDefault()));
                itRfsRules = this.m_rfsRules.iterator();
                while (itRfsRules.hasNext()) {
                    CmsStaticExportRfsRule rfsRule = (CmsStaticExportRfsRule)itRfsRules.next();
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_EXPORT_PATH_2", rfsRule.getSource(), rfsRule.getExportPath()));
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RFS_PREFIX_2", rfsRule.getSource(), rfsRule.getRfsPrefix()));
                    if (rfsRule.getUseRelativeLinks() == null) continue;
                    if (rfsRule.getUseRelativeLinks().booleanValue()) {
                        CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RELATIVE_LINKS_1", rfsRule.getSource()));
                        continue;
                    }
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_ABSOLUTE_LINKS_1", rfsRule.getSource()));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_EXPORT_PATH_2", "/", this.m_staticExportPath));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RFS_PREFIX_2", "/", this.m_rfsPrefix));
                if (this.m_exportRelativeLinks) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_RELATIVE_LINKS_1", "/"));
                } else {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_RFS_RULE_ABSOLUTE_LINKS_1", "/"));
                }
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_VFS_PREFIX_1", this.getVfsPrefix()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_EXPORT_HANDLER_1", this.getHandler().getClass().getName()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_URL_1", this.getExportUrl()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_OPTIMIZATION_1", this.getPlainExportOptimization()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_TESTRESOURCE_1", this.getTestResource()));
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LINKSUBSTITUTION_HANDLER_1", this.getLinkSubstitutionHandler().getClass().getName()));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_DISABLED_0"));
            }
        }
    }

    public boolean isExportLink(CmsObject cms, String vfsName) {
        boolean result = false;
        if (this.isStaticExportEnabled()) {
            Boolean exportResource = (Boolean)this.m_cacheExportLinks.get(this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName));
            if (exportResource == null) {
                try {
                    CmsObject exportCms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
                    exportCms.getRequestContext().setSiteRoot(cms.getRequestContext().getSiteRoot());
                    String exportValue = exportCms.readPropertyObject(vfsName, "export", true).getValue();
                    result = exportValue == null ? (this.getExportPropertyDefault() ? true : this.isSuffixExportable(vfsName)) : Boolean.valueOf(exportValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.m_cacheExportLinks.put(this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName), result);
            } else {
                result = exportResource;
            }
        }
        return result;
    }

    public boolean isFullStaticExport() {
        return this.m_fullStaticExport;
    }

    public boolean isSecureLink(CmsObject cms, String vfsName) {
        if (!cms.getRequestContext().currentProject().isOnlineProject()) {
            return false;
        }
        Boolean secureResource = (Boolean)this.m_cacheSecureLinks.get(this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName));
        if (secureResource == null) {
            try {
                String secureProp = cms.readPropertyObject(vfsName, "secure", true).getValue();
                secureResource = Boolean.valueOf(secureProp);
                this.m_cacheSecureLinks.put(this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName), secureResource);
            }
            catch (CmsVfsResourceNotFoundException e) {
                secureResource = Boolean.FALSE;
                this.m_cacheSecureLinks.put(this.getCacheKey(cms.getRequestContext().getSiteRoot(), vfsName), secureResource);
            }
            catch (Exception e) {
                secureResource = Boolean.FALSE;
            }
        }
        return secureResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecureLink(CmsObject cms, String vfsName, String siteRoot) {
        if (siteRoot == null) {
            return this.isSecureLink(cms, vfsName);
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot(siteRoot);
            boolean bl = this.isSecureLink(cms, vfsName);
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    public boolean isStaticExportEnabled() {
        return this.m_staticExportEnabled;
    }

    public boolean isSuffixExportable(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        int pos = resourceName.lastIndexOf(46);
        if (pos >= 0) {
            String suffix = resourceName.substring(pos).toLowerCase();
            return this.m_exportSuffixes.contains(suffix);
        }
        return false;
    }

    public boolean isUseTempDir() {
        return this.m_useTempDirs;
    }

    public boolean relativeLinksInExport(String vfsName) {
        if (vfsName != null) {
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                if (!rule.getSource().matcher(vfsName).matches()) continue;
                return rule.getUseRelativeLinks() != null ? rule.getUseRelativeLinks() : this.m_exportRelativeLinks;
            }
        }
        return this.m_exportRelativeLinks;
    }

    public void setAcceptCharsetHeader(String value) {
        this.m_acceptCharsetHeader = value;
    }

    public void setAcceptLanguageHeader(String value) {
        this.m_acceptLanguageHeader = value;
    }

    public void setDefault(String value) {
        this.m_exportPropertyDefault = Boolean.valueOf(value);
    }

    public void setExportBackups(String backup) {
        this.m_staticExportBackups = new Integer(backup);
    }

    public void setExportEnabled(String value) {
        this.m_staticExportEnabled = Boolean.valueOf(value);
    }

    public void setExportFolderPattern(String folder) {
        this.m_exportFolders.add(folder);
    }

    public void setExportHeader(String exportHeader) {
        if (CmsStringUtil.splitAsArray(exportHeader, ':').length == 2) {
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_EXPORT_HEADERS_1", exportHeader));
            }
            this.m_exportHeaders.add(exportHeader);
        } else if (CmsLog.INIT.isWarnEnabled()) {
            CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_INVALID_HEADER_1", exportHeader));
        }
    }

    public void setExportPath(String path) {
        this.m_staticExportPathConfigured = path;
    }

    public void setExportSuffix(String suffix) {
        this.m_exportSuffixes.add(suffix.toLowerCase());
    }

    public void setExportUrl(String url) {
        this.m_exportUrl = this.insertContextStrings(url);
        this.m_exportUrlConfigured = url;
    }

    public void setExportWorkPath(String path) {
        this.m_staticExportWorkPathConfigured = path;
    }

    public void setHandler(String handlerClassName) {
        try {
            this.m_handler = (I_CmsStaticExportHandler)Class.forName(handlerClassName).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setLinkSubstitutionHandler(String handlerClassName) {
        try {
            this.m_linkSubstitutionHandler = (I_CmsLinkSubstitutionHandler)Class.forName(handlerClassName).newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setPlainExportOptimization(String value) {
        this.m_quickPlainExport = Boolean.valueOf(value);
    }

    public void setRelativeLinks(String value) {
        this.m_exportRelativeLinks = Boolean.valueOf(value);
    }

    public void setRemoteAddr(String addr) {
        this.m_remoteAddr = addr;
    }

    public void setRfsPrefix(String rfsPrefix) {
        this.m_rfsPrefixConfigured = rfsPrefix;
    }

    public void setTestResource(String testResource) {
        this.m_testResource = testResource;
    }

    public void setVfsPrefix(String vfsPrefix) {
        this.m_vfsPrefixConfigured = vfsPrefix;
    }

    public synchronized void shutDown() {
        int count = 0;
        while (count < 60 && this.m_handler.isBusy()) {
            ++count;
            try {
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STATIC_EXPORT_SHUTDOWN_3", this.m_handler.getClass().getName(), String.valueOf(count), String.valueOf(60)));
                }
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                count = 60;
            }
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_1", this.getClass().getName()));
        }
    }

    protected void clearCaches(CmsEvent event) {
        this.m_cacheOnlineLinks.clear();
        this.m_cacheExportUris.clear();
        this.m_cacheSecureLinks.clear();
        this.m_cacheExportLinks.clear();
        this.setExportnames();
        if (LOG.isDebugEnabled()) {
            String eventType = "EVENT_CLEAR_CACHES";
            if (event.getType() != 5) {
                eventType = "EVENT_PUBLISH_PROJECT";
            }
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLUSHED_CACHES_1", eventType));
        }
    }

    protected void createExportBackupFolders(File staticExport, String exportPath, int exportBackups, String ruleBackupExtension) {
        if (staticExport.exists()) {
            String backupFolderName = exportPath.substring(0, exportPath.lastIndexOf(File.separator) + 1);
            backupFolderName = ruleBackupExtension != null ? backupFolderName + EXPORT_BACKUP_FOLDER_NAME + ruleBackupExtension : backupFolderName + EXPORT_BACKUP_FOLDER_NAME;
            for (int i = exportBackups; i > 0; --i) {
                File staticExportBackupOld = new File(backupFolderName + new Integer(i).toString());
                if (staticExportBackupOld.exists()) {
                    if (i + 1 > exportBackups) {
                        CmsFileUtil.purgeDirectory(staticExportBackupOld);
                    } else {
                        staticExportBackupOld.renameTo(new File(backupFolderName + new Integer(i + 1).toString()));
                    }
                }
                if (i != 1) continue;
                staticExport.renameTo(staticExportBackupOld);
            }
            if (exportBackups == 0) {
                CmsFileUtil.purgeDirectory(staticExport);
            }
        }
    }

    protected void createExportFolder(String exportPath, String rfsName) throws CmsException {
        String exportFolderName = CmsFileUtil.normalizePath(exportPath + CmsResource.getFolderPath(rfsName));
        File exportFolder = new File(exportFolderName);
        if (!exportFolder.exists() && !exportFolder.mkdirs()) {
            throw new CmsStaticExportException(Messages.get().container("ERR_CREATE_FOLDER_1", rfsName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmsStaticExportData getExportData(String rfsName, String vfsName, CmsObject cms) {
        CmsResource resource = null;
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            CmsStaticExportData cmsStaticExportData;
            CmsStaticExportData data;
            cms.getRequestContext().setSiteRoot("/");
            rfsName = rfsName.substring(this.getRfsPrefixForRfsName(rfsName).length());
            String parameters = null;
            if (vfsName == null && (data = this.getCachedExportUri(rfsName)) != null) {
                vfsName = data.getVfsName();
                parameters = data.getParameters();
            }
            if (vfsName != null) {
                CmsStaticExportData e2;
                if (CACHEVALUE_404 != vfsName) {
                    try {
                        resource = cms.readResource(vfsName);
                    }
                    catch (CmsException e2) {
                        CmsStaticExportData cmsStaticExportData2 = null;
                        cms.getRequestContext().setSiteRoot(storedSiteRoot);
                        return cmsStaticExportData2;
                    }
                    e2 = new CmsStaticExportData(vfsName, rfsName, resource, parameters);
                    return e2;
                }
                e2 = null;
                return e2;
            }
            vfsName = this.getVfsNameInternal(cms, rfsName);
            if (vfsName != null) {
                try {
                    resource = cms.readResource(vfsName);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (resource == null) {
                try {
                    String rfsBaseName;
                    String vfsBaseName;
                    parameters = cms.readStaticExportPublishedResourceParameters(rfsName);
                    if (CmsStringUtil.isNotEmpty(parameters) && (vfsBaseName = this.getVfsNameInternal(cms, rfsBaseName = rfsName.substring(0, rfsName.lastIndexOf(95)))) != null) {
                        resource = cms.readResource(vfsBaseName);
                        CmsStaticExportData exportData = new CmsStaticExportData(vfsBaseName, rfsName, resource, parameters);
                        this.cacheExportUri(rfsName, exportData.getVfsName(), parameters);
                        CmsStaticExportData cmsStaticExportData3 = exportData;
                        return cmsStaticExportData3;
                    }
                }
                catch (CmsException e) {
                    // empty catch block
                }
                this.cacheExportUri(rfsName, CACHEVALUE_404, null);
                cmsStaticExportData = null;
                return cmsStaticExportData;
            }
            this.cacheExportUri(rfsName, vfsName, null);
            cmsStaticExportData = new CmsStaticExportData(vfsName, rfsName, resource);
            return cmsStaticExportData;
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    protected String getRfsPrefixForRfsName(String rfsName) {
        String retVal = "";
        if (rfsName.startsWith(this.m_rfsPrefix + "/")) {
            retVal = this.m_rfsPrefix;
        }
        Iterator it = this.m_rfsRules.iterator();
        while (it.hasNext()) {
            CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
            String rfsPrefix = rule.getRfsPrefix();
            if (!rfsName.startsWith(rfsPrefix + "/") || retVal.length() >= rfsPrefix.length()) continue;
            retVal = rfsPrefix;
        }
        return retVal;
    }

    protected String getVfsNameInternal(CmsObject cms, String rfsName) {
        String extension;
        String cutName;
        int pos;
        int extPos;
        CmsResource resource;
        String vfsName = null;
        boolean match = false;
        try {
            resource = cms.readResource(cms.getRequestContext().removeSiteRoot(rfsName));
            if (resource.isFolder() && !CmsResource.isFolder(rfsName)) {
                rfsName = rfsName + '/';
            }
            vfsName = rfsName;
            match = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!match) {
            Map exportnameFolders = this.getExportnames();
            Iterator i = exportnameFolders.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String exportName = (String)entry.getKey();
                if (!rfsName.startsWith(exportName)) continue;
                match = true;
                vfsName = "" + entry.getValue() + rfsName.substring(exportName.length());
                try {
                    resource = cms.readResource(vfsName);
                    if (!resource.isFolder()) break;
                    if (!CmsResource.isFolder(rfsName)) {
                        rfsName = rfsName + '/';
                    }
                    if (CmsResource.isFolder(vfsName)) break;
                    vfsName = vfsName + '/';
                    break;
                }
                catch (CmsVfsResourceNotFoundException e) {
                    match = false;
                }
                catch (CmsException e) {
                    break;
                }
            }
        }
        if (!match && (extPos = rfsName.lastIndexOf(46)) >= 0 && (pos = (cutName = rfsName.substring(0, extPos)).lastIndexOf(46)) >= 0 && ".jsp".equals(extension = cutName.substring(pos).toLowerCase())) {
            return this.getVfsNameInternal(cms, cutName);
        }
        if (match) {
            return vfsName;
        }
        return null;
    }

    protected String insertContextStrings(String path) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.addMacro("CONTEXT_NAME", OpenCms.getSystemInfo().getContextPath());
        resolver.addMacro("SERVLET_NAME", OpenCms.getSystemInfo().getServletPath());
        return resolver.resolveMacros(path);
    }

    protected boolean isValidRfsName(String rfsName) {
        if (rfsName != null) {
            if (rfsName.startsWith(this.m_rfsPrefix + "/")) {
                return true;
            }
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                String rfsPrefix = rule.getRfsPrefix() + "/";
                if (!rfsName.startsWith(rfsPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isValidURL(String inputString) {
        boolean isValid = false;
        try {
            if (inputString != null) {
                URL tempURL = new URL(inputString);
                isValid = tempURL.getProtocol() != null;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return isValid;
    }

    protected String normalizeExportPath(String exportPath) {
        String result = this.insertContextStrings(exportPath);
        result = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication(result);
        if (result.endsWith(File.separator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected String normalizeRfsPrefix(String rfsPrefix) {
        String result = this.insertContextStrings(rfsPrefix);
        if (!this.isValidURL(result)) {
            result = CmsFileUtil.normalizePath(result, '/');
        }
        if (CmsResource.isFolder(result = CmsFileUtil.normalizePath(result, '/'))) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrubExportFolders(I_CmsReport report) {
        if (report != null) {
            report.println(Messages.get().container("RPT_DELETING_EXPORT_FOLDERS_BEGIN_0"), 2);
        }
        Object object = this.m_lockScrubExportFolders;
        synchronized (object) {
            String exportFolderName;
            Integer size;
            int count;
            block16: {
                count = 0;
                size = new Integer(this.m_rfsRules.size() + 1);
                exportFolderName = CmsFileUtil.normalizePath(this.m_staticExportPath + '/');
                try {
                    File exportFolder = new File(exportFolderName);
                    if (exportFolder.exists() && exportFolder.canWrite()) {
                        CmsFileUtil.purgeDirectory(exportFolder);
                    }
                    ++count;
                    if (report != null) {
                        report.println(Messages.get().container("RPT_DELETE_EXPORT_FOLDER_3", new Integer(count), size, exportFolderName), 3);
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MAIN_SE_FOLDER_1", exportFolderName));
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) break block16;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_1", exportFolderName), t);
                }
            }
            Iterator it = this.m_rfsRules.iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                exportFolderName = CmsFileUtil.normalizePath(rule.getExportPath() + '/');
                try {
                    File exportFolder = new File(exportFolderName);
                    if (exportFolder.exists() && exportFolder.canWrite()) {
                        CmsFileUtil.purgeDirectory(exportFolder);
                    }
                    ++count;
                    if (report != null) {
                        report.println(Messages.get().container("RPT_DELETE_EXPORT_FOLDER_3", new Integer(count), size, exportFolderName), 3);
                        continue;
                    }
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_DEL_MAIN_SE_FOLDER_1", exportFolderName));
                }
                catch (Throwable t) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_FOLDER_DELETION_FAILED_1", exportFolderName), t);
                }
            }
        }
        if (report != null) {
            report.println(Messages.get().container("RPT_DELETING_EXPORT_FOLDERS_END_0"), 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExportnames() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_EXPORTNAME_PROP_START_0"));
        }
        CmsObject cms = null;
        try {
            cms = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
            List resources = cms.readResourcesWithProperty("exportname");
            Object object = this.m_lockSetExportnames;
            synchronized (object) {
                this.m_exportnameResources = new HashMap(resources.size());
                int n = resources.size();
                for (int i = 0; i < n; ++i) {
                    CmsResource res = (CmsResource)resources.get(i);
                    try {
                        String foldername = cms.getSitePath(res);
                        String exportname = cms.readPropertyObject(foldername, "exportname", false).getValue();
                        if (exportname == null) continue;
                        if (exportname.charAt(exportname.length() - 1) != '/') {
                            exportname = exportname + "/";
                        }
                        if (exportname.charAt(0) != '/') {
                            exportname = "/" + exportname;
                        }
                        this.m_exportnameResources.put(exportname, foldername);
                        continue;
                    }
                    catch (CmsException e) {
                        // empty catch block
                    }
                }
                this.m_exportnameResources = Collections.unmodifiableMap(this.m_exportnameResources);
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_UPDATE_EXPORTNAME_PROP_FINISHED_0"));
        }
    }

    protected void writeResource(HttpServletRequest req, String exportPath, String rfsName, CmsResource resource, byte[] content) throws CmsException {
        String exportFileName = CmsFileUtil.normalizePath(exportPath + rfsName);
        this.createExportFolder(exportPath, rfsName);
        File exportFile = new File(exportFileName);
        try {
            FileOutputStream exportStream = new FileOutputStream(exportFile);
            exportStream.write(content);
            exportStream.close();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORTED_2", resource.getRootPath(), exportFileName));
            }
        }
        catch (Throwable t) {
            throw new CmsStaticExportException(Messages.get().container("ERR_OUTPUT_STREAM_1", exportFileName), t);
        }
        if (req != null) {
            Long dateLastModified = (Long)req.getAttribute("OpenCms-Export");
            if (dateLastModified != null && dateLastModified != -1L) {
                exportFile.setLastModified(dateLastModified / 1000L * 1000L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SET_LAST_MODIFIED_2", exportFile.getName(), new Long(dateLastModified / 1000L * 1000L)));
                }
            }
        } else {
            exportFile.setLastModified(resource.getDateLastModified() / 1000L * 1000L);
        }
    }

    private static class CmsPrefixFileFilter
    implements FileFilter {
        private String m_baseName;

        public CmsPrefixFileFilter(String fileName) {
            this.m_baseName = fileName + ".";
        }

        public boolean accept(File f) {
            return f.getName().startsWith(this.m_baseName) && f.getName().length() > this.m_baseName.length() && f.getName().indexOf(46, this.m_baseName.length()) < 0;
        }
    }
}

