/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsStaticExportRfsRule {
    public static final Integer EXPORT_DEFAULT_BACKUPS = new Integer(0);
    private String m_description;
    private Integer m_exportBackups;
    private String m_exportPath;
    private final String m_exportPathConfigured;
    private String m_exportWorkPath;
    private final String m_exportWorkPathConfigured;
    private String m_name;
    private List m_relatedSystemResources;
    private final String m_rfsPreConfigured;
    private String m_rfsPrefix;
    private final Pattern m_source;
    private Boolean m_useRelativeLinks;

    public CmsStaticExportRfsRule(String name, String description, String source, String rfsPrefix, String exportPath, String exportWorkPath, Integer exportBackups, Boolean useRelativeLinks) {
        this.m_name = name;
        this.m_description = description;
        this.m_source = Pattern.compile(source);
        this.m_rfsPreConfigured = rfsPrefix;
        this.m_exportPathConfigured = exportPath;
        this.m_exportWorkPathConfigured = exportWorkPath;
        this.m_exportBackups = exportBackups;
        this.m_useRelativeLinks = useRelativeLinks;
        this.m_relatedSystemResources = new ArrayList();
    }

    public CmsStaticExportRfsRule(String name, String description, String source, String rfsPrefix, String exportPath, String exportWorkPath, Integer exportBackups, Boolean useRelativeLinks, List relatedSystemRes) {
        this(name, description, source, rfsPrefix, exportPath, exportWorkPath, exportBackups, useRelativeLinks);
        this.m_relatedSystemResources.addAll(relatedSystemRes);
    }

    public void addRelatedSystemRes(String regex) {
        this.m_relatedSystemResources.add(Pattern.compile(regex));
    }

    public String getDescription() {
        return this.m_description;
    }

    public Integer getExportBackups() {
        if (this.m_exportBackups != null) {
            return this.m_exportBackups;
        }
        return EXPORT_DEFAULT_BACKUPS;
    }

    public String getExportPath() {
        if (OpenCms.getStaticExportManager().isUseTempDir() && OpenCms.getStaticExportManager().isFullStaticExport()) {
            return this.getExportWorkPath();
        }
        return this.m_exportPath;
    }

    public String getExportPathConfigured() {
        return this.m_exportPathConfigured;
    }

    public String getExportWorkPath() {
        return this.m_exportWorkPath;
    }

    public String getExportWorkPathConfigured() {
        if (this.m_exportWorkPathConfigured != null) {
            return this.m_exportWorkPathConfigured;
        }
        return CmsStaticExportManager.EXPORT_DEFAULT_WORKPATH + OpenCms.getResourceManager().getFileTranslator().translateResource(this.m_name);
    }

    public String getLocalizedRfsName(String rfsName, String fileSeparator) {
        String locRfsName = null;
        locRfsName = CmsStringUtil.substitute(rfsName, fileSeparator + CmsLocaleManager.getDefaultLocale().toString() + fileSeparator, fileSeparator + this.getName() + fileSeparator);
        return locRfsName;
    }

    public String getName() {
        return this.m_name;
    }

    public List getRelatedSystemResources() {
        return Collections.unmodifiableList(this.m_relatedSystemResources);
    }

    public String getRfsPrefix() {
        return this.m_rfsPrefix;
    }

    public String getRfsPrefixConfigured() {
        return this.m_rfsPreConfigured;
    }

    public Pattern getSource() {
        return this.m_source;
    }

    public Boolean getUseRelativeLinks() {
        return this.m_useRelativeLinks;
    }

    public boolean match(String vfsName) {
        for (int j = 0; j < this.m_relatedSystemResources.size(); ++j) {
            Pattern pattern = (Pattern)this.m_relatedSystemResources.get(j);
            if (!pattern.matcher(vfsName).matches()) continue;
            return true;
        }
        return false;
    }

    public void setExportPath(String exportPath) {
        if (exportPath.equals(OpenCms.getSystemInfo().getWebApplicationRfsPath())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_EXPORT_PATH_1", this.m_name));
        }
        this.m_exportPath = exportPath;
    }

    public void setExportWorkPath(String exportWorkPath) {
        if (exportWorkPath.equals(OpenCms.getSystemInfo().getWebApplicationRfsPath())) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_INVALID_EXPORT_PATH_1", this.m_name));
        }
        this.m_exportWorkPath = exportWorkPath;
    }

    public void setRfsPrefix(String rfsPrefix) {
        this.m_rfsPrefix = rfsPrefix;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.getClass().getName());
        ret.append(":[");
        ret.append("name: ").append(this.m_name).append("; ");
        ret.append("description: ").append(this.m_description).append("; ");
        ret.append("source: ").append(this.m_source).append("; ");
        ret.append("exportPath: ").append(this.m_exportPath).append("; ");
        ret.append("rfsPrefix: ").append(this.m_rfsPrefix).append("; ");
        ret.append("useRelativeLinks: ").append(this.m_useRelativeLinks).append("; ");
        ret.append("relatedSystemRes: ").append(this.m_relatedSystemResources).append("; ");
        return ret.append("]").toString();
    }
}

